/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.ModelUtils;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticEntitiesProvider {
    List<SemanticEntity> list = new ArrayList<SemanticEntity>();

    public List<SemanticEntity> get() {
        return this.list;
    }

    private SemanticEntitiesProvider() {
        this.list.add(new AbstractSemanticEntity(FontColorProvider.Entity.INACTIVE_CODE){

            @Override
            public String getName() {
                return "inactive";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.getInactiveCodeBlocks(csmFile);
            }
        });
        if (!HighlighterBase.MINIMAL) {
            this.list.add(new AbstractSemanticEntity(FontColorProvider.Entity.CLASS_FIELD){

                @Override
                public String getName() {
                    return "class-fields";
                }

                @Override
                public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                    return ModelUtils.getFieldsBlocks(csmFile);
                }
            });
            this.list.add(new AbstractSemanticEntity(){

                @Override
                public String getName() {
                    return "functions-names";
                }

                @Override
                public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                    return ModelUtils.getFunctionNames(csmFile);
                }

                @Override
                public void updateFontColors(FontColorProvider fontColorProvider) {
                    this.color = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Bold, Boolean.TRUE});
                }
            });
            this.list.add(new AbstractSemanticEntity(FontColorProvider.Entity.USER_MACRO){
                protected AttributeSet sysMacroColors;

                @Override
                public String getName() {
                    return "macros";
                }

                @Override
                public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                    return ModelUtils.getMacroBlocks(csmFile);
                }

                @Override
                public AttributeSet getColor(CsmOffsetable csmOffsetable) {
                    CsmMacro csmMacro = (CsmMacro)((CsmReference)csmOffsetable).getReferencedObject();
                    return csmMacro == null || !csmMacro.isSystem() ? this.color : this.sysMacroColors;
                }

                @Override
                public void updateFontColors(FontColorProvider fontColorProvider) {
                    super.updateFontColors(fontColorProvider);
                    this.sysMacroColors = 4.getFontColor(fontColorProvider, FontColorProvider.Entity.SYSTEM_MACRO);
                }
            });
            this.list.add(new AbstractSemanticEntity(FontColorProvider.Entity.TYPEDEF){

                @Override
                public String getName() {
                    return "typedefs";
                }

                @Override
                public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                    return ModelUtils.getTypedefBlocks(csmFile);
                }
            });
        }
    }

    public static SemanticEntitiesProvider instance() {
        return Instantiator.instance;
    }

    private static class Instantiator {
        static SemanticEntitiesProvider instance = new SemanticEntitiesProvider();

        private Instantiator() {
        }
    }

    private static abstract class AbstractSemanticEntity
    implements SemanticEntity {
        protected AttributeSet color;
        private final FontColorProvider.Entity entity;
        private static final AttributeSet cleanUp = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, null, StyleConstants.StrikeThrough, null, StyleConstants.Background, null, EditorStyleConstants.WaveUnderlineColor, null});

        public AbstractSemanticEntity() {
            this.entity = null;
        }

        public AbstractSemanticEntity(FontColorProvider.Entity entity) {
            this.entity = entity;
        }

        public void updateFontColors(FontColorProvider fontColorProvider) {
            assert (this.entity != null);
            this.color = AbstractSemanticEntity.getFontColor(fontColorProvider, this.entity);
        }

        protected static AttributeSet getFontColor(FontColorProvider fontColorProvider, FontColorProvider.Entity entity) {
            return AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{fontColorProvider.getColor(entity), cleanUp});
        }

        public AttributeSet getColor(CsmOffsetable csmOffsetable) {
            return this.color;
        }
    }
}

