/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.model.tasks.CaretAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurrencesHighlighter
extends HighlighterBase {
    private static AttributeSet defaultColors;
    private static final String COLORS = "cc-highlighting-mark-occurrences";
    public static final Color ES_COLOR;
    private boolean valid = true;

    public static OffsetsBag getHighlightsBag(Document document) {
        if (document == null) {
            return null;
        }
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(MarkOccurrencesHighlighter.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document, false);
            document.putProperty(MarkOccurrencesHighlighter.class, offsetsBag);
            final OffsetsBag offsetsBag2 = offsetsBag;
            DocumentListener documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    offsetsBag2.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset(), false);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    offsetsBag2.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset(), false);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }
            };
            document.addDocumentListener(documentListener);
        }
        return offsetsBag;
    }

    private CsmFile getCsmFile() {
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)this.getDocument());
        return CsmUtilities.getCsmFile((DataObject)dataObject, (boolean)false);
    }

    private void clean() {
        BaseDocument baseDocument = this.getDocument();
        if (baseDocument != null) {
            MarkOccurrencesHighlighter.getHighlightsBag((Document)baseDocument).clear();
            OccurrencesMarkProvider.get((Document)baseDocument).setOccurrences(Collections.<Mark>emptySet());
        }
    }

    public MarkOccurrencesHighlighter(Document document) {
        super(document);
    }

    public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
        if (!SemanticHighlightingOptions.instance().getEnableMarkOccurrences()) {
            this.clean();
            this.valid = false;
            return;
        }
        if (phase == CsmFileTaskFactory.PhaseRunner.Phase.PARSED || phase == CsmFileTaskFactory.PhaseRunner.Phase.INIT) {
            BaseDocument baseDocument = this.getDocument();
            if (baseDocument == null) {
                this.clean();
                return;
            }
            CsmFile csmFile = this.getCsmFile();
            FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
            if (csmFile == null || fileObject == null) {
                this.clean();
                return;
            }
            int n = CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)fileObject);
            HighlightsSequence highlightsSequence = MarkOccurrencesHighlighter.getHighlightsBag((Document)baseDocument).getHighlights(0, baseDocument.getLength() - 1);
            while (highlightsSequence.moveNext()) {
                if (n < highlightsSequence.getStartOffset() || n > highlightsSequence.getEndOffset()) continue;
                return;
            }
            Collection<CsmReference> collection = MarkOccurrencesHighlighter.getOccurrences(csmFile, n);
            if (collection.isEmpty()) {
                if (!SemanticHighlightingOptions.instance().getKeepMarks()) {
                    this.clean();
                }
            } else {
                OffsetsBag offsetsBag = new OffsetsBag((Document)baseDocument);
                offsetsBag.clear();
                for (CsmReference csmReference : collection) {
                    offsetsBag.addHighlight(csmReference.getStartOffset(), csmReference.getEndOffset(), defaultColors);
                }
                MarkOccurrencesHighlighter.getHighlightsBag((Document)baseDocument).setHighlights(offsetsBag);
                OccurrencesMarkProvider.get((Document)baseDocument).setOccurrences(OccurrencesMarkProvider.createMarks((Document)baseDocument, collection, ES_COLOR, NbBundle.getMessage(MarkOccurrencesHighlighter.class, (String)"LBL_ES_TOOLTIP")));
            }
        } else if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP) {
            this.clean();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    static Collection<CsmReference> getOccurrences(CsmFile csmFile, int n) {
        CsmReference csmReference;
        Collection<Object> collection = Collections.emptyList();
        if (csmFile != null && csmFile.isParsed() && (csmReference = CsmReferenceResolver.getDefault().findReference(csmFile, n)) != null && csmReference.getReferencedObject() != null) {
            collection = CsmReferenceRepository.getDefault().getReferences(csmReference.getReferencedObject(), csmFile, CsmReferenceKind.ALL);
        }
        return collection;
    }

    @Override
    protected void updateFontColors(FontColorProvider fontColorProvider) {
        defaultColors = fontColorProvider.getColor(FontColorProvider.Entity.MARK_OCCURENCES);
    }

    static {
        ES_COLOR = new Color(175, 172, 102);
    }
}

