/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.vmd.api.screen.display.DeviceBorder;
import org.netbeans.modules.vmd.api.screen.display.DeviceTheme;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidpScreenDeviceInfo
extends ScreenDeviceInfo {
    protected DeviceBorder[] deviceBorders;
    private static final String IMAGE_BASE = "org/netbeans/modules/vmd/screen/resources/display/";
    private static final String[] IMAGE_NAMES = new String[]{"top.png", "top_right.png", "right.png", "bottom_right.png", "bottom.png", "bottom_left.png", "left.png", "top_left.png"};
    private Dimension currentScreenSize;
    private ArrayList<Dimension> customScreenSizes = new ArrayList();
    private DeviceTheme deviceTheme;

    public MidpScreenDeviceInfo() {
        this.loadImages();
        this.customScreenSizes.add(new Dimension(240, 320));
        this.customScreenSizes.add(new Dimension(128, 160));
        this.currentScreenSize = this.customScreenSizes.get(0);
    }

    public String getDeviceInfoID() {
        return "DefaultDevice";
    }

    public DeviceTheme getDeviceTheme() {
        if (this.deviceTheme == null) {
            this.deviceTheme = new MidpDeviceTheme();
        }
        return this.deviceTheme;
    }

    public Dimension getCurrentScreenSize() {
        return this.currentScreenSize;
    }

    public boolean supportsCustomScreenSize() {
        return true;
    }

    public Collection<Dimension> getCustomScreenSizes() {
        return this.customScreenSizes;
    }

    public boolean supportsArbitraryScreenSize() {
        return true;
    }

    public void setArbitraryScreenSize(Dimension dimension) {
        this.currentScreenSize = dimension;
    }

    public DeviceBorder getDeviceBorder(ScreenDeviceInfo.Edge edge) {
        return this.deviceBorders[edge.ordinal()];
    }

    protected void loadImages() {
        this.deviceBorders = new DeviceBorder[IMAGE_NAMES.length];
        for (int i = 0; i < IMAGE_NAMES.length; ++i) {
            this.deviceBorders[i] = new DeviceBorder(Utilities.loadImage((String)(IMAGE_BASE + IMAGE_NAMES[i])));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MidpDeviceTheme
    extends DeviceTheme {
        private static final int FONT_SIZE_SMALL = 10;
        private static final int FONT_SIZE_MEDIUM = 12;
        private static final int FONT_SIZE_LARGE = 16;
        private static final String FONT_FACE_MONOSPACE = "Monospaced";
        private static final String FONT_FACE_PROPORTIONAL = "Dialog";
        private static final String FONT_FACE_SYSTEM = "Dialog";
        private static final Font FONT_DEFAULT = new Font("Dialog", 0, 12);
        private static final Font FONT_INPUT_TEXT = new Font("Dialog", 0, 12);
        private static final Font FONT_STATIC_TEXT = new Font("Dialog", 0, 12);
        private static final Map<TextAttribute, Integer> ATTR_MAP = new HashMap<TextAttribute, Integer>(1);

        public Font getFont(DeviceTheme.FontType fontType) {
            switch (fontType) {
                case INPUT_TEXT: {
                    return FONT_INPUT_TEXT;
                }
                case STATIC_TEXT: {
                    return FONT_STATIC_TEXT;
                }
            }
            return FONT_DEFAULT;
        }

        public Font getFont(DeviceTheme.FontFace fontFace, EnumSet<DeviceTheme.FontStyle> enumSet, DeviceTheme.FontSize fontSize) {
            String string = "Dialog";
            if (fontFace == DeviceTheme.FontFace.MONOSPACE) {
                string = FONT_FACE_MONOSPACE;
            } else if (fontFace == DeviceTheme.FontFace.PROPORTIONAL) {
                string = "Dialog";
            }
            int n = 0;
            if (enumSet.contains(DeviceTheme.FontStyle.BOLD)) {
                n |= 1;
            }
            if (enumSet.contains(DeviceTheme.FontStyle.ITALIC)) {
                n |= 2;
            }
            int n2 = 12;
            if (fontSize == DeviceTheme.FontSize.LARGE) {
                n2 = 16;
            } else if (fontSize == DeviceTheme.FontSize.SMALL) {
                n2 = 10;
            }
            Font font = new Font(string, n, n2);
            if (enumSet.contains(DeviceTheme.FontStyle.UNDERLINED)) {
                font = font.deriveFont(ATTR_MAP);
            }
            return font;
        }

        public Color getColor(DeviceTheme.Colors colors) {
            if (DeviceTheme.Colors.BACKGROUND == colors) {
                return Color.WHITE;
            }
            if (DeviceTheme.Colors.FOREGROUND == colors) {
                return Color.BLACK;
            }
            if (DeviceTheme.Colors.HIGHLIGHTED == colors) {
                return Color.RED;
            }
            return null;
        }

        static {
            ATTR_MAP.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
    }
}

