/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.components.commands.ListSelectCommandCD;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorListSelectCommand
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, DesignComponent> values = new TreeMap<String, DesignComponent>();
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private TypeID typeID;
    private String noneItem;
    private String defaultItem;

    public static PropertyEditorListSelectCommand createInstance() {
        String string = NbBundle.getMessage(PropertyEditorListSelectCommand.class, (String)"LBL_SEL_COMMAND_STR");
        String string2 = NbBundle.getMessage(PropertyEditorListSelectCommand.class, (String)"LBL_SELECTCOMMAND_NONE");
        String string3 = NbBundle.getMessage(PropertyEditorListSelectCommand.class, (String)"LBL_SELECTCOMMAND_DEFAULT");
        String string4 = NbBundle.getMessage(PropertyEditorListSelectCommand.class, (String)"LBL_SELECTCOMMAND_UCLABEL");
        return new PropertyEditorListSelectCommand(ListSelectCommandCD.TYPEID, string, string2, string3, string4);
    }

    private PropertyEditorListSelectCommand(TypeID typeID, String string, String string2, String string3, String string4) {
        super(string4);
        this.initComponents();
        this.typeID = typeID;
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)string);
        this.noneItem = string2;
        this.defaultItem = string3;
        this.initElements(Collections.singleton(this));
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor();
        this.radioButton.addActionListener(this.customEditor);
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return this.noneItem;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return this.getDecodeValue(propertyValue);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public void updateState(PropertyValue propertyValue) {
        this.customEditor.updateModel();
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setValue(null);
        } else {
            this.customEditor.setValue(propertyValue);
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        if (string.length() > 0) {
            if (this.noneItem.equals(string)) {
                super.setValue((Object)NULL_VALUE);
            } else {
                super.setValue((Object)PropertyValue.createComponentReference((DesignComponent)this.getCommandEvenSource(string)));
            }
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public Boolean canEditAsText() {
        return null;
    }

    public String[] getTags() {
        this.tags.clear();
        if (this.isCurrentValueAUserCodeType()) {
            this.tags.add(PropertyEditorUserCode.USER_CODE_TEXT);
        } else {
            this.tags.add(this.noneItem);
            this.values.clear();
            this.values.put(this.noneItem, null);
            if (this.component != null && this.component.get() != null) {
                final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
                designDocument.getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        Object object;
                        Collection collection = MidpDocumentSupport.getCategoryComponent(designDocument, CommandsCategoryCD.TYPEID).getComponents();
                        ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>(collection.size());
                        for (DesignComponent designComponent : collection) {
                            object = designComponent.readProperty("ordinary");
                            if (!MidpTypes.getBoolean(object)) continue;
                            arrayList.add(designComponent);
                        }
                        PropertyEditorListSelectCommand.this.tags.add(PropertyEditorListSelectCommand.this.defaultItem);
                        PropertyEditorListSelectCommand.this.values.put(PropertyEditorListSelectCommand.this.defaultItem, PropertyEditorListSelectCommand.this.getListSelectCommand(designDocument));
                        for (DesignComponent designComponent : arrayList) {
                            object = PropertyEditorListSelectCommand.this.getComponentDisplayName(designComponent);
                            PropertyEditorListSelectCommand.this.tags.add(object);
                            PropertyEditorListSelectCommand.this.values.put(object, designComponent);
                        }
                    }
                });
            }
        }
        return this.tags.toArray(new String[this.tags.size()]);
    }

    private DesignComponent getListSelectCommand(DesignDocument designDocument) {
        return MidpDocumentSupport.getSingletonCommand(designDocument, this.typeID);
    }

    private String getComponentDisplayName(DesignComponent designComponent) {
        return MidpValueSupport.getHumanReadableString(designComponent);
    }

    private String getDecodeValue(final PropertyValue propertyValue) {
        DesignDocument designDocument;
        final String[] stringArray = new String[1];
        DesignComponent designComponent = propertyValue.getComponent();
        if (designComponent != null && (designDocument = designComponent.getDocument()) != null) {
            designDocument.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent;
                    PropertyValue propertyValue2;
                    DesignComponent designComponent2 = propertyValue.getComponent();
                    stringArray[0] = designComponent2 != null ? ((propertyValue2 = designComponent2.readProperty("command")) != null ? ((designComponent = propertyValue2.getComponent()) != null && designComponent.equals(PropertyEditorListSelectCommand.this.getListSelectCommand(designDocument)) ? PropertyEditorListSelectCommand.this.defaultItem : PropertyEditorListSelectCommand.this.getComponentDisplayName(designComponent2)) : PropertyEditorListSelectCommand.this.noneItem) : PropertyEditorListSelectCommand.this.noneItem;
                }
            });
        }
        return stringArray[0];
    }

    private DesignComponent getCommandEvenSource(final String string) {
        final DesignComponent[] designComponentArray = new DesignComponent[1];
        if (this.component != null && this.component.get() != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent3 = (DesignComponent)PropertyEditorListSelectCommand.this.values.get(string);
                    List list = designComponent.readProperty("commands").getArray();
                    for (PropertyValue propertyValue : list) {
                        DesignComponent designComponent2 = propertyValue.getComponent();
                        if (!designComponent2.readProperty("command").getComponent().equals(designComponent3)) continue;
                        designComponentArray[0] = designComponent2;
                        break;
                    }
                    if (designComponentArray[0] == null) {
                        designComponentArray[0] = MidpDocumentSupport.attachCommandToDisplayable(designComponent, designComponent3);
                    }
                }
            });
        }
        return designComponentArray[0];
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JComboBox combobox;

        public CustomEditor() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.combobox = new JComboBox();
            this.combobox.setModel(new DefaultComboBoxModel());
            this.combobox.addActionListener(this);
            this.add((Component)this.combobox, "Center");
            this.combobox.getAccessibleContext().setAccessibleName(PropertyEditorListSelectCommand.this.radioButton.getAccessibleContext().getAccessibleName());
            this.combobox.getAccessibleContext().setAccessibleDescription(PropertyEditorListSelectCommand.this.radioButton.getAccessibleContext().getAccessibleDescription());
        }

        public void setValue(final PropertyValue propertyValue) {
            DesignComponent designComponent;
            if (propertyValue == null) {
                this.combobox.setSelectedItem(PropertyEditorListSelectCommand.this.noneItem);
                return;
            }
            final PropertyValue[] propertyValueArray = new PropertyValue[1];
            if (PropertyEditorListSelectCommand.this.component != null && PropertyEditorListSelectCommand.this.component.get() != null) {
                designComponent = ((DesignComponent)PropertyEditorListSelectCommand.this.component.get()).getDocument();
                designComponent.getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        propertyValueArray[0] = propertyValue.getComponent().readProperty("command");
                    }
                });
            }
            if (propertyValueArray[0] == null) {
                return;
            }
            designComponent = propertyValueArray[0].getComponent();
            for (String string : PropertyEditorListSelectCommand.this.values.keySet()) {
                DesignComponent designComponent2 = (DesignComponent)PropertyEditorListSelectCommand.this.values.get(string);
                if (designComponent2 == null || !designComponent2.equals(designComponent)) continue;
                this.combobox.setSelectedItem(string);
                break;
            }
        }

        public String getText() {
            return (String)this.combobox.getSelectedItem();
        }

        public void updateModel() {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.combobox.getModel();
            defaultComboBoxModel.removeAllElements();
            for (String string : PropertyEditorListSelectCommand.this.tags) {
                defaultComboBoxModel.addElement(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyEditorListSelectCommand.this.radioButton.setSelected(true);
        }
    }
}

