/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.palette.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.vmd.api.io.javame.MidpProjectPropertiesSupport;
import org.netbeans.modules.vmd.midp.palette.wizard.AddToPaletteWizardPanel1;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class AddToPaletteVisualPanel1
extends JPanel {
    private static final String MSG_NO_PROJECTS = "MSG_ERR_NoOpenedProjects";
    private AddToPaletteWizardPanel1 wizardPanel;
    private JComboBox projectCombo;

    public AddToPaletteVisualPanel1(AddToPaletteWizardPanel1 addToPaletteWizardPanel1) {
        this.wizardPanel = addToPaletteWizardPanel1;
        this.initComponents();
    }

    public String getName() {
        return NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"TITLE_SelectProject");
    }

    public Project getActiveProject() {
        Object object = this.projectCombo.getSelectedItem();
        if (object instanceof Project) {
            return (Project)object;
        }
        return null;
    }

    public int getProjectsCount() {
        if (this.projectCombo.getItemAt(0).equals(MSG_NO_PROJECTS)) {
            return 0;
        }
        return this.projectCombo.getItemCount();
    }

    public void reload(Project project) {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        Vector<Object> vector = new Vector<Object>();
        for (Project project2 : projectArray) {
            if (!MidpProjectPropertiesSupport.isMobileProject((Project)project2)) continue;
            vector.add(project2);
        }
        if (vector.size() == 0) {
            vector.add(AddToPaletteVisualPanel1.getMessage(MSG_NO_PROJECTS));
            this.projectCombo.setEnabled(false);
            this.projectCombo.setRenderer(new DefaultListCellRenderer());
            this.projectCombo.setModel(new DefaultComboBoxModel(vector));
        } else {
            this.projectCombo.setEnabled(true);
            this.projectCombo.setRenderer(new ProjectListCellRenderer());
            this.projectCombo.setModel(new DefaultComboBoxModel(vector));
            this.setProjectSelection(projectArray, project);
        }
    }

    private void setProjectSelection(Project[] projectArray, Project project) {
        Project project2;
        if (project == null && MidpProjectPropertiesSupport.isMobileProject((Project)(project2 = OpenProjects.getDefault().getMainProject()))) {
            project = project2;
        }
        if (project == null && projectArray.length > 0) {
            project = projectArray[0];
        }
        this.projectCombo.setSelectedItem(project);
    }

    private void initComponents() {
        this.projectCombo = new JComboBox();
        JLabel jLabel = new JLabel();
        this.projectCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddToPaletteVisualPanel1.this.projectComboActionPerformed(actionEvent);
            }
        });
        jLabel.setLabelFor(this.projectCombo);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"DISP_SelectProject"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel).add((Component)this.projectCombo, 0, 376, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)jLabel).addPreferredGap(0).add((Component)this.projectCombo, -2, -1, -2).addContainerGap(243, Short.MAX_VALUE)));
        this.projectCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"ACCESSIBLE_NAME_projectCombo"));
        this.projectCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"ACCESSIBLE_DESCRIPTION_projectCombo"));
        jLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"ACCESSIBLE_NAME_jLabel1_2"));
        jLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)"ACCESSIBLE_DESCRIPTION_jLabel1_2"));
    }

    private void projectComboActionPerformed(ActionEvent actionEvent) {
        this.wizardPanel.fireChangeEvent();
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(AddToPaletteVisualPanel1.class, (String)string);
    }

    public static class ProjectListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
            ProjectInformation projectInformation = (ProjectInformation)((Project)object).getLookup().lookup(ProjectInformation.class);
            super.getListCellRendererComponent((JList<?>)jList, projectInformation != null ? projectInformation.getDisplayName() : null, n, bl, bl2);
            if (projectInformation != null) {
                this.setIcon(projectInformation.getIcon());
            }
            return this;
        }
    }
}

