/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.handlers;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.components.general.ClassSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class EventHandlerSupport {
    private static final InfoPresenter.Resolver SWITCH_DISPLAYABLE_EVENT_HANDLER_INFO_RESOLVER = new SwitchDisplayableResolver();

    public static InfoPresenter.Resolver getSwitchDisplayableEventHandlerInfoResolver() {
        return SWITCH_DISPLAYABLE_EVENT_HANDLER_INFO_RESOLVER;
    }

    private static class SwitchDisplayableResolver
    implements InfoPresenter.Resolver {
        private SwitchDisplayableResolver() {
        }

        public DesignEventFilter getEventFilter(DesignComponent designComponent) {
            return new DesignEventFilter(new DesignEventFilter[0]).addDescentFilter(designComponent, "displayable").addDescentFilter(designComponent, "alert");
        }

        public String getDisplayName(DesignComponent designComponent, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    String string;
                    DesignComponent designComponent2 = designComponent.readProperty("displayable").getComponent();
                    DesignComponent designComponent3 = designComponent.readProperty("alert").getComponent();
                    if (designComponent2 == null) {
                        return NbBundle.getMessage(EventHandlerSupport.class, (String)"DISP_Handler_Clear_Display");
                    }
                    String string2 = ClassSupport.resolveDisplayName(designComponent2);
                    String string3 = string = designComponent3 != null ? ClassSupport.resolveDisplayName(designComponent3) : null;
                    if (string != null) {
                        return NbBundle.getMessage(EventHandlerSupport.class, (String)"DISP_Handler_Go_to_displayable_alert", (Object)string2, (Object)string);
                    }
                    return NbBundle.getMessage(EventHandlerSupport.class, (String)"DISP_Handler_Go_to_displayable", (Object)string2);
                }
                case SECONDARY: {
                    return NbBundle.getMessage(EventHandlerSupport.class, (String)"TYPE_Action");
                }
                case TERTIARY: {
                    return null;
                }
            }
            throw Debug.illegalState((Object[])new Object[0]);
        }

        public boolean isEditable(DesignComponent designComponent) {
            return false;
        }

        public String getEditableName(DesignComponent designComponent) {
            return null;
        }

        public void setEditableName(DesignComponent designComponent, String string) {
        }

        public Image getIcon(DesignComponent designComponent, InfoPresenter.IconType iconType) {
            switch (iconType) {
                case COLOR_16x16: {
                    return Utilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/components/displayable_16.png");
                }
                case COLOR_32x32: {
                    return Utilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/components/displayable_32.png");
                }
            }
            return null;
        }
    }
}

