/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacElements;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.JComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.CPInterfaceMethodInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.classfile.LocalVariableTableEntry;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.TreeLoader;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryAnalyser
implements LowMemoryListener {
    private static final Logger LOGGER = Logger.getLogger(BinaryAnalyser.class.getName());
    static final String OBJECT = Object.class.getName();
    private static boolean FULL_INDEX = Boolean.getBoolean("org.netbeans.modules.java.source.usages.BinaryAnalyser.fullIndex");
    private final Index index;
    private final Map<Pair<String, String>, Object[]> refs = new HashMap<Pair<String, String>, Object[]>();
    private final Set<Pair<String, String>> toDelete = new HashSet<Pair<String, String>>();
    private final AtomicBoolean lowMemory;
    private Continuation cont;

    public BinaryAnalyser(Index index) {
        assert (index != null);
        this.index = index;
        this.lowMemory = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Result start(URL uRL, ProgressHandle progressHandle, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) throws IOException, IllegalArgumentException {
        assert (uRL != null);
        assert (this.cont == null);
        LowMemoryNotifier.getDefault().addLowMemoryListener(this);
        try {
            Object object;
            block29: {
                String string;
                block27: {
                    block28: {
                        string = uRL.getProtocol();
                        if (!"jar".equals(string)) break block27;
                        object = FileUtil.getArchiveFile((URL)uRL);
                        if (!"file".equals(((URL)object).getProtocol())) break block28;
                        File file = new File(URI.create(((URL)object).toExternalForm()));
                        if (file.exists() && file.canRead()) {
                            if (progressHandle != null) {
                                progressHandle.setDisplayName(NbBundle.getMessage(BinaryAnalyser.class, (String)"MSG_Scannig", (Object)file.getAbsolutePath()));
                            }
                            if (!this.isUpToDate(null, file.lastModified())) {
                                this.index.clear();
                                if (progressHandle != null) {
                                    progressHandle.setDisplayName(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing", (Object)file.getAbsolutePath()));
                                }
                                try {
                                    ZipFile zipFile = new ZipFile(file);
                                    BinaryAnalyser.prebuildArgs(zipFile, uRL);
                                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                                    this.cont = new ZipContinuation(zipFile, enumeration, atomicBoolean, atomicBoolean2);
                                    Result result = this.cont.execute();
                                    return result;
                                }
                                catch (ZipException zipException) {
                                    LOGGER.warning("Broken zip file: " + file.getAbsolutePath());
                                }
                            }
                        }
                        break block29;
                    }
                    FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                    if (fileObject != null) {
                        if (progressHandle != null) {
                            progressHandle.setDisplayName(NbBundle.getMessage(BinaryAnalyser.class, (String)"MSG_Scannig", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)));
                        }
                        if (!this.isUpToDate(null, fileObject.lastModified().getTime())) {
                            this.index.clear();
                            if (progressHandle != null) {
                                progressHandle.setDisplayName(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)));
                            }
                            Enumeration enumeration = fileObject.getData(true);
                            this.cont = new FileObjectContinuation(enumeration, atomicBoolean, atomicBoolean2);
                            Result result = this.cont.execute();
                            return result;
                        }
                    }
                    break block29;
                }
                if ("file".equals(string)) {
                    object = new File(URI.create(uRL.toExternalForm()));
                    if (((File)object).isDirectory()) {
                        File[] fileArray;
                        String string2 = ((File)object).getAbsolutePath();
                        if (string2.charAt(string2.length() - 1) != File.separatorChar) {
                            string2 = string2 + File.separatorChar;
                        }
                        if (progressHandle != null) {
                            progressHandle.setDisplayName(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing", (Object)((File)object).getAbsolutePath()));
                        }
                        LinkedList<File> linkedList = new LinkedList<File>();
                        if (((File)object).isDirectory() && ((File)object).canRead() && (fileArray = ((File)object).listFiles()) != null) {
                            linkedList.addAll(Arrays.asList(fileArray));
                        }
                        this.cont = new FolderContinuation(linkedList, string2, atomicBoolean, atomicBoolean2);
                        Result result = this.cont.execute();
                        return result;
                    }
                } else {
                    object = URLMapper.findFileObject((URL)uRL);
                    if (object != null) {
                        if (progressHandle != null) {
                            progressHandle.setDisplayName(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing", (Object)FileUtil.getFileDisplayName((FileObject)object)));
                        }
                        this.index.clear();
                        Enumeration enumeration = object.getData(true);
                        this.cont = new FileObjectContinuation(enumeration, atomicBoolean, atomicBoolean2);
                        Result result = this.cont.execute();
                        return result;
                    }
                }
            }
            object = Result.FINISHED;
            return object;
        }
        finally {
            LowMemoryNotifier.getDefault().removeLowMemoryListener(this);
        }
    }

    public Result resume() throws IOException {
        assert (this.cont != null);
        return this.cont.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long finish() throws IOException {
        long l = 0L;
        if (this.cont != null) {
            l = this.cont.finish();
            this.cont = null;
        }
        long l2 = System.currentTimeMillis();
        try {
            this.store();
        }
        finally {
            long l3 = System.currentTimeMillis();
            l += l3 - l2;
        }
        return l;
    }

    public void clear() throws IOException {
        if (this.cont != null) {
            this.cont.finish();
            this.cont = null;
        }
        this.index.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result analyseFolder(LinkedList<File> linkedList, String string, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) throws IOException {
        while (!linkedList.isEmpty()) {
            Object object;
            File file = linkedList.removeFirst();
            if (file.isDirectory() && file.canRead()) {
                object = file.listFiles();
                if (object != null) {
                    linkedList.addAll(Arrays.asList(object));
                }
            } else if (this.accepts(file.getName())) {
                int n;
                object = file.getAbsolutePath();
                long l = file.lastModified();
                int n2 = ((String)object).lastIndexOf(46);
                int n3 = n2 > (n = ((String)object).lastIndexOf(47)) ? n2 : ((String)object).length();
                String string2 = FileObjects.convertFolder2Package(((String)object).substring(string.length(), n3));
                if (this.accepts(file.getName()) && !this.isUpToDate(string2, l)) {
                    this.toDelete.add(Pair.of(string2, null));
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                        try {
                            this.analyse(bufferedInputStream);
                        }
                        catch (InvalidClassFormatException invalidClassFormatException) {
                            LOGGER.warning("Invalid class file format: " + file.getAbsolutePath());
                        }
                        finally {
                            ((InputStream)bufferedInputStream).close();
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.warning("Cannot read file: " + file.getAbsolutePath());
                        LOGGER.log(Level.FINE, null, iOException);
                    }
                    if (this.lowMemory.getAndSet(false)) {
                        this.store();
                    }
                }
            }
            if (atomicBoolean.getAndSet(false)) {
                this.store();
                return Result.CANCELED;
            }
            if (!atomicBoolean2.get()) continue;
            return Result.CLOSED;
        }
        return Result.FINISHED;
    }

    private Result analyseArchive(ZipFile zipFile, Enumeration<? extends ZipEntry> enumeration, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) throws IOException {
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.isDirectory() && this.accepts(zipEntry.getName())) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                try {
                    this.analyse(bufferedInputStream);
                }
                catch (InvalidClassFormatException invalidClassFormatException) {
                    LOGGER.warning("Invalid class file format: " + new File(zipFile.getName()).toURI() + "!/" + zipEntry.getName());
                }
                catch (IOException iOException) {
                    Exceptions.attachMessage((Throwable)iOException, (String)("While scanning: " + zipEntry.getName()));
                    throw iOException;
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                if (this.lowMemory.getAndSet(false)) {
                    this.store();
                }
            }
            if (atomicBoolean.getAndSet(false)) {
                this.store();
                return Result.CANCELED;
            }
            if (!atomicBoolean2.get()) continue;
            return Result.CLOSED;
        }
        return Result.FINISHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result analyseFileObjects(Enumeration<? extends FileObject> enumeration, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) throws IOException {
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = enumeration.nextElement();
            if (this.accepts(fileObject.getName())) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject.getInputStream());
                try {
                    this.analyse(bufferedInputStream);
                }
                catch (InvalidClassFormatException invalidClassFormatException) {
                    LOGGER.warning("Invalid class file format: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                if (this.lowMemory.getAndSet(false)) {
                    this.store();
                }
            }
            if (atomicBoolean.getAndSet(false)) {
                this.store();
                return Result.CANCELED;
            }
            if (!atomicBoolean2.get()) continue;
            return Result.CLOSED;
        }
        return Result.FINISHED;
    }

    private final void delete(String string) throws IOException {
        assert (string != null);
        if (!this.index.isValid(false)) {
            return;
        }
        this.toDelete.add(Pair.of(string, null));
    }

    @Override
    public void lowMemory(LowMemoryEvent lowMemoryEvent) {
        this.lowMemory.set(true);
    }

    private boolean accepts(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1 || n + 1 == string.length()) {
            return false;
        }
        return "CLASS".equalsIgnoreCase(string.substring(n + 1));
    }

    private void analyse(InputStream inputStream) throws IOException {
        ClassFile classFile = new ClassFile(inputStream);
        ClassName className = classFile.getName();
        String string = BinaryAnalyser.nameToString(className);
        this.delete(string);
        Map<ClassName, Set<ClassIndexImpl.UsageType>> map = this.performAnalyse(classFile, string);
        ElementKind elementKind = ElementKind.CLASS;
        if (classFile.isEnum()) {
            elementKind = ElementKind.ENUM;
        } else if (classFile.isAnnotation()) {
            elementKind = ElementKind.ANNOTATION_TYPE;
        } else if ((classFile.getAccess() & 0x200) == 512) {
            elementKind = ElementKind.INTERFACE;
        }
        String string2 = string + DocumentUtil.encodeKind(elementKind);
        Pair<String, Object> pair = Pair.of(string2, null);
        List<String> list = this.getClassReferences(pair);
        for (Map.Entry<ClassName, Set<ClassIndexImpl.UsageType>> entry : map.entrySet()) {
            ClassName className2 = entry.getKey();
            Set<ClassIndexImpl.UsageType> set = entry.getValue();
            list.add(DocumentUtil.encodeUsage(BinaryAnalyser.nameToString(className2), set));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        try {
            if (this.refs.size() > 0 || this.toDelete.size() > 0) {
                this.index.store(this.refs, this.toDelete);
            }
        }
        finally {
            this.refs.clear();
            this.toDelete.clear();
        }
    }

    private final boolean isUpToDate(String string, long l) throws IOException {
        return this.index.isUpToDate(string, l);
    }

    private Map<ClassName, Set<ClassIndexImpl.UsageType>> performAnalyse(ClassFile classFile, String string) throws IOException {
        Object object;
        ClassName[] classNameArray;
        HashMap<ClassName, Set<ClassIndexImpl.UsageType>> hashMap = new HashMap<ClassName, Set<ClassIndexImpl.UsageType>>();
        String string2 = classFile.getTypeSignature();
        if (string2 != null) {
            try {
                classNameArray = ClassFileUtil.getTypesFromClassTypeSignature(string2);
                for (ClassName className : classNameArray) {
                    BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
            }
            catch (RuntimeException runtimeException) {
                StackTraceElement[] stackTraceElementArray;
                object = new StringBuilder("BinaryAnalyser: Cannot read type: " + string2 + " cause: " + runtimeException.getLocalizedMessage() + '\n');
                for (StackTraceElement object2 : stackTraceElementArray = runtimeException.getStackTrace()) {
                    ((StringBuilder)object).append(object2.toString());
                    ((StringBuilder)object).append('\n');
                }
                LOGGER.warning(((StringBuilder)object).toString());
            }
        }
        if ((classNameArray = classFile.getSuperClass()) != null) {
            BinaryAnalyser.addUsage(hashMap, (ClassName)classNameArray, ClassIndexImpl.UsageType.SUPER_CLASS);
        }
        object = classFile.getInterfaces();
        ConstantPool constantPool = object.iterator();
        while (constantPool.hasNext()) {
            ClassName className = (ClassName)constantPool.next();
            BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.SUPER_INTERFACE);
        }
        if (FULL_INDEX) {
            ClassName[] classNameArray2;
            List list;
            Object object2;
            Object object32;
            Object object4;
            constantPool = classFile.getConstantPool();
            Collection collection = constantPool.getAllConstants(CPFieldInfo.class);
            for (CPFieldInfo cPFieldInfo : collection) {
                ClassName className = ClassFileUtil.getType(constantPool.getClass(cPFieldInfo.getClassID()));
                if (className == null) continue;
                BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.FIELD_REFERENCE);
            }
            Object object6 = constantPool.getAllConstants(CPMethodInfo.class);
            Object object7 = object6.iterator();
            while (object7.hasNext()) {
                CPMethodInfo cPMethodInfo = (CPMethodInfo)object7.next();
                object4 = ClassFileUtil.getType(constantPool.getClass(cPMethodInfo.getClassID()));
                if (object4 == null) continue;
                BinaryAnalyser.addUsage(hashMap, (ClassName)object4, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            object6 = constantPool.getAllConstants(CPInterfaceMethodInfo.class);
            object7 = object6.iterator();
            while (object7.hasNext()) {
                CPMethodInfo cPMethodInfo = (CPMethodInfo)object7.next();
                object4 = ClassFileUtil.getType(constantPool.getClass(cPMethodInfo.getClassID()));
                if (object4 == null) continue;
                BinaryAnalyser.addUsage(hashMap, (ClassName)object4, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            object7 = classFile.getMethods();
            Iterator iterator = object7.iterator();
            while (iterator.hasNext()) {
                int n;
                LocalVariableTableEntry[] localVariableTableEntryArray;
                int n2;
                ClassName[] classNameArray3;
                object4 = (Method)iterator.next();
                object32 = object4.getReturnType();
                object2 = ClassFileUtil.getType((String)object32);
                if (object2 != null) {
                    BinaryAnalyser.addUsage(hashMap, object2, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                list = object4.getParameters();
                classNameArray2 = list.iterator();
                while (classNameArray2.hasNext()) {
                    classNameArray3 = (ClassName[])classNameArray2.next();
                    object32 = classNameArray3.getDescriptor();
                    object2 = ClassFileUtil.getType((String)object32);
                    if (object2 == null) continue;
                    BinaryAnalyser.addUsage(hashMap, object2, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                classNameArray3 = classNameArray2 = object4.getExceptionClasses();
                int n3 = classNameArray3.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    CPClassInfo cPClassInfo = classNameArray3[n2];
                    object2 = cPClassInfo.getClassName();
                    if (object2 == null) continue;
                    BinaryAnalyser.addUsage(hashMap, object2, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                object32 = object4.getTypeSignature();
                if (object32 != null) {
                    try {
                        ClassName[] classNameArray4 = classNameArray3 = ClassFileUtil.getTypesFromMethodTypeSignature((String)object32);
                        n2 = classNameArray4.length;
                        for (int i = 0; i < n2; ++i) {
                            ClassName className = classNameArray4[i];
                            BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        LOGGER.warning("Invalid method signature: " + string + "::" + object4.getName() + " signature is:" + (String)object32);
                    }
                }
                if ((classNameArray3 = object4.getCode()) == null) continue;
                LocalVariableTableEntry[] localVariableTableEntryArray2 = localVariableTableEntryArray = classNameArray3.getLocalVariableTable();
                int n4 = localVariableTableEntryArray2.length;
                for (n = 0; n < n4; ++n) {
                    LocalVariableTableEntry localVariableTableEntry = localVariableTableEntryArray2[n];
                    object2 = ClassFileUtil.getType(localVariableTableEntry.getDescription());
                    if (object2 == null) continue;
                    BinaryAnalyser.addUsage(hashMap, object2, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                LocalVariableTableEntry[] localVariableTableEntryArray3 = localVariableTableEntryArray2 = object4.getCode().getLocalVariableTypeTable();
                n = localVariableTableEntryArray3.length;
                for (int i = 0; i < n; ++i) {
                    LocalVariableTableEntry localVariableTableEntry = localVariableTableEntryArray3[i];
                    try {
                        ClassName[] classNameArray5;
                        for (ClassName className : classNameArray5 = ClassFileUtil.getTypesFromFiledTypeSignature(localVariableTableEntry.getSignature())) {
                            BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        }
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        LOGGER.warning("Invalid local variable signature: " + string + "::" + object4.getName());
                    }
                }
            }
            Collection collection2 = classFile.getVariables();
            for (Object object32 : collection2) {
                object2 = object32.getDescriptor();
                list = ClassFileUtil.getType((String)object2);
                if (list != null) {
                    BinaryAnalyser.addUsage(hashMap, (ClassName)list, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                if ((object2 = object32.getTypeSignature()) == null) continue;
                try {
                    for (ClassName className : classNameArray2 = ClassFileUtil.getTypesFromFiledTypeSignature((String)object2)) {
                        BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    LOGGER.warning("Invalid field signature: " + string + "::" + object32.getName() + " signature is: " + (String)object2);
                }
            }
            object4 = constantPool.getAllConstants(CPClassInfo.class);
            object32 = object4.iterator();
            while (object32.hasNext()) {
                object2 = (CPClassInfo)object32.next();
                list = ClassFileUtil.getType((CPClassInfo)object2);
                if (list == null || hashMap.keySet().contains(list)) continue;
                BinaryAnalyser.addUsage(hashMap, (ClassName)list, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
        }
        return hashMap;
    }

    private List<String> getClassReferences(Pair<String, String> pair) {
        assert (pair != null);
        Object[] objectArray = this.refs.get(pair);
        if (objectArray == null) {
            objectArray = new Object[]{new ArrayList(), null, null};
            this.refs.put(pair, objectArray);
        }
        return (ArrayList)objectArray[0];
    }

    private static String nameToString(ClassName className) {
        return className.getInternalName().replace('/', '.');
    }

    private static void addUsage(Map<ClassName, Set<ClassIndexImpl.UsageType>> map, ClassName className, ClassIndexImpl.UsageType usageType) {
        if (OBJECT.equals(className.getExternalName())) {
            return;
        }
        Set<ClassIndexImpl.UsageType> set = map.get(className);
        if (set == null) {
            set = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
            map.put(className, set);
        }
        set.add(usageType);
    }

    private static void prebuildArgs(ZipFile zipFile, URL uRL) {
        ZipEntry zipEntry = zipFile.getEntry(FileObjects.convertPackage2Folder(JComponent.class.getName()) + '.' + "class");
        if (zipEntry != null) {
            ClasspathInfo classpathInfo = ClasspathInfo.create(ClassPathSupport.createClassPath((URL[])new URL[]{uRL}), ClassPathSupport.createClassPath((URL[])new URL[0]), ClassPathSupport.createClassPath((URL[])new URL[0]));
            JavacTaskImpl javacTaskImpl = JavaSourceAccessor.getINSTANCE().createJavacTask(classpathInfo, null, null);
            TreeLoader.preRegister(javacTaskImpl.getContext(), classpathInfo);
            Symbol.ClassSymbol classSymbol = ((JavacElements)javacTaskImpl.getElements()).getTypeElement(JComponent.class.getName());
            if (classSymbol != null) {
                List<ExecutableElement> list = ElementFilter.methodsIn(classSymbol.getEnclosedElements());
                for (ExecutableElement executableElement : list) {
                    List<? extends VariableElement> list2 = executableElement.getParameters();
                    if (list2.isEmpty()) continue;
                    list2.get(0).getSimpleName();
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileObjectContinuation
    extends Continuation {
        private final Enumeration<? extends FileObject> todo;
        private final AtomicBoolean cancel;
        private final AtomicBoolean closed;

        public FileObjectContinuation(Enumeration<? extends FileObject> enumeration, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) {
            assert (enumeration != null);
            assert (atomicBoolean != null);
            this.todo = enumeration;
            this.cancel = atomicBoolean;
            this.closed = atomicBoolean2;
        }

        @Override
        public Result doExecute() throws IOException {
            return BinaryAnalyser.this.analyseFileObjects(this.todo, this.cancel, this.closed);
        }

        @Override
        public void doFinish() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FolderContinuation
    extends Continuation {
        private final LinkedList<File> todo;
        private final String rootPath;
        private final AtomicBoolean cancel;
        private final AtomicBoolean closed;

        public FolderContinuation(LinkedList<File> linkedList, String string, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) {
            assert (linkedList != null);
            assert (string != null);
            assert (atomicBoolean != null);
            this.todo = linkedList;
            this.rootPath = string;
            this.cancel = atomicBoolean;
            this.closed = atomicBoolean2;
        }

        @Override
        public Result doExecute() throws IOException {
            return BinaryAnalyser.this.analyseFolder(this.todo, this.rootPath, this.cancel, this.closed);
        }

        @Override
        public void doFinish() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ZipContinuation
    extends Continuation {
        private final ZipFile zipFile;
        private final Enumeration<? extends ZipEntry> entries;
        private final AtomicBoolean cancel;
        private final AtomicBoolean closed;

        public ZipContinuation(ZipFile zipFile, Enumeration<? extends ZipEntry> enumeration, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2) {
            assert (zipFile != null);
            assert (enumeration != null);
            assert (atomicBoolean != null);
            this.zipFile = zipFile;
            this.entries = enumeration;
            this.cancel = atomicBoolean;
            this.closed = atomicBoolean2;
        }

        @Override
        protected Result doExecute() throws IOException {
            return BinaryAnalyser.this.analyseArchive(this.zipFile, this.entries, this.cancel, this.closed);
        }

        @Override
        protected void doFinish() throws IOException {
            this.zipFile.close();
        }
    }

    private static abstract class Continuation {
        private long time;

        private Continuation() {
        }

        protected abstract Result doExecute() throws IOException;

        protected abstract void doFinish() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Result execute() throws IOException {
            long l = System.currentTimeMillis();
            try {
                Result result = this.doExecute();
                return result;
            }
            finally {
                long l2 = System.currentTimeMillis();
                this.time += l2 - l;
            }
        }

        public final long finish() throws IOException {
            this.doFinish();
            return this.time;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        FINISHED,
        CANCELED,
        CLOSED;

    }
}

