/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FastJar {
    private static final int GIVE_UP = 65536;

    private FastJar() {
    }

    public static InputStream getInputStream(File file, Entry entry) throws IOException {
        return FastJar.getInputStream(file, entry.offset);
    }

    static InputStream getInputStream(File file, long l) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        randomAccessFile.seek(l);
        ZipInputStream zipInputStream = new ZipInputStream(new RandomAccessFileInputStream(randomAccessFile));
        zipInputStream.getNextEntry();
        return zipInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ZipEntry getZipEntry(File file, long l) throws IOException {
        ZipEntry zipEntry;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            randomAccessFile.seek(l);
            ZipInputStream zipInputStream = new ZipInputStream(new RandomAccessFileInputStream(randomAccessFile));
            try {
                zipEntry = zipInputStream.getNextEntry();
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                zipInputStream.close();
                throw throwable;
            }
            zipInputStream.close();
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            randomAccessFile.close();
            throw throwable;
        }
        randomAccessFile.close();
        return zipEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<? extends Entry> list(File file) throws IOException {
        LinkedList<Entry> linkedList;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            long l = (int)randomAccessFile.length();
            randomAccessFile.seek(l - 22L);
            byte[] byArray = new byte[22];
            int n = 0;
            do {
                if (randomAccessFile.read(byArray, 0, 22) != 22) {
                    throw new IOException();
                }
                randomAccessFile.seek(randomAccessFile.getFilePointer() - 23L);
                if (++n <= 65536) continue;
                throw new IOException();
            } while (FastJar.getsig(byArray) != 101010256L);
            long l2 = FastJar.endsiz(byArray);
            long l3 = FastJar.endoff(byArray);
            randomAccessFile.seek(l3);
            LinkedList<Entry> linkedList2 = new LinkedList<Entry>();
            int n2 = 0;
            byArray = new byte[46];
            while ((long)n2 < l2) {
                if (randomAccessFile.read(byArray, 0, 46) != 46) {
                    throw new IOException("No central table");
                }
                if (FastJar.getsig(byArray) != 33639248L) {
                    throw new IOException("No central table");
                }
                int n3 = FastJar.cennam(byArray);
                int n4 = FastJar.cenext(byArray);
                int n5 = FastJar.cencom(byArray);
                long l4 = FastJar.cenoff(byArray);
                long l5 = FastJar.centim(byArray);
                String string = FastJar.name(randomAccessFile, n3);
                int n6 = n4 + n5;
                int n7 = 46 + n3 + n6;
                n2 += n7;
                linkedList2.add(new Entry(string, l4, l5));
                FastJar.seekBy(randomAccessFile, n6);
            }
            linkedList = linkedList2;
            Object var23_18 = null;
        }
        catch (Throwable throwable) {
            Object var23_19 = null;
            randomAccessFile.close();
            throw throwable;
        }
        randomAccessFile.close();
        return linkedList;
    }

    private static final String name(RandomAccessFile randomAccessFile, int n) throws IOException {
        byte[] byArray = new byte[n];
        randomAccessFile.read(byArray, 0, n);
        return new String(byArray, "UTF-8");
    }

    private static final long getsig(byte[] byArray) throws IOException {
        return FastJar.get32(byArray, 0);
    }

    private static final long endsiz(byte[] byArray) throws IOException {
        return FastJar.get32(byArray, 12);
    }

    private static final long endoff(byte[] byArray) throws IOException {
        return FastJar.get32(byArray, 16);
    }

    private static final long cenlen(byte[] byArray) throws IOException {
        return FastJar.get32(byArray, 24);
    }

    private static final long censiz(byte[] byArray) throws IOException {
        return FastJar.get32(byArray, 20);
    }

    private static final long centim(byte[] byArray) throws IOException {
        return FastJar.get32(byArray, 12);
    }

    private static final int cennam(byte[] byArray) throws IOException {
        return FastJar.get16(byArray, 28);
    }

    private static final int cenext(byte[] byArray) throws IOException {
        return FastJar.get16(byArray, 30);
    }

    private static final int cencom(byte[] byArray) throws IOException {
        return FastJar.get16(byArray, 32);
    }

    private static final long cenoff(byte[] byArray) throws IOException {
        return FastJar.get32(byArray, 42);
    }

    private static final int lochow(byte[] byArray) throws IOException {
        return FastJar.get16(byArray, 8);
    }

    private static final int locname(byte[] byArray) throws IOException {
        return FastJar.get16(byArray, 26);
    }

    private static final int locext(byte[] byArray) throws IOException {
        return FastJar.get16(byArray, 28);
    }

    private static final long locsiz(byte[] byArray) throws IOException {
        return FastJar.get32(byArray, 18);
    }

    private static final void seekBy(RandomAccessFile randomAccessFile, int n) throws IOException {
        randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)n);
    }

    private static final int get16(byte[] byArray, int n) throws IOException {
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        return by & 0xFF | (by2 & 0xFF) << 8;
    }

    private static final long get32(byte[] byArray, int n) throws IOException {
        int n2 = FastJar.get16(byArray, n);
        int n3 = FastJar.get16(byArray, n + 2);
        return (long)n2 | (long)n3 << 16;
    }

    public static final class Entry {
        public final String name;
        final long offset;
        private final long dosTime;

        public Entry(String string, long l, long l2) {
            assert (string != null);
            this.name = string;
            this.offset = l;
            this.dosTime = l2;
        }

        public long getTime() {
            Date date = new Date((int)((this.dosTime >> 25 & 0x7FL) + 80L), (int)((this.dosTime >> 21 & 0xFL) - 1L), (int)(this.dosTime >> 16 & 0x1FL), (int)(this.dosTime >> 11 & 0x1FL), (int)(this.dosTime >> 5 & 0x3FL), (int)(this.dosTime << 1 & 0x3EL));
            return date.getTime();
        }
    }

    private static class RandomAccessFileInputStream
    extends InputStream {
        private final RandomAccessFile b;

        public RandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
            assert (randomAccessFile != null);
            this.b = randomAccessFile;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.available();
            int n4 = n2 < n3 ? n2 : n3;
            return this.b.read(byArray, n, n4);
        }

        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            return this.b.readByte();
        }

        public int available() throws IOException {
            return (int)(this.b.length() - this.b.getFilePointer());
        }

        public void close() throws IOException {
            this.b.close();
        }
    }
}

