/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import org.netbeans.modules.java.source.engine.TreeFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASTService {
    private Map<JavaFileObject, Map<JCTree, Integer>> endPosTables;
    private static final Context.Key<ASTService> treeKey = new Context.Key();

    public static synchronized ASTService instance(Context context) {
        ASTService aSTService = context.get(treeKey);
        if (aSTService == null) {
            aSTService = new ASTService(context);
        }
        return aSTService;
    }

    protected ASTService(Context context) {
        context.put(treeKey, this);
        this.endPosTables = new HashMap<JavaFileObject, Map<JCTree, Integer>>();
    }

    public Element getElement(Tree tree) {
        if (tree == null) {
            return null;
        }
        switch (tree.getKind()) {
            case COMPILATION_UNIT: {
                return ((JCTree.JCCompilationUnit)tree).packge;
            }
            case CLASS: {
                return ((JCTree.JCClassDecl)tree).sym;
            }
            case METHOD: {
                return ((JCTree.JCMethodDecl)tree).sym;
            }
            case VARIABLE: {
                return ((JCTree.JCVariableDecl)tree).sym;
            }
            case MEMBER_SELECT: {
                return ((JCTree.JCFieldAccess)tree).sym;
            }
            case IDENTIFIER: {
                return ((JCTree.JCIdent)tree).sym;
            }
            case NEW_CLASS: {
                return ((JCTree.JCNewClass)tree).constructor;
            }
        }
        return null;
    }

    public TypeMirror getType(Tree tree) {
        Element element;
        if (tree == null) {
            return null;
        }
        TypeMirror typeMirror = ((JCTree)tree).type;
        if (typeMirror == null && (element = this.getElement(tree)) != null) {
            typeMirror = element.asType();
        }
        return typeMirror;
    }

    public void setElement(Tree tree, Element element) {
        switch (((JCTree)tree).getTag()) {
            case 1: {
                ((JCTree.JCCompilationUnit)tree).packge = (Symbol.PackageSymbol)element;
                break;
            }
            case 3: {
                ((JCTree.JCClassDecl)tree).sym = (Symbol.ClassSymbol)element;
                break;
            }
            case 4: {
                ((JCTree.JCMethodDecl)tree).sym = (Symbol.MethodSymbol)element;
                break;
            }
            case 5: {
                ((JCTree.JCVariableDecl)tree).sym = (Symbol.VarSymbol)element;
                break;
            }
            case 34: {
                ((JCTree.JCFieldAccess)tree).sym = (Symbol)element;
                break;
            }
            case 35: {
                ((JCTree.JCIdent)tree).sym = (Symbol)element;
                break;
            }
            case 27: {
                ((JCTree.JCNewClass)tree).constructor = (Symbol)element;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tree type: " + (Object)((Object)tree.getKind()));
            }
        }
    }

    public void setType(Tree tree, TypeMirror typeMirror) {
        ((JCTree)tree).type = (Type)typeMirror;
    }

    public boolean isThis(IdentifierTree identifierTree) {
        return identifierTree instanceof IdentifierTree && ASTService.isThis(((JCTree.JCIdent)identifierTree).name);
    }

    private static boolean isThis(Name name) {
        return name == name.table._this;
    }

    public boolean isSynthetic(Tree tree) {
        if (tree == null) {
            return false;
        }
        long l = 0L;
        JCTree jCTree = (JCTree)tree;
        switch (jCTree.getTag()) {
            case 3: {
                l = ((JCTree.JCClassDecl)jCTree).mods.flags;
                break;
            }
            case 4: {
                l = ((JCTree.JCMethodDecl)jCTree).mods.flags;
                break;
            }
            case 5: {
                l = ((JCTree.JCVariableDecl)jCTree).mods.flags;
                break;
            }
            case 7: {
                if (jCTree.pos == -1) {
                    return true;
                }
                l = ((JCTree.JCBlock)jCTree).flags;
                break;
            }
            case 44: {
                if (jCTree.pos != -1) break;
                return true;
            }
        }
        return (l & 0x1000L) != 0L;
    }

    public Tree[] makePath(Tree tree, Tree tree2) {
        final Stack stack = new Stack();
        tree.accept(new TreeFinder(tree2){

            public Boolean scan(Tree tree, Object object) {
                super.scan(tree, object);
                if (this.found) {
                    stack.push(tree);
                }
                return this.found;
            }
        }, null);
        Tree[] treeArray = new Tree[stack.size()];
        for (int i = 0; i < treeArray.length; ++i) {
            treeArray[i] = (Tree)stack.pop();
        }
        return treeArray;
    }

    public int getPos(Tree tree) {
        if (tree == null) {
            return -1;
        }
        return ((JCTree)tree).pos;
    }

    public int getStartPos(Tree tree) {
        if (tree == null) {
            return -1;
        }
        switch (((JCTree)tree).getTag()) {
            case 26: {
                return this.getStartPos(((JCTree.JCMethodInvocation)tree).meth);
            }
            case 30: {
                return this.getStartPos(((JCTree.JCAssign)tree).lhs);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.getStartPos(((JCTree.JCAssignOp)tree).lhs);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.getStartPos(((JCTree.JCBinary)tree).lhs);
            }
            case 3: {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)tree;
                if (jCClassDecl.mods.pos == -1) break;
                return jCClassDecl.mods.pos;
            }
            case 18: {
                return this.getStartPos(((JCTree.JCConditional)tree).cond);
            }
            case 20: {
                return this.getStartPos(((JCTree.JCExpressionStatement)tree).expr);
            }
            case 33: {
                return this.getStartPos(((JCTree.JCArrayAccess)tree).indexed);
            }
            case 4: {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)tree;
                if (jCMethodDecl.mods.pos != -1) {
                    return jCMethodDecl.mods.pos;
                }
                if (jCMethodDecl.restype != null) {
                    return this.getStartPos(jCMethodDecl.restype);
                }
                return jCMethodDecl.pos;
            }
            case 34: {
                return this.getStartPos(((JCTree.JCFieldAccess)tree).selected);
            }
            case 39: {
                return this.getStartPos(((JCTree.JCTypeApply)tree).clazz);
            }
            case 38: {
                return this.getStartPos(((JCTree.JCArrayTypeTree)tree).elemtype);
            }
            case 32: {
                return this.getStartPos(((JCTree.JCInstanceOf)tree).expr);
            }
            case 52: 
            case 53: {
                return this.getStartPos(((JCTree.JCUnary)tree).arg);
            }
            case 5: {
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)tree;
                if (jCVariableDecl.mods.pos != -1) {
                    return jCVariableDecl.mods.pos;
                }
                return this.getStartPos(jCVariableDecl.vartype);
            }
        }
        return ((JCTree)tree).pos;
    }

    public int getEndPos(Tree tree, CompilationUnitTree compilationUnitTree) {
        Map<JCTree, Integer> map;
        Map<JCTree, Integer> map2 = map = compilationUnitTree != null ? this.endPosTables.get(compilationUnitTree.getSourceFile()) : null;
        if (tree == null || map == null) {
            return -1;
        }
        Integer n = map.get(tree);
        if (n != null) {
            return n;
        }
        JCTree jCTree = (JCTree)tree;
        switch (jCTree.getTag()) {
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.getEndPos(((JCTree.JCAssignOp)tree).rhs, compilationUnitTree);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.getEndPos(((JCTree.JCBinary)tree).rhs, compilationUnitTree);
            }
            case 14: {
                return this.getEndPos(((JCTree.JCCase)tree).stats.last(), compilationUnitTree);
            }
            case 17: {
                return this.getEndPos(((JCTree.JCCatch)tree).body, compilationUnitTree);
            }
            case 20: {
                return this.getEndPos(((JCTree.JCExpressionStatement)tree).expr, compilationUnitTree);
            }
            case 18: {
                return this.getEndPos(((JCTree.JCConditional)tree).falsepart, compilationUnitTree);
            }
            case 10: {
                if (tree instanceof JCTree.JCForLoop) {
                    return this.getEndPos(((JCTree.JCForLoop)tree).body, compilationUnitTree);
                }
                return this.getEndPos(((JCTree.JCEnhancedForLoop)tree).body, compilationUnitTree);
            }
            case 35: {
                return jCTree.pos + ((JCTree.JCIdent)tree).name.len;
            }
            case 19: {
                JCTree.JCIf jCIf = (JCTree.JCIf)tree;
                if (jCIf.elsepart == null) {
                    return this.getEndPos(jCIf.thenpart, compilationUnitTree);
                }
                return this.getEndPos(jCIf.elsepart, compilationUnitTree);
            }
            case 11: {
                return this.getEndPos(((JCTree.JCEnhancedForLoop)tree).body, compilationUnitTree);
            }
            case 12: {
                return this.getEndPos(((JCTree.JCLabeledStatement)tree).body, compilationUnitTree);
            }
            case 44: {
                return this.getEndPos(((JCTree.JCModifiers)tree).annotations.last(), compilationUnitTree);
            }
            case 34: {
                JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)tree;
                return this.getEndPos(jCFieldAccess.selected, compilationUnitTree) + 1 + jCFieldAccess.name.len;
            }
            case 15: {
                return this.getEndPos(((JCTree.JCSynchronized)tree).body, compilationUnitTree);
            }
            case 1: {
                return this.getEndPos(((JCTree.JCCompilationUnit)tree).defs.last(), compilationUnitTree);
            }
            case 16: {
                JCTree.JCTry jCTry = (JCTree.JCTry)tree;
                if (jCTry.finalizer == null) {
                    return this.getEndPos(jCTry.catchers.last(), compilationUnitTree);
                }
                return this.getEndPos(jCTry.finalizer, compilationUnitTree);
            }
            case 31: {
                return this.getEndPos(((JCTree.JCTypeCast)tree).expr, compilationUnitTree);
            }
            case 32: {
                return this.getEndPos(((JCTree.JCInstanceOf)tree).clazz, compilationUnitTree);
            }
            case 41: {
                return this.getEndPos(((JCTree.JCWildcard)tree).inner, compilationUnitTree);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                return this.getEndPos(((JCTree.JCUnary)tree).arg, compilationUnitTree);
            }
            case 9: {
                return this.getEndPos(((JCTree.JCWhileLoop)tree).body, compilationUnitTree);
            }
        }
        return -1;
    }

    public void setPos(Tree tree, int n) {
        ((JCTree)tree).pos = n;
    }

    public void setEndPosTable(JavaFileObject javaFileObject, Map<JCTree, Integer> map) {
        this.endPosTables.put(javaFileObject, map);
    }

    public List<? extends Tree> getChildren(Tree tree) {
        if (tree instanceof CompilationUnitTree) {
            return ((CompilationUnitTree)tree).getTypeDecls();
        }
        if (tree instanceof ClassTree) {
            return ((ClassTree)tree).getMembers();
        }
        return Collections.emptyList();
    }
}

