/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.openide.filesystems.FileObject;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTemplateAttributesProvider
implements CreateFromTemplateAttributesProvider {
    private static final Logger LOG = Logger.getLogger(JavaTemplateAttributesProvider.class.getName());
    private static final SpecificationVersion VER15 = new SpecificationVersion("1.5");

    public Map<String, ?> attributesFor(DataObject dataObject, DataFolder dataFolder, String string) {
        FileObject fileObject = dataObject.getPrimaryFile();
        if (!"java".equals(fileObject.getExt()) || fileObject.isFolder()) {
            return null;
        }
        FileObject fileObject2 = dataFolder.getPrimaryFile();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
        if (classPath == null) {
            LOG.warning("No classpath was found for folder: " + dataFolder.getPrimaryFile());
        } else {
            hashMap.put("package", classPath.getResourceName(fileObject2, '.', false));
        }
        String string2 = SourceLevelQuery.getSourceLevel((FileObject)fileObject2);
        if (string2 != null) {
            hashMap.put("javaSourceLevel", string2);
            if (this.isJava15orLater(string2)) {
                hashMap.put("java15style", Boolean.TRUE);
            }
        }
        return hashMap;
    }

    private boolean isJava15orLater(String string) {
        SpecificationVersion specificationVersion = new SpecificationVersion(string);
        return specificationVersion.compareTo((Object)VER15) >= 0;
    }
}

