/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceUtils {
    private static final String PACKAGE_SUMMARY = "package-summary";

    private SourceUtils() {
    }

    public static TokenSequence<JavaTokenId> getJavaTokenSequence(TokenHierarchy tokenHierarchy, int n) {
        if (tokenHierarchy != null) {
            for (TokenSequence tokenSequence = tokenHierarchy.tokenSequence(); tokenSequence != null && (n == 0 || tokenSequence.moveNext()); tokenSequence = tokenSequence.embedded()) {
                tokenSequence.move(n);
                if (tokenSequence.language() == JavaTokenId.language()) {
                    return tokenSequence;
                }
                if (tokenSequence.moveNext() || tokenSequence.movePrevious()) continue;
                return null;
            }
        }
        return null;
    }

    public static boolean checkTypesAssignable(CompilationInfo compilationInfo, TypeMirror typeMirror, TypeMirror typeMirror2) {
        Context context = compilationInfo.impl.getJavacTask().getContext();
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            List<Type> list = List.nil();
            for (TypeMirror typeMirror3 : ((DeclaredType)typeMirror).getTypeArguments()) {
                if (typeMirror3.getKind() != TypeKind.TYPEVAR) continue;
                list = list.append((Type)typeMirror3);
            }
            if (!list.isEmpty()) {
                typeMirror = new Type.ForAll(list, (Type)typeMirror);
            }
        } else if (typeMirror.getKind() == TypeKind.WILDCARD) {
            typeMirror = Types.instance(context).upperBound((Type)typeMirror);
        }
        return Check.instance(context).checkType(null, (Type)typeMirror, (Type)typeMirror2).getKind() != TypeKind.ERROR;
    }

    public static TypeMirror getBound(WildcardType wildcardType) {
        Type.TypeVar typeVar = ((Type.WildcardType)wildcardType).bound;
        return typeVar != null ? typeVar.bound : null;
    }

    public static TypeElement getEnclosingTypeElement(Element element) throws IllegalArgumentException {
        if (element.getKind() == ElementKind.PACKAGE) {
            throw new IllegalArgumentException();
        }
        if ((element = element.getEnclosingElement()).getKind() == ElementKind.PACKAGE) {
            return null;
        }
        while (element != null && !element.getKind().isClass() && !element.getKind().isInterface()) {
            element = element.getEnclosingElement();
        }
        return (TypeElement)element;
    }

    public static TypeElement getOutermostEnclosingTypeElement(Element element) {
        Element element2 = SourceUtils.getEnclosingTypeElement(element);
        if (element2 == null) {
            element2 = element;
        }
        while (element2.getEnclosingElement().getKind().isClass() || element2.getEnclosingElement().getKind().isInterface()) {
            element2 = element2.getEnclosingElement();
        }
        return (TypeElement)element2;
    }

    public static String resolveImport(final CompilationInfo compilationInfo, TreePath treePath, final String string) throws NullPointerException, IOException {
        if (compilationInfo == null) {
            throw new NullPointerException();
        }
        if (treePath == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        final Trees trees = compilationInfo.getTrees();
        final Scope scope = trees.getScope(treePath);
        String string2 = string;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = null;
        boolean bl = false;
        ElementUtilities elementUtilities = compilationInfo.getElementUtilities();
        ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element element, TypeMirror typeMirror) {
                return (element.getKind().isClass() || element.getKind().isInterface()) && trees.isAccessible(scope, (TypeElement)element);
            }
        };
        while (string2 != null && string2.length() > 0) {
            int n = string2.lastIndexOf(46);
            String string4 = string2.substring(n < 0 ? 0 : n + 1);
            if (string3 == null) {
                string3 = string4;
            } else {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, string4);
            if (compilationInfo.getElements().getTypeElement(string2) != null) {
                boolean bl2 = false;
                for (Element element : elementUtilities.getLocalMembersAndVars(scope, elementAcceptor)) {
                    if (!string4.contentEquals(element.getSimpleName())) continue;
                    if (string2.contentEquals(((TypeElement)element).getQualifiedName())) {
                        return stringBuilder.toString();
                    }
                    if (string == string2) {
                        bl = true;
                    }
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    for (TypeElement typeElement : elementUtilities.getGlobalTypes(elementAcceptor)) {
                        if (!string4.contentEquals(typeElement.getSimpleName())) continue;
                        if (string2.contentEquals(typeElement.getQualifiedName())) {
                            return stringBuilder.toString();
                        }
                        if (string != string2) break;
                        bl = true;
                        break;
                    }
                }
            }
            string2 = n < 0 ? null : string2.substring(0, n);
        }
        if (bl) {
            return string;
        }
        if (compilationInfo instanceof WorkingCopy) {
            CompilationUnitTree compilationUnitTree2 = (CompilationUnitTree)((WorkingCopy)compilationInfo).getChangeSet().get(compilationUnitTree);
            compilationUnitTree = compilationUnitTree2 != null ? compilationUnitTree2 : compilationUnitTree;
            ((WorkingCopy)compilationInfo).rewrite(compilationInfo.getCompilationUnit(), SourceUtils.addImports(compilationUnitTree, Collections.singletonList(string), ((WorkingCopy)compilationInfo).getTreeMaker()));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        compilationInfo.getJavaSource().runModificationTask(new Task<WorkingCopy>(){

                            @Override
                            public void run(WorkingCopy workingCopy) throws Exception {
                                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                workingCopy.rewrite(workingCopy.getCompilationUnit(), SourceUtils.addImports(workingCopy.getCompilationUnit(), Collections.singletonList(string), workingCopy.getTreeMaker()));
                            }
                        }).commit();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            });
        }
        TypeElement typeElement = compilationInfo.getElements().getTypeElement(string);
        if (typeElement != null) {
            ((JCTree.JCCompilationUnit)compilationInfo.getCompilationUnit()).namedImportScope.enterIfAbsent((Symbol)((Object)typeElement));
        }
        return string3;
    }

    private static CompilationUnitTree addImports(CompilationUnitTree compilationUnitTree, java.util.List<String> list, TreeMaker treeMaker) throws IOException {
        String string;
        list = new ArrayList<String>(list);
        Collections.sort(list);
        ArrayList<? extends ImportTree> arrayList = new ArrayList<ImportTree>(compilationUnitTree.getImports());
        int n = list.size() - 1;
        int n2 = arrayList.size() - 1;
        while (n >= 0 && n2 >= 0) {
            string = list.get(n);
            while (n2 >= 0 && (((ImportTree)arrayList.get(n2)).isStatic() || ((ImportTree)arrayList.get(n2)).getQualifiedIdentifier().toString().compareTo(string) > 0)) {
                --n2;
            }
            if (n2 < 0) continue;
            arrayList.add(n2 + 1, treeMaker.Import(treeMaker.Identifier(string), false));
            --n;
        }
        while (n >= 0) {
            string = list.get(n);
            arrayList.add(0, treeMaker.Import(treeMaker.Identifier(string), false));
            --n;
        }
        return treeMaker.CompilationUnit(compilationUnitTree.getPackageName(), arrayList, compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
    }

    public static FileObject getFile(Element element, ClasspathInfo classpathInfo) {
        Parameters.notNull((CharSequence)"element", (Object)element);
        Parameters.notNull((CharSequence)"cpInfo", (Object)classpathInfo);
        Element element2 = null;
        while (element.getKind() != ElementKind.PACKAGE) {
            element2 = element;
            element = element.getEnclosingElement();
        }
        if (element2 == null || !element2.getKind().isClass() && !element2.getKind().isInterface()) {
            return null;
        }
        ElementHandle<Element> elementHandle = ElementHandle.create(element2);
        return SourceUtils.getFile(elementHandle, classpathInfo);
    }

    public static FileObject getFile(ElementHandle<? extends Element> elementHandle, ClasspathInfo classpathInfo) {
        Parameters.notNull((CharSequence)"handle", elementHandle);
        Parameters.notNull((CharSequence)"cpInfo", (Object)classpathInfo);
        try {
            String string;
            boolean bl = elementHandle.getKind() == ElementKind.PACKAGE;
            String[] stringArray = elementHandle.getSignature();
            assert (stringArray.length >= 1);
            ClassPath classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), SourceUtils.createClassPath(classpathInfo, ClasspathInfo.PathKind.BOOT), SourceUtils.createClassPath(classpathInfo, ClasspathInfo.PathKind.COMPILE)});
            String string2 = null;
            if (bl) {
                string = FileObjects.convertPackage2Folder(stringArray[0]);
            } else {
                int n = stringArray[0].lastIndexOf(46);
                if (n < 0) {
                    string = "";
                    string2 = stringArray[0];
                } else {
                    string = FileObjects.convertPackage2Folder(stringArray[0].substring(0, n));
                    string2 = stringArray[0].substring(n + 1);
                }
            }
            java.util.List list = classPath.findAllResources(string);
            for (FileObject fileObject : list) {
                FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
                assert (fileObject2 != null);
                FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)fileObject2.getURL()).getRoots();
                ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
                LinkedList<FileObject> linkedList = new LinkedList<FileObject>(classPath2.findAllResources(string));
                if (bl) {
                    return linkedList.isEmpty() ? fileObject : (FileObject)linkedList.get(0);
                }
                boolean bl2 = SourceUtils.isCaseSensitive();
                String string3 = SourceUtils.getSourceFileName(string2);
                linkedList.addFirst(fileObject);
                for (FileObject fileObject3 : linkedList) {
                    FileObject[] fileObjectArray2;
                    for (FileObject fileObject4 : fileObjectArray2 = fileObject3.getChildren()) {
                        if ((!bl2 || !fileObject4.getName().equals(string3)) && (bl2 || !fileObject4.getName().equalsIgnoreCase(string3)) || !fileObject4.isData() || !"java".equalsIgnoreCase(fileObject4.getExt())) continue;
                        return fileObject4;
                    }
                }
                FileObject fileObject5 = fileObjectArray.length == 0 ? SourceUtils.findSource(stringArray[0], fileObject2) : SourceUtils.findSource(stringArray[0], fileObjectArray);
                if (fileObject5 == null) continue;
                return fileObject5;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    private static FileObject findSource(final String string, final FileObject ... fileObjectArray) throws IOException {
        final ClassIndexManager classIndexManager = ClassIndexManager.getDefault();
        try {
            return classIndexManager.readLock(new ClassIndexManager.ExceptionAction<FileObject>(){

                @Override
                public FileObject run() throws IOException, InterruptedException {
                    for (FileObject fileObject : fileObjectArray) {
                        FileObject fileObject2;
                        String string2;
                        ClassIndexImpl classIndexImpl = classIndexManager.getUsagesQuery(fileObject.getURL());
                        if (classIndexImpl == null || (string2 = classIndexImpl.getSourceName(string)) == null || (fileObject2 = fileObject.getFileObject(string2)) == null) continue;
                        return fileObject2;
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
            return null;
        }
    }

    public static URL getJavadoc(Element element, ClasspathInfo classpathInfo) {
        String string;
        String string2;
        Object object;
        HashSet<Object> hashSet;
        Object object2;
        if (element == null || classpathInfo == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getJavadoc");
        }
        Symbol.ClassSymbol classSymbol = null;
        boolean bl = false;
        if (element.getKind() == ElementKind.PACKAGE) {
            object2 = element.getEnclosedElements();
            hashSet = object2.iterator();
            while (hashSet.hasNext()) {
                object = (Element)hashSet.next();
                if (!object.getKind().isClass() && !object.getKind().isInterface()) continue;
                classSymbol = (Symbol.ClassSymbol)object;
                break;
            }
            if (classSymbol == null) {
                return null;
            }
            string2 = FileObjects.convertPackage2Folder(((PackageElement)element).getQualifiedName().toString());
            string = PACKAGE_SUMMARY;
        } else {
            object2 = null;
            hashSet = element;
            while (hashSet.getKind() != ElementKind.PACKAGE) {
                object2 = hashSet;
                hashSet = hashSet.getEnclosingElement();
            }
            if (object2 == null || !object2.getKind().isClass() && !object2.getKind().isInterface()) {
                return null;
            }
            classSymbol = (Symbol.ClassSymbol)object2;
            string2 = FileObjects.convertPackage2Folder(((Symbol)classSymbol.getEnclosingElement()).getQualifiedName().toString());
            string = classSymbol.getSimpleName().toString();
            boolean bl2 = bl = element != object2;
        }
        if (classSymbol.completer != null) {
            classSymbol.complete();
        }
        object2 = null;
        hashSet = new HashSet<Object>();
        try {
            Object object3;
            ClassPath classPath;
            Object object422;
            if (classSymbol.classfile != null) {
                object = URLMapper.findFileObject((URL)classSymbol.classfile.toUri().toURL());
                object422 = new StringTokenizer(string2, "/");
                for (int n = 0; object != null && n <= ((StringTokenizer)object422).countTokens(); object = object.getParent(), ++n) {
                }
                if (object != null) {
                    URL uRL = object.getURL();
                    object2 = Index.getSourceRootForClassFolder(uRL);
                    if (object2 == null) {
                        hashSet.add(uRL);
                    } else {
                        hashSet.add(object2);
                    }
                }
            }
            if (object2 != null && (object = URLMapper.findFileObject((URL)object2)) != null) {
                object422 = ClassPath.getClassPath((FileObject)object, (String)"classpath/execute");
                ClassPath classPath2 = ClassPath.getClassPath((FileObject)object, (String)"classpath/compile");
                classPath = ClassPath.getClassPath((FileObject)object, (String)"classpath/source");
                if (object422 == null) {
                    object422 = classPath2;
                    classPath2 = null;
                }
                if (object422 != null && classPath != null) {
                    Object object522;
                    object3 = new HashSet();
                    for (Object object522 : object422.entries()) {
                        object3.add(object522.getURL());
                    }
                    if (classPath2 != null) {
                        for (Object object522 : classPath2.entries()) {
                            object3.remove(object522.getURL());
                        }
                    }
                    java.util.List<FileObject> list = Arrays.asList(classPath.getRoots());
                    object522 = object3.iterator();
                    block12: while (object522.hasNext()) {
                        FileObject[] fileObjectArray;
                        URL uRL = (URL)object522.next();
                        for (FileObject fileObject : fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots()) {
                            if (!list.contains(fileObject)) continue;
                            hashSet.add(uRL);
                            continue block12;
                        }
                    }
                }
            }
            for (Object object422 : hashSet) {
                URL[] uRLArray = JavadocForBinaryQuery.findJavadoc((URL)object422).getRoots();
                classPath = ClassPathSupport.createClassPath((URL[])uRLArray);
                object3 = classPath.findResource(string2);
                if (object3 == null) continue;
                for (FileObject fileObject : object3.getChildren()) {
                    if (!string.equals(fileObject.getName()) || !"html".equalsIgnoreCase(fileObject.getExt())) continue;
                    FileObject[] fileObjectArray = fileObject.getURL();
                    CharSequence charSequence = null;
                    if (fileObjectArray != null && bl) {
                        charSequence = SourceUtils.getFragment(element);
                    }
                    if (charSequence != null && charSequence.length() > 0) {
                        try {
                            String unsupportedEncodingException = URLEncoder.encode(((Object)charSequence).toString(), "UTF-8");
                            unsupportedEncodingException = unsupportedEncodingException.replace("+", "%20");
                            return new URI(fileObjectArray.toExternalForm() + '#' + unsupportedEncodingException).toURL();
                        }
                        catch (URISyntaxException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Exceptions.printStackTrace((Throwable)unsupportedEncodingException);
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                        }
                    }
                    return fileObjectArray;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    private static CharSequence getFragment(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!element.getKind().isClass() && !element.getKind().isInterface()) {
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                stringBuilder.append(element.getEnclosingElement().getSimpleName());
            } else {
                stringBuilder.append(element.getSimpleName());
            }
            if (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement executableElement = (ExecutableElement)element;
                stringBuilder.append('(');
                Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
                while (iterator.hasNext()) {
                    VariableElement variableElement = iterator.next();
                    SourceUtils.appendType(stringBuilder, variableElement.asType(), executableElement.isVarArgs() && !iterator.hasNext());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
            }
        }
        return stringBuilder;
    }

    private static void appendType(StringBuilder stringBuilder, TypeMirror typeMirror, boolean bl) {
        switch (typeMirror.getKind()) {
            case ARRAY: {
                SourceUtils.appendType(stringBuilder, ((ArrayType)typeMirror).getComponentType(), false);
                stringBuilder.append(bl ? "..." : "[]");
                break;
            }
            case DECLARED: {
                stringBuilder.append(((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName());
                break;
            }
            default: {
                stringBuilder.append(typeMirror);
            }
        }
    }

    public static boolean isScanInProgress() {
        return RepositoryUpdater.getDefault().isScanInProgress();
    }

    public static void waitScanFinished() throws InterruptedException {
        RepositoryUpdater.getDefault().waitScanFinished();
    }

    public static Set<URL> getDependentRoots(URL uRL) {
        Map<URL, java.util.List<URL>> map = RepositoryUpdater.getDefault().getDependencies();
        return SourceUtils.getDependentRootsImpl(uRL, map);
    }

    static Set<URL> getDependentRootsImpl(URL uRL, Map<URL, java.util.List<URL>> map) {
        java.util.List list;
        Object object;
        HashMap<URL, ArrayList<Object>> hashMap = new HashMap<URL, ArrayList<Object>>();
        for (Map.Entry<URL, java.util.List<URL>> object22 : map.entrySet()) {
            object = object22.getKey();
            list = object22.getValue();
            for (URL uRL2 : list) {
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(uRL2);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    hashMap.put(uRL2, arrayList);
                }
                arrayList.add(object);
            }
        }
        HashSet hashSet = new HashSet();
        LinkedList<URL> linkedList = new LinkedList<URL>();
        linkedList.add(uRL);
        while (!linkedList.isEmpty()) {
            object = (URL)linkedList.removeFirst();
            if (hashSet.contains(object)) continue;
            hashSet.add(object);
            list = (java.util.List)hashMap.get(object);
            if (list == null) continue;
            linkedList.addAll(list);
        }
        object = GlobalPathRegistry.getDefault().getPaths("classpath/source");
        list = new HashSet();
        Iterator<URL> iterator = object.iterator();
        while (iterator.hasNext()) {
            URL uRL2;
            uRL2 = (ClassPath)iterator.next();
            for (ClassPath.Entry entry : uRL2.entries()) {
                list.add(entry.getURL());
            }
        }
        hashSet.retainAll(list);
        return hashSet;
    }

    public static Collection<ElementHandle<TypeElement>> getMainClasses(FileObject fileObject) {
        if (fileObject == null || !fileObject.isValid() || fileObject.isVirtual()) {
            throw new IllegalArgumentException();
        }
        JavaSource javaSource = JavaSource.forFileObject(fileObject);
        if (javaSource == null) {
            throw new IllegalArgumentException();
        }
        try {
            final LinkedList<ElementHandle<TypeElement>> linkedList = new LinkedList<ElementHandle<TypeElement>>();
            javaSource.runUserActionTask(new Task<CompilationController>(){

                @Override
                public void run(final CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo(JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
                        new TreePathScanner<Void, Void>(){

                            @Override
                            public Void visitMethod(MethodTree methodTree, Void void_) {
                                ExecutableElement executableElement = (ExecutableElement)compilationController.getTrees().getElement(this.getCurrentPath());
                                if (executableElement != null && SourceUtils.isMainMethod(executableElement) && this.isAccessible(executableElement.getEnclosingElement())) {
                                    linkedList.add(ElementHandle.create((TypeElement)executableElement.getEnclosingElement()));
                                }
                                return null;
                            }
                        }.scan(compilationController.getCompilationUnit(), null);
                    }
                }

                private boolean isAccessible(Element element) {
                    ElementKind elementKind = element.getKind();
                    while (elementKind != ElementKind.PACKAGE) {
                        if (!elementKind.isClass() && !elementKind.isInterface()) {
                            return false;
                        }
                        Set<Modifier> set = ((TypeElement)element).getModifiers();
                        Element element2 = element.getEnclosingElement();
                        if (element2.getKind() != ElementKind.PACKAGE && !set.contains((Object)Modifier.STATIC)) {
                            return false;
                        }
                        element = element2;
                        elementKind = element.getKind();
                    }
                    return true;
                }
            }, true);
            return linkedList;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return Collections.emptySet();
        }
    }

    public static boolean isMainClass(final String string, ClasspathInfo classpathInfo) {
        if (string == null || classpathInfo == null) {
            throw new IllegalArgumentException();
        }
        final boolean[] blArray = new boolean[]{false};
        JavaSource javaSource = JavaSource.create(classpathInfo, new FileObject[0]);
        try {
            javaSource.runUserActionTask(new Task<CompilationController>(){

                @Override
                public void run(CompilationController compilationController) throws Exception {
                    Symbol.ClassSymbol classSymbol = ((JavacElements)compilationController.getElements()).getTypeElementByBinaryName(string);
                    if (classSymbol == null) {
                        return;
                    }
                    java.util.List<ExecutableElement> list = ElementFilter.methodsIn(classSymbol.getEnclosedElements());
                    for (ExecutableElement executableElement : list) {
                        if (!SourceUtils.isMainMethod(executableElement)) continue;
                        blArray[0] = true;
                        break;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return blArray[0];
    }

    public static boolean isMainMethod(ExecutableElement executableElement) {
        if (!"main".contentEquals(executableElement.getSimpleName())) {
            return false;
        }
        long l = ((Symbol.MethodSymbol)executableElement).flags();
        if ((l & 1L) == 0L || (l & 8L) == 0L) {
            return false;
        }
        if (executableElement.getReturnType().getKind() != TypeKind.VOID) {
            return false;
        }
        java.util.List<? extends VariableElement> list = executableElement.getParameters();
        if (list.size() != 1) {
            return false;
        }
        TypeMirror typeMirror = list.get(0).asType();
        if (typeMirror.getKind() != TypeKind.ARRAY) {
            return false;
        }
        ArrayType arrayType = (ArrayType)typeMirror;
        TypeMirror typeMirror2 = arrayType.getComponentType();
        if (typeMirror2.getKind() != TypeKind.DECLARED) {
            return false;
        }
        return "java.lang.String".contentEquals(((TypeElement)((DeclaredType)typeMirror2).asElement()).getQualifiedName());
    }

    public static Collection<ElementHandle<TypeElement>> getMainClasses(FileObject[] fileObjectArray) {
        final LinkedList<ElementHandle<TypeElement>> linkedList = new LinkedList<ElementHandle<TypeElement>>();
        for (FileObject fileObject : fileObjectArray) {
            try {
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
                ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
                ClassPath classPath3 = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject});
                ClasspathInfo classpathInfo = ClasspathInfo.create(classPath, classPath2, classPath3);
                final Set<ElementHandle<TypeElement>> set = classpathInfo.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.SOURCE));
                JavaSource javaSource = JavaSource.create(classpathInfo, new FileObject[0]);
                javaSource.runUserActionTask(new Task<CompilationController>(){

                    @Override
                    public void run(CompilationController compilationController) throws Exception {
                        block0: for (ElementHandle elementHandle : set) {
                            TypeElement typeElement = (TypeElement)elementHandle.resolve(compilationController);
                            if (typeElement == null) continue;
                            java.util.List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                            for (ExecutableElement executableElement : list) {
                                if (!SourceUtils.isMainMethod(executableElement)) continue;
                                if (!SourceUtils.isIncluded(elementHandle, compilationController.getClasspathInfo())) continue block0;
                                linkedList.add(elementHandle);
                                continue block0;
                            }
                        }
                    }
                }, false);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return Collections.emptySet();
            }
        }
        return linkedList;
    }

    private static boolean isIncluded(ElementHandle<TypeElement> elementHandle, ClasspathInfo classpathInfo) {
        FileObject fileObject = SourceUtils.getFile(elementHandle, classpathInfo);
        if (fileObject == null) {
            return true;
        }
        ClassPath classPath = classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        for (ClassPath.Entry entry : classPath.entries()) {
            FileObject fileObject2 = entry.getRoot();
            if (fileObject2 == null || !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return entry.includes(fileObject);
        }
        return true;
    }

    private static boolean isCaseSensitive() {
        return !new File("a").equals(new File("A"));
    }

    private static String getSourceFileName(String string) {
        int n = string.indexOf(36);
        return n == -1 ? string : string.substring(0, n);
    }

    public static WildcardType resolveCapturedType(TypeMirror typeMirror) {
        if (typeMirror instanceof Type.CapturedType) {
            return ((Type.CapturedType)typeMirror).wildcard;
        }
        return null;
    }

    private static ClassPath createClassPath(ClasspathInfo classpathInfo, ClasspathInfo.PathKind pathKind) throws MalformedURLException {
        return ClasspathInfoAccessor.getINSTANCE().getCachedClassPath(classpathInfo, pathKind);
    }
}

