/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.javadoc.Doc;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javadoc.DocEnv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.JavadocEnv;
import org.netbeans.modules.java.source.builder.ElementsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementUtilities {
    private final Context ctx;
    private final ElementsService delegate;
    private final CompilationInfo info;

    ElementUtilities(CompilationInfo compilationInfo) {
        assert (compilationInfo != null);
        JavacTaskImpl javacTaskImpl = compilationInfo.impl.getJavacTask();
        this.info = compilationInfo;
        this.ctx = javacTaskImpl.getContext();
        this.delegate = ElementsService.instance(this.ctx);
    }

    public TypeElement enclosingTypeElement(Element element) throws IllegalArgumentException {
        if (element.getKind() == ElementKind.PACKAGE) {
            throw new IllegalArgumentException();
        }
        if ((element = element.getEnclosingElement()).getKind() == ElementKind.PACKAGE) {
            return null;
        }
        while (element != null && !element.getKind().isClass() && !element.getKind().isInterface()) {
            element = element.getEnclosingElement();
        }
        return (TypeElement)element;
    }

    public TypeElement outermostTypeElement(Element element) {
        return this.delegate.outermostTypeElement(element);
    }

    public Element getImplementationOf(ExecutableElement executableElement, TypeElement typeElement) {
        return this.delegate.getImplementationOf(executableElement, typeElement);
    }

    public boolean isSynthetic(Element element) {
        return (((Symbol)element).flags() & 0x1000L) != 0L || (((Symbol)element).flags() & 0x1000000000L) != 0L;
    }

    public boolean overridesMethod(ExecutableElement executableElement) {
        return this.delegate.overridesMethod(executableElement);
    }

    public static String getBinaryName(TypeElement typeElement) throws IllegalArgumentException {
        if (typeElement instanceof Symbol.TypeSymbol) {
            return ((Symbol.TypeSymbol)((Object)typeElement)).flatName().toString();
        }
        throw new IllegalArgumentException();
    }

    public Doc javaDocFor(Element element) {
        if (element != null) {
            DocEnv docEnv = DocEnv.instance((Context)this.ctx);
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return docEnv.getClassDoc((Symbol.ClassSymbol)element);
                }
                case ENUM_CONSTANT: 
                case FIELD: {
                    return docEnv.getFieldDoc((Symbol.VarSymbol)element);
                }
                case METHOD: {
                    if (element.getEnclosingElement().getKind() == ElementKind.ANNOTATION_TYPE) {
                        return docEnv.getAnnotationTypeElementDoc((Symbol.MethodSymbol)element);
                    }
                    return docEnv.getMethodDoc((Symbol.MethodSymbol)element);
                }
                case CONSTRUCTOR: {
                    return docEnv.getConstructorDoc((Symbol.MethodSymbol)element);
                }
                case PACKAGE: {
                    return docEnv.getPackageDoc((Symbol.PackageSymbol)element);
                }
            }
        }
        return null;
    }

    public Element elementFor(Doc doc) {
        return doc instanceof JavadocEnv.ElementHolder ? ((JavadocEnv.ElementHolder)doc).getElement() : null;
    }

    public Iterable<? extends Element> getMembers(TypeMirror typeMirror, ElementAcceptor elementAcceptor) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (typeMirror != null) {
            JavacElements javacElements = JavacElements.instance(this.ctx);
            switch (typeMirror.getKind()) {
                case DECLARED: {
                    Object object;
                    TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                    for (Element object22 : javacElements.getAllMembers(typeElement)) {
                        if (elementAcceptor != null && !elementAcceptor.accept(object22, typeMirror) || this.isHidden(object22, arrayList, javacElements)) continue;
                        arrayList.add(object22);
                    }
                    if (typeElement.getKind().isClass()) {
                        object = new Symbol.VarSymbol(262160L, Name.Table.instance((Context)this.ctx)._this, (Type.ClassType)typeElement.asType(), (Symbol.ClassSymbol)typeElement);
                        if (elementAcceptor == null || elementAcceptor.accept((Element)object, typeMirror)) {
                            arrayList.add((Element)object);
                        }
                        if (typeElement.getSuperclass().getKind() == TypeKind.DECLARED) {
                            Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(262160L, Name.Table.instance((Context)this.ctx)._super, (Type.ClassType)typeElement.getSuperclass(), (Symbol.ClassSymbol)typeElement);
                            if (elementAcceptor == null || elementAcceptor.accept(varSymbol, typeMirror)) {
                                arrayList.add(varSymbol);
                            }
                        }
                    }
                }
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case SHORT: 
                case VOID: {
                    Object object = Symtab.instance((Context)this.ctx).classType;
                    List<Type> list = Source.instance(this.ctx).allowGenerics() ? List.of((Type)typeMirror) : List.nil();
                    object = new Type.ClassType(((Type)object).getEnclosingType(), list, ((Type)object).tsym);
                    Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(25L, Name.Table.instance((Context)this.ctx)._class, (Type)object, ((Type)typeMirror).tsym);
                    if (elementAcceptor != null && !elementAcceptor.accept(varSymbol, typeMirror)) break;
                    arrayList.add(varSymbol);
                    break;
                }
                case ARRAY: {
                    for (Element element : javacElements.getAllMembers((TypeElement)((Object)((Type)typeMirror).tsym))) {
                        if (elementAcceptor != null && !elementAcceptor.accept(element, typeMirror)) continue;
                        arrayList.add(element);
                    }
                    break;
                }
            }
        }
        return arrayList;
    }

    public Iterable<? extends Element> getLocalMembersAndVars(Scope scope, ElementAcceptor elementAcceptor) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        JavacElements javacElements = JavacElements.instance(this.ctx);
        JavacTypes javacTypes = JavacTypes.instance(this.ctx);
        while (scope != null) {
            Object object2;
            ArrayList<Element> arrayList2;
            TypeElement typeElement = scope.getEnclosingClass();
            if (typeElement != null) {
                for (Element element : scope.getLocalElements()) {
                    if (elementAcceptor != null && !elementAcceptor.accept(element, null) || this.isHidden(element, (Iterable<Element>)(arrayList2 = (ArrayList)hashMap.get(object2 = element.getSimpleName())), javacTypes)) continue;
                    arrayList.add(element);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<Element>();
                        hashMap.put(object2, arrayList2);
                    }
                    arrayList2.add(element);
                }
                TypeMirror typeMirror = typeElement.asType();
                for (Object object2 : javacElements.getAllMembers(typeElement)) {
                    ArrayList<Object> arrayList3;
                    if (elementAcceptor != null && !elementAcceptor.accept((Element)object2, typeMirror) || this.isHidden((Element)object2, (Iterable<Element>)(arrayList3 = (ArrayList<Object>)hashMap.get(arrayList2 = object2.getSimpleName())), javacTypes)) continue;
                    arrayList.add(object2);
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<Object>();
                        hashMap.put(arrayList2, arrayList3);
                    }
                    arrayList3.add(object2);
                }
            } else {
                for (Element element : scope.getLocalElements()) {
                    if (element.getKind().isClass() || element.getKind().isInterface() || elementAcceptor != null && !elementAcceptor.accept(element, element.getEnclosingElement().asType()) || this.isHidden(element, (Iterable<Element>)(arrayList2 = (ArrayList)hashMap.get(object2 = element.getSimpleName())), javacTypes)) continue;
                    arrayList.add(element);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList();
                        hashMap.put(object2, arrayList2);
                    }
                    arrayList2.add(element);
                }
            }
            scope = scope.getEnclosingScope();
        }
        return arrayList;
    }

    public Iterable<? extends Element> getLocalVars(Scope scope, ElementAcceptor elementAcceptor) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        HashMap<Name, ArrayList<Element>> hashMap = new HashMap<Name, ArrayList<Element>>();
        JavacTypes javacTypes = JavacTypes.instance(this.ctx);
        while (scope != null && scope.getEnclosingClass() != null) {
            for (Element element : scope.getLocalElements()) {
                Name name;
                ArrayList<Element> arrayList2;
                if (elementAcceptor != null && !elementAcceptor.accept(element, null) || this.isHidden(element, (Iterable<Element>)(arrayList2 = (ArrayList<Element>)hashMap.get(name = element.getSimpleName())), javacTypes)) continue;
                arrayList.add(element);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Element>();
                    hashMap.put(name, arrayList2);
                }
                arrayList2.add(element);
            }
            scope = scope.getEnclosingScope();
        }
        return arrayList;
    }

    public Iterable<? extends TypeElement> getGlobalTypes(ElementAcceptor elementAcceptor) {
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        JavacTrees javacTrees = JavacTrees.instance(this.ctx);
        JavacTypes javacTypes = JavacTypes.instance(this.ctx);
        for (CompilationUnitTree compilationUnitTree : Collections.singletonList(this.info.getCompilationUnit())) {
            ArrayList<Object> arrayList;
            ArrayList<Element> arrayList2;
            Scope scope;
            TreePath treePath = new TreePath(compilationUnitTree);
            for (scope = ((Trees)javacTrees).getScope(treePath); scope != null && scope instanceof JavacScope && !((JavacScope)scope).isStarImportScope(); scope = scope.getEnclosingScope()) {
                for (Element element : scope.getLocalElements()) {
                    Object object;
                    if (!element.getKind().isClass() && !element.getKind().isInterface() || this.isHidden(element, (Iterable<Element>)(arrayList2 = (ArrayList)hashMap.get(object = element.getSimpleName())), javacTypes)) continue;
                    if (elementAcceptor == null || elementAcceptor.accept(element, null)) {
                        hashSet.add((TypeElement)element);
                    }
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<Element>();
                        hashMap.put(object, arrayList2);
                    }
                    arrayList2.add(element);
                }
            }
            Element element = ((Trees)javacTrees).getElement(treePath);
            if (element != null && element.getKind() == ElementKind.PACKAGE) {
                for (Object object : element.getEnclosedElements()) {
                    if (this.isHidden((Element)object, (Iterable<Element>)(arrayList = (ArrayList<Object>)hashMap.get(arrayList2 = object.getSimpleName())), javacTypes)) continue;
                    if (elementAcceptor == null || elementAcceptor.accept((Element)object, null)) {
                        hashSet.add((TypeElement)object);
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                        hashMap.put(arrayList2, arrayList);
                    }
                    arrayList.add(object);
                }
            }
            while (scope != null) {
                for (Object object : scope.getLocalElements()) {
                    if (!object.getKind().isClass() && !object.getKind().isInterface() || this.isHidden((Element)object, (Iterable<Element>)(arrayList = (ArrayList)hashMap.get(arrayList2 = object.getSimpleName())), javacTypes)) continue;
                    if (elementAcceptor == null || elementAcceptor.accept((Element)object, null)) {
                        hashSet.add((TypeElement)object);
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                        hashMap.put(arrayList2, arrayList);
                    }
                    arrayList.add(object);
                }
                scope = scope.getEnclosingScope();
            }
        }
        return hashSet;
    }

    private boolean isHidden(Element element, Iterable<Element> iterable, Types types) {
        if (iterable != null) {
            for (Element element2 : iterable) {
                if (element2 != element && (element2.getClass() != element.getClass() || element2.getSimpleName() != element.getSimpleName() || (element2.getKind() == ElementKind.METHOD || element2.getKind() == ElementKind.CONSTRUCTOR) && !types.isSubsignature((ExecutableType)element2.asType(), (ExecutableType)element.asType()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isHidden(Element element, java.util.List<Element> list, Elements elements) {
        ListIterator<Element> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element2 = listIterator.next();
            if (element2 == element) {
                return true;
            }
            if (element2.getSimpleName() != element.getSimpleName()) continue;
            if (elements.hides(element2, element)) {
                return true;
            }
            if (!elements.hides(element, element2)) continue;
            listIterator.remove();
        }
        return false;
    }

    public boolean isLocal(Element element) {
        return this.delegate.isLocal(element);
    }

    public boolean alreadyDefinedIn(CharSequence charSequence, ExecutableType executableType, TypeElement typeElement) {
        return this.delegate.alreadyDefinedIn(charSequence, executableType, typeElement);
    }

    public boolean isMemberOf(Element element, TypeElement typeElement) {
        return this.delegate.isMemberOf(element, typeElement);
    }

    public ExecutableElement getOverriddenMethod(ExecutableElement executableElement) {
        return this.delegate.getOverriddenMethod(executableElement);
    }

    public boolean implementsMethod(ExecutableElement executableElement) {
        return this.delegate.implementsMethod(executableElement);
    }

    public java.util.List<? extends ExecutableElement> findUnimplementedMethods(TypeElement typeElement) {
        return this.findUnimplementedMethods(typeElement, typeElement);
    }

    private java.util.List<? extends ExecutableElement> findUnimplementedMethods(TypeElement typeElement, TypeElement typeElement2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (typeElement2.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            for (Element annotatedConstruct2 : typeElement2.getEnclosedElements()) {
                Object object;
                Element element;
                if (annotatedConstruct2.getKind() != ElementKind.METHOD || !annotatedConstruct2.getModifiers().contains((Object)Modifier.ABSTRACT) || (element = this.getImplementationOf((ExecutableElement)(object = (ExecutableElement)annotatedConstruct2), typeElement)) != null && (element != object || typeElement == typeElement2)) continue;
                arrayList.add(object);
            }
        }
        JavacTypes javacTypes = JavacTypes.instance(this.ctx);
        DeclaredType declaredType = (DeclaredType)typeElement.asType();
        for (TypeMirror typeMirror : javacTypes.directSupertypes(typeElement2.asType())) {
            for (ExecutableElement executableElement : this.findUnimplementedMethods(typeElement, (TypeElement)((DeclaredType)typeMirror).asElement())) {
                boolean bl = false;
                ExecutableType executableType = (ExecutableType)javacTypes.asMemberOf(declaredType, executableElement);
                for (ExecutableElement executableElement2 : arrayList) {
                    TypeMirror typeMirror2;
                    ExecutableType executableType2;
                    if (!executableElement2.getSimpleName().contentEquals(executableElement.getSimpleName()) || !javacTypes.isSubsignature(executableType2 = (ExecutableType)javacTypes.asMemberOf(declaredType, executableElement2), executableType)) continue;
                    TypeMirror typeMirror3 = executableType2.getReturnType();
                    if (!javacTypes.isSubtype(typeMirror3, typeMirror2 = executableType.getReturnType())) {
                        if (javacTypes.isSubtype(typeMirror2, typeMirror3)) {
                            arrayList.remove(executableElement2);
                            arrayList.add(executableElement);
                        } else if (typeMirror3.getKind() == TypeKind.DECLARED && typeMirror2.getKind() == TypeKind.DECLARED) {
                            DeclaredType declaredType2;
                            Env<AttrContext> env = Enter.instance(this.ctx).getClassEnv((Symbol.TypeSymbol)((Object)typeElement));
                            DeclaredType declaredType3 = declaredType2 = env != null ? this.findCommonSubtype((DeclaredType)typeMirror3, (DeclaredType)typeMirror2, env) : null;
                            if (declaredType2 != null) {
                                arrayList.remove(executableElement2);
                                Symbol.MethodSymbol methodSymbol = ((Symbol.MethodSymbol)executableElement2).clone((Symbol)((Object)typeElement));
                                Type.MethodType methodType = (Type.MethodType)methodSymbol.type.clone();
                                methodType.restype = (Type)((Object)declaredType2);
                                methodSymbol.type = methodType;
                                arrayList.add(methodSymbol);
                            }
                        }
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(executableElement);
            }
        }
        return arrayList;
    }

    private DeclaredType findCommonSubtype(DeclaredType declaredType, DeclaredType declaredType2, Env<AttrContext> env) {
        java.util.List<DeclaredType> list = this.getSubtypes(declaredType, env);
        java.util.List<DeclaredType> list2 = this.getSubtypes(declaredType2, env);
        Types types = this.info.getTypes();
        for (DeclaredType declaredType3 : list) {
            for (DeclaredType declaredType4 : list2) {
                if (types.isSubtype(declaredType3, declaredType4)) {
                    return declaredType3;
                }
                if (!types.isSubtype(declaredType4, declaredType3)) continue;
                return declaredType4;
            }
        }
        return null;
    }

    private java.util.List<DeclaredType> getSubtypes(DeclaredType declaredType, Env<AttrContext> env) {
        LinkedList<DeclaredType> linkedList = new LinkedList<DeclaredType>();
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        linkedList2.add(declaredType);
        ClassIndex classIndex = this.info.getClasspathInfo().getClassIndex();
        Trees trees = this.info.getTrees();
        Types types = this.info.getTypes();
        Resolve resolve = Resolve.instance(this.ctx);
        while (!linkedList2.isEmpty()) {
            DeclaredType declaredType2 = (DeclaredType)linkedList2.remove();
            TypeElement typeElement = (TypeElement)declaredType2.asElement();
            if (!hashSet.add(typeElement)) continue;
            linkedList.add(declaredType2);
            java.util.List<? extends TypeMirror> list = declaredType2.getTypeArguments();
            boolean bl = !list.iterator().hasNext();
            block1: for (ElementHandle<TypeElement> elementHandle : classIndex.getElements(ElementHandle.create(typeElement), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.allOf(ClassIndex.SearchScope.class))) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                TypeElement typeElement2 = elementHandle.resolve(this.info);
                if (typeElement2 == null || !resolve.isAccessible(env, (Symbol.TypeSymbol)((Object)typeElement2))) continue;
                if (bl) {
                    object4 = types.getDeclaredType(typeElement2, new TypeMirror[0]);
                    linkedList2.add(object4);
                    continue;
                }
                object4 = new HashMap();
                TypeMirror typeMirror = typeElement2.getSuperclass();
                if (typeMirror.getKind() == TypeKind.DECLARED && ((DeclaredType)typeMirror).asElement() == typeElement) {
                    DeclaredType declaredType3 = (DeclaredType)typeMirror;
                    Iterator<? extends TypeMirror> iterator = list.iterator();
                    object3 = declaredType3.getTypeArguments().iterator();
                    while (object3.hasNext() && iterator.hasNext()) {
                        object2 = iterator.next();
                        if (object2 == (object = (TypeMirror)object3.next())) continue;
                        if (object.getKind() != TypeKind.TYPEVAR) continue block1;
                        ((HashMap)object4).put(((TypeVariable)object).asElement(), object2);
                    }
                    if (object3.hasNext() != iterator.hasNext()) {
                        continue;
                    }
                } else {
                    for (TypeMirror typeMirror2 : typeElement2.getInterfaces()) {
                        if (((DeclaredType)typeMirror2).asElement() != typeElement) continue;
                        object3 = (DeclaredType)typeMirror2;
                        object2 = list.iterator();
                        object = object3.getTypeArguments().iterator();
                        while (object.hasNext() && object2.hasNext()) {
                            TypeMirror typeMirror3;
                            TypeMirror typeMirror4 = (TypeMirror)object2.next();
                            if (typeMirror4 == (typeMirror3 = (TypeMirror)object.next())) continue;
                            if (typeMirror3.getKind() != TypeKind.TYPEVAR) continue block1;
                            ((HashMap)object4).put(((TypeVariable)typeMirror3).asElement(), typeMirror4);
                        }
                        if (object.hasNext() != object2.hasNext()) continue block1;
                    }
                }
                linkedList2.add(this.getDeclaredType(typeElement2, (HashMap<? extends Element, ? extends TypeMirror>)object4, types));
            }
        }
        return linkedList;
    }

    private DeclaredType getDeclaredType(TypeElement typeElement, HashMap<? extends Element, ? extends TypeMirror> hashMap, Types types) {
        java.util.List<? extends TypeParameterElement> list = typeElement.getTypeParameters();
        TypeMirror[] typeMirrorArray = new TypeMirror[list.size()];
        int n = 0;
        for (TypeParameterElement typeParameterElement : list) {
            TypeMirror typeMirror = hashMap.get(typeParameterElement);
            typeMirrorArray[n++] = typeMirror != null ? typeMirror : typeParameterElement.asType();
        }
        Element element = typeElement.getEnclosingElement();
        if ((element.getKind().isClass() || element.getKind().isInterface()) && !((TypeElement)element).getTypeParameters().isEmpty()) {
            return types.getDeclaredType(this.getDeclaredType((TypeElement)element, hashMap, types), typeElement, typeMirrorArray);
        }
        return types.getDeclaredType(typeElement, typeMirrorArray);
    }

    public static interface ElementAcceptor {
        public boolean accept(Element var1, TypeMirror var2);
    }
}

