/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.classpath.GlobalSourcePath;
import org.netbeans.modules.java.source.usages.ClassIndexFactory;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImplEvent;
import org.netbeans.modules.java.source.usages.ClassIndexImplListener;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClassIndexManagerEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManagerListener;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassIndex {
    private static final Logger LOGGER = Logger.getLogger(ClassIndex.class.getName());
    private final ClassPath bootPath;
    private final ClassPath classPath;
    private final ClassPath sourcePath;
    private final Set<URL> oldSources;
    private final Set<URL> oldBoot;
    private final Set<URL> oldCompile;
    private final Set<ClassIndexImpl> sourceIndeces;
    private final Set<ClassIndexImpl> depsIndeces;
    private final List<ClassIndexListener> listeners = new CopyOnWriteArrayList<ClassIndexListener>();
    private final SPIListener spiListener = new SPIListener();

    ClassIndex(ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
        assert (classPath != null);
        assert (classPath2 != null);
        assert (classPath3 != null);
        this.bootPath = classPath;
        this.classPath = classPath2;
        this.sourcePath = classPath3;
        this.oldBoot = new HashSet<URL>();
        this.oldCompile = new HashSet<URL>();
        this.oldSources = new HashSet<URL>();
        this.depsIndeces = new HashSet<ClassIndexImpl>();
        this.sourceIndeces = new HashSet<ClassIndexImpl>();
        ClassIndexManager classIndexManager = ClassIndexManager.getDefault();
        classIndexManager.addClassIndexManagerListener((ClassIndexManagerListener)WeakListeners.create(ClassIndexManagerListener.class, (EventListener)this.spiListener, (Object)classIndexManager));
        this.bootPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.spiListener, (Object)this.bootPath));
        this.classPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.spiListener, (Object)this.classPath));
        this.sourcePath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.spiListener, (Object)this.sourcePath));
        this.reset(true, true);
    }

    public void addClassIndexListener(ClassIndexListener classIndexListener) {
        assert (classIndexListener != null);
        this.listeners.add(classIndexListener);
    }

    public void removeClassIndexListener(ClassIndexListener classIndexListener) {
        assert (classIndexListener != null);
        this.listeners.remove(classIndexListener);
    }

    public Set<ElementHandle<TypeElement>> getElements(ElementHandle<TypeElement> elementHandle, Set<SearchKind> set, Set<SearchScope> set2) {
        assert (elementHandle != null);
        assert (elementHandle.getSignature()[0] != null);
        assert (set != null);
        HashSet hashSet = new HashSet();
        Iterable<? extends ClassIndexImpl> iterable = this.getQueries(set2);
        Set<ClassIndexImpl.UsageType> set3 = ClassIndex.encodeSearchKind(elementHandle.getKind(), set);
        String string = elementHandle.getSignature()[0];
        ResultConvertor<ElementHandle<TypeElement>> resultConvertor = ResultConvertor.elementHandleConvertor();
        try {
            if (!set3.isEmpty()) {
                for (ClassIndexImpl classIndexImpl : iterable) {
                    classIndexImpl.search(string, set3, resultConvertor, hashSet);
                }
            }
            return Collections.unmodifiableSet(hashSet);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public Set<FileObject> getResources(ElementHandle<TypeElement> elementHandle, Set<SearchKind> set, Set<SearchScope> set2) {
        assert (elementHandle != null);
        assert (elementHandle.getSignature()[0] != null);
        assert (set != null);
        HashSet hashSet = new HashSet();
        Iterable<? extends ClassIndexImpl> iterable = this.getQueries(set2);
        Set<ClassIndexImpl.UsageType> set3 = ClassIndex.encodeSearchKind(elementHandle.getKind(), set);
        String string = elementHandle.getSignature()[0];
        try {
            if (!set3.isEmpty()) {
                for (ClassIndexImpl classIndexImpl : iterable) {
                    ResultConvertor<FileObject> resultConvertor = ResultConvertor.fileObjectConvertor(classIndexImpl.getSourceRoots());
                    classIndexImpl.search(string, set3, resultConvertor, hashSet);
                }
            }
            return Collections.unmodifiableSet(hashSet);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public Set<ElementHandle<TypeElement>> getDeclaredTypes(String string, NameKind nameKind, Set<SearchScope> set) {
        assert (string != null);
        assert (nameKind != null);
        HashSet hashSet = new HashSet();
        Iterable<? extends ClassIndexImpl> iterable = this.getQueries(set);
        ResultConvertor<ElementHandle<TypeElement>> resultConvertor = ResultConvertor.elementHandleConvertor();
        try {
            for (ClassIndexImpl classIndexImpl : iterable) {
                classIndexImpl.getDeclaredTypes(string, nameKind, resultConvertor, hashSet);
            }
            LOGGER.fine(String.format("ClassIndex.getDeclaredTypes returned %d elements\n", hashSet.size()));
            return Collections.unmodifiableSet(hashSet);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public Set<String> getPackageNames(String string, boolean bl, Set<SearchScope> set) {
        assert (string != null);
        HashSet<String> hashSet = new HashSet<String>();
        Iterable<? extends ClassIndexImpl> iterable = this.getQueries(set);
        try {
            for (ClassIndexImpl classIndexImpl : iterable) {
                classIndexImpl.getPackageNames(string, bl, hashSet);
            }
            return Collections.unmodifiableSet(hashSet);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    private void reset(final boolean bl, final boolean bl2) {
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ClassIndex classIndex = ClassIndex.this;
                synchronized (classIndex) {
                    if (bl) {
                        for (ClassIndexImpl classIndexImpl : ClassIndex.this.sourceIndeces) {
                            classIndexImpl.removeClassIndexImplListener(ClassIndex.this.spiListener);
                        }
                        ClassIndex.this.sourceIndeces.clear();
                        ClassIndex.this.oldSources.clear();
                        ClassIndex.this.createQueriesForRoots(ClassIndex.this.sourcePath, true, ClassIndex.this.sourceIndeces, ClassIndex.this.oldSources);
                    }
                    if (bl2) {
                        for (ClassIndexImpl classIndexImpl : ClassIndex.this.depsIndeces) {
                            classIndexImpl.removeClassIndexImplListener(ClassIndex.this.spiListener);
                        }
                        ClassIndex.this.depsIndeces.clear();
                        ClassIndex.this.oldBoot.clear();
                        ClassIndex.this.oldCompile.clear();
                        ClassIndex.this.createQueriesForRoots(ClassIndex.this.bootPath, false, ClassIndex.this.depsIndeces, ClassIndex.this.oldBoot);
                        ClassIndex.this.createQueriesForRoots(ClassIndex.this.classPath, false, ClassIndex.this.depsIndeces, ClassIndex.this.oldCompile);
                    }
                }
            }
        });
    }

    private synchronized Iterable<? extends ClassIndexImpl> getQueries(Set<SearchScope> set) {
        HashSet<ClassIndexImpl> hashSet = new HashSet<ClassIndexImpl>();
        if (set.contains((Object)SearchScope.SOURCE)) {
            hashSet.addAll(this.sourceIndeces);
        }
        if (set.contains((Object)SearchScope.DEPENDENCIES)) {
            hashSet.addAll(this.depsIndeces);
        }
        LOGGER.fine(String.format("ClassIndex.queries[Scope=%s, sourcePath=%s, bootPath=%s, classPath=%s] => %s\n", set, this.sourcePath, this.bootPath, this.classPath, hashSet));
        return hashSet;
    }

    private synchronized Set<? extends URL> getOldState(Set<SearchScope> set) {
        HashSet<URL> hashSet = new HashSet<URL>();
        if (set.contains((Object)SearchScope.SOURCE)) {
            hashSet.addAll(this.oldSources);
        }
        if (set.contains((Object)SearchScope.DEPENDENCIES)) {
            hashSet.addAll(this.oldBoot);
            hashSet.addAll(this.oldCompile);
        }
        return hashSet;
    }

    private void createQueriesForRoots(ClassPath classPath, boolean bl, Set<? super ClassIndexImpl> set, Set<? super URL> set2) {
        GlobalSourcePath globalSourcePath = GlobalSourcePath.getDefault();
        List list = classPath.entries();
        for (ClassPath.Entry entry : list) {
            URL[] uRLArray;
            if (!bl) {
                uRLArray = globalSourcePath.getSourceRootForBinaryRoot(entry.getURL(), classPath, true);
                if (uRLArray == null) {
                    uRLArray = new URL[]{entry.getURL()};
                }
            } else {
                uRLArray = new URL[]{entry.getURL()};
            }
            for (URL uRL : uRLArray) {
                set2.add(uRL);
                ClassIndexImpl classIndexImpl = ClassIndexManager.getDefault().getUsagesQuery(uRL);
                if (classIndexImpl == null) continue;
                classIndexImpl.addClassIndexImplListener(this.spiListener);
                set.add(classIndexImpl);
            }
        }
    }

    private static Set<ClassIndexImpl.UsageType> encodeSearchKind(ElementKind elementKind, Set<SearchKind> set) {
        assert (set != null);
        EnumSet<ClassIndexImpl.UsageType> enumSet = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
        block12: for (SearchKind searchKind : set) {
            switch (searchKind) {
                case METHOD_REFERENCES: {
                    enumSet.add(ClassIndexImpl.UsageType.METHOD_REFERENCE);
                    continue block12;
                }
                case FIELD_REFERENCES: {
                    enumSet.add(ClassIndexImpl.UsageType.FIELD_REFERENCE);
                    continue block12;
                }
                case TYPE_REFERENCES: {
                    enumSet.add(ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    continue block12;
                }
                case IMPLEMENTORS: {
                    switch (elementKind) {
                        case INTERFACE: 
                        case ANNOTATION_TYPE: {
                            enumSet.add(ClassIndexImpl.UsageType.SUPER_INTERFACE);
                            continue block12;
                        }
                        case CLASS: {
                            enumSet.add(ClassIndexImpl.UsageType.SUPER_CLASS);
                            continue block12;
                        }
                        case ENUM: {
                            continue block12;
                        }
                        case OTHER: {
                            enumSet.add(ClassIndexImpl.UsageType.SUPER_INTERFACE);
                            enumSet.add(ClassIndexImpl.UsageType.SUPER_CLASS);
                            continue block12;
                        }
                    }
                    throw new IllegalArgumentException();
                }
            }
            throw new IllegalArgumentException();
        }
        return enumSet;
    }

    static {
        ClassIndexImpl.FACTORY = new ClassIndexFactoryImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SPIListener
    implements ClassIndexImplListener,
    ClassIndexManagerListener,
    PropertyChangeListener {
        private SPIListener() {
        }

        @Override
        public void typesAdded(ClassIndexImplEvent classIndexImplEvent) {
            assert (classIndexImplEvent != null);
            TypesEvent typesEvent = new TypesEvent(ClassIndex.this, classIndexImplEvent.getTypes());
            for (ClassIndexListener classIndexListener : ClassIndex.this.listeners) {
                classIndexListener.typesAdded(typesEvent);
            }
        }

        @Override
        public void typesRemoved(ClassIndexImplEvent classIndexImplEvent) {
            assert (classIndexImplEvent != null);
            TypesEvent typesEvent = new TypesEvent(ClassIndex.this, classIndexImplEvent.getTypes());
            for (ClassIndexListener classIndexListener : ClassIndex.this.listeners) {
                classIndexListener.typesRemoved(typesEvent);
            }
        }

        @Override
        public void typesChanged(ClassIndexImplEvent classIndexImplEvent) {
            assert (classIndexImplEvent != null);
            TypesEvent typesEvent = new TypesEvent(ClassIndex.this, classIndexImplEvent.getTypes());
            for (ClassIndexListener classIndexListener : ClassIndex.this.listeners) {
                classIndexListener.typesChanged(typesEvent);
            }
        }

        @Override
        public void classIndexAdded(ClassIndexManagerEvent classIndexManagerEvent) {
            Set<? extends URL> set = classIndexManagerEvent.getRoots();
            assert (set != null);
            LinkedList linkedList = new LinkedList();
            boolean bl = this.containsRoot(ClassIndex.this.sourcePath, set, linkedList, false);
            boolean bl2 = this.containsRoot(ClassIndex.this.bootPath, set, linkedList, true);
            if (bl || (bl2 |= this.containsRoot(ClassIndex.this.classPath, set, linkedList, true))) {
                ClassIndex.this.reset(bl, bl2);
                RootsEvent rootsEvent = new RootsEvent(ClassIndex.this, linkedList);
                for (ClassIndexListener classIndexListener : ClassIndex.this.listeners) {
                    classIndexListener.rootsAdded(rootsEvent);
                }
            }
        }

        @Override
        public void classIndexRemoved(ClassIndexManagerEvent classIndexManagerEvent) {
        }

        private boolean containsRoot(ClassPath classPath, Set<? extends URL> set, List<? super URL> list, boolean bl) {
            List list2 = classPath.entries();
            GlobalSourcePath globalSourcePath = GlobalSourcePath.getDefault();
            boolean bl2 = false;
            for (ClassPath.Entry entry : list2) {
                URL uRL = entry.getURL();
                URL[] uRLArray = null;
                if (bl) {
                    uRLArray = globalSourcePath.getSourceRootForBinaryRoot(entry.getURL(), classPath, false);
                }
                if (uRLArray == null) {
                    if (!set.contains(uRL)) continue;
                    list.add(uRL);
                    bl2 = true;
                    continue;
                }
                for (URL uRL2 : uRLArray) {
                    if (!set.contains(uRL2)) continue;
                    list.add(uRL);
                    bl2 = true;
                }
            }
            return bl2;
        }

        private boolean containsNewRoot(ClassPath classPath, Set<? extends URL> set, List<? super URL> list, List<? super URL> list2, boolean bl) throws IOException {
            List list3 = classPath.entries();
            GlobalSourcePath globalSourcePath = GlobalSourcePath.getDefault();
            ClassIndexManager classIndexManager = ClassIndexManager.getDefault();
            boolean bl2 = false;
            for (ClassPath.Entry entry : list3) {
                URL uRL = entry.getURL();
                URL[] uRLArray = null;
                if (bl) {
                    uRLArray = globalSourcePath.getSourceRootForBinaryRoot(entry.getURL(), classPath, false);
                }
                if (uRLArray == null) {
                    if (set.remove(uRL) || classIndexManager.getUsagesQuery(uRL) == null) continue;
                    list.add(uRL);
                    bl2 = true;
                    continue;
                }
                for (URL uRL2 : uRLArray) {
                    if (set.remove(uRL2) || classIndexManager.getUsagesQuery(uRL2) == null) continue;
                    list.add(uRL2);
                    bl2 = true;
                }
            }
            boolean bl3 = !set.isEmpty();
            list2.addAll(set);
            return bl2 |= bl3;
        }

        private boolean containsRoot(Set<? extends URL> set, Set<? extends URL> set2, List<? super URL> list) {
            boolean bl = false;
            for (URL uRL : set) {
                if (!set2.contains(uRL)) continue;
                list.add(uRL);
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("entries".equals(propertyChangeEvent.getPropertyName())) {
                LinkedList linkedList = new LinkedList();
                LinkedList linkedList2 = new LinkedList();
                boolean bl = false;
                boolean bl2 = false;
                try {
                    Serializable serializable;
                    Object object;
                    Object object2 = propertyChangeEvent.getSource();
                    if (object2 == ClassIndex.this.sourcePath) {
                        object = ClassIndex.this;
                        synchronized (object) {
                            serializable = new HashSet(ClassIndex.this.oldSources);
                        }
                        bl = this.containsNewRoot(ClassIndex.this.sourcePath, (Set<? extends URL>)((Object)serializable), linkedList, linkedList2, false);
                    } else if (object2 == ClassIndex.this.classPath) {
                        object = ClassIndex.this;
                        synchronized (object) {
                            serializable = new HashSet(ClassIndex.this.oldCompile);
                        }
                        bl2 = this.containsNewRoot(ClassIndex.this.classPath, (Set<? extends URL>)((Object)serializable), linkedList, linkedList2, true);
                    } else if (object2 == ClassIndex.this.bootPath) {
                        object = ClassIndex.this;
                        synchronized (object) {
                            serializable = new HashSet(ClassIndex.this.oldBoot);
                        }
                        bl2 = this.containsNewRoot(ClassIndex.this.bootPath, (Set<? extends URL>)((Object)serializable), linkedList, linkedList2, true);
                    }
                    if (bl || bl2) {
                        ClassIndex.this.reset(bl, bl2);
                        serializable = linkedList.isEmpty() ? null : new RootsEvent(ClassIndex.this, linkedList);
                        object = linkedList2.isEmpty() ? null : new RootsEvent(ClassIndex.this, linkedList2);
                        JavaSourceAccessor.getINSTANCE().runSpecialTask(new CancellableTask<CompilationInfo>((RootsEvent)object){
                            final /* synthetic */ RootsEvent val$re;
                            {
                                this.val$re = rootsEvent2;
                            }

                            @Override
                            public void cancel() {
                            }

                            @Override
                            public void run(CompilationInfo compilationInfo) throws Exception {
                                if (serializable != null) {
                                    for (ClassIndexListener classIndexListener : ClassIndex.this.listeners) {
                                        classIndexListener.rootsAdded(serializable);
                                    }
                                }
                                if (this.val$re != null) {
                                    for (ClassIndexListener classIndexListener : ClassIndex.this.listeners) {
                                        classIndexListener.rootsRemoved(this.val$re);
                                    }
                                }
                            }
                        }, JavaSource.Priority.MAX);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private static class ClassIndexFactoryImpl
    implements ClassIndexFactory {
        private ClassIndexFactoryImpl() {
        }

        public ClassIndex create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
            return new ClassIndex(classPath, classPath2, classPath3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchScope {
        SOURCE,
        DEPENDENCIES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchKind {
        IMPLEMENTORS,
        METHOD_REFERENCES,
        FIELD_REFERENCES,
        TYPE_REFERENCES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameKind {
        SIMPLE_NAME,
        PREFIX,
        CASE_INSENSITIVE_PREFIX,
        CAMEL_CASE,
        REGEXP,
        CASE_INSENSITIVE_REGEXP,
        CAMEL_CASE_INSENSITIVE;

    }
}

