/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.tasklist.impl.OpenTaskAction;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.FoldingTaskListModel;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.modules.tasklist.ui.TaskListModel;
import org.netbeans.modules.tasklist.ui.TaskListTableUI;
import org.netbeans.modules.tasklist.ui.TaskListTopComponent;
import org.netbeans.modules.tasklist.ui.Util;
import org.netbeans.spi.tasklist.Task;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class TaskListTable
extends JTable {
    private TableCellRenderer foldingGroupRenderer;
    private TableCellRenderer groupRenderer;
    private Action defaultAction = new DefaultAction();
    private Action nextTaskAction = new TaskNavigationAction(true);
    private Action prevTaskAction = new TaskNavigationAction(false);
    private static final Icon openedIcon = (Icon)UIManager.get("Tree.expandedIcon");
    private static final Icon closedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
    private static Map<Image, ImageIcon> iconCache = new HashMap<Image, ImageIcon>(10);
    private static Color unfocusedSelBg = null;
    private static Color unfocusedSelFg = null;

    public TaskListTable() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TaskListTable.this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                TaskListTable.this.maybePopup(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = TaskListTable.this.rowAtPoint(mouseEvent.getPoint());
                if (TaskListTable.this.isFoldingModel()) {
                    FoldingTaskListModel foldingTaskListModel = TaskListTable.this.getFoldingModel();
                    if (mouseEvent.getClickCount() == 2) {
                        if (foldingTaskListModel.isGroupRow(n)) {
                            foldingTaskListModel.toggleGroupExpanded(n);
                            return;
                        }
                    } else if (mouseEvent.getClickCount() == 1 && foldingTaskListModel.isGroupRow(n)) {
                        TaskListTable.this.maybeExpandGroup(mouseEvent.getPoint());
                        return;
                    }
                }
                if (mouseEvent.getClickCount() == 2) {
                    TaskListTable.this.defaultAction.actionPerformed(null);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                TaskListTable.this.repaintSelectedRow();
            }

            public void focusLost(FocusEvent focusEvent) {
                TaskListTable.this.repaintSelectedRow();
            }
        });
        this.setSelectionMode(0);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setAutoCreateColumnsFromModel(false);
        int n = 18 + 2 * this.getIntercellSpacing().height;
        this.setRowHeight(Math.max(this.getRowHeight(), n));
        InputMap inputMap = this.getInputMap(1);
        Object object = inputMap.get(KeyStroke.getKeyStroke(39, 0));
        Object object2 = inputMap.get(KeyStroke.getKeyStroke(37, 0));
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "defaultAction");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.getActionMap().put("org.openide.actions.PopupAction", new PopupAction());
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get(object2);
        Action action2 = actionMap.get(object);
        actionMap.put(object2, new ToggleGroupAction(false, action));
        actionMap.put(object, new ToggleGroupAction(true, action2));
        actionMap.put("defaultAction", this.defaultAction);
        actionMap.put("jumpPrev", this.prevTaskAction);
        actionMap.put("jumpNext", this.nextTaskAction);
    }

    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                MyTableColumn myTableColumn = new MyTableColumn(i);
                if (i == 4) {
                    myTableColumn.setCellRenderer(new LeftDotRenderer());
                } else if (i != 0) {
                    myTableColumn.setCellRenderer(new TooltipRenderer());
                }
                this.addColumn(myTableColumn);
            }
        }
    }

    public void removeNotify() {
        if (this.getModel() instanceof TaskListModel) {
            this.storeColumnState();
        }
        super.removeNotify();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new MyTableHeader(this.columnModel);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 == 0) {
            if (this.isFoldingModel() && this.getFoldingModel().isGroupRow(n)) {
                return this.getFoldingGroupRenderer();
            }
            return this.getGroupRenderer();
        }
        return super.getCellRenderer(n, n2);
    }

    private void maybePopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            int n = this.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0) {
                this.getSelectionModel().setSelectionInterval(n, n);
            }
            JPopupMenu jPopupMenu = Util.createPopup(this);
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private TableCellRenderer getFoldingGroupRenderer() {
        if (null == this.foldingGroupRenderer) {
            this.foldingGroupRenderer = new FoldingTaskGroupRenderer();
        }
        return this.foldingGroupRenderer;
    }

    private TableCellRenderer getGroupRenderer() {
        if (null == this.groupRenderer) {
            this.groupRenderer = new TaskGroupRenderer();
        }
        return this.groupRenderer;
    }

    private void maybeExpandGroup(Point point) {
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        if (0 != n2) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n, n2, false);
        TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
        this.prepareRenderer(tableCellRenderer, n, n2);
        if (tableCellRenderer instanceof FoldingTaskGroupRenderer) {
            Icon icon = ((FoldingTaskGroupRenderer)tableCellRenderer).getIcon();
            rectangle.grow(0, -(rectangle.height - openedIcon.getIconHeight()) / 2);
            rectangle.x = this.getColumnModel().getColumnMargin();
            rectangle.width = openedIcon.getIconWidth();
            if (rectangle.contains(point)) {
                FoldingTaskListModel foldingTaskListModel = this.getFoldingModel();
                foldingTaskListModel.toggleGroupExpanded(n);
            }
        }
    }

    private void storeColumnState() {
        int n = this.getColumnModel().getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            if (!(tableColumn instanceof MyTableColumn)) continue;
            ((MyTableColumn)tableColumn).storeState();
        }
    }

    public void setUI(TableUI tableUI) {
        super.setUI(new TaskListTableUI());
        this.setTableHeader(this.createDefaultTableHeader());
    }

    public void setModel(TableModel tableModel) {
        if (this.getModel() instanceof TaskListModel && tableModel != this.getModel()) {
            this.storeColumnState();
            ((TaskListModel)this.getModel()).detach();
        }
        if (tableModel instanceof TaskListModel) {
            ((TaskListModel)tableModel).attach();
        }
        super.setModel(tableModel);
        this.createDefaultColumnsFromModel();
    }

    private boolean isFoldingModel() {
        return this.getModel() instanceof FoldingTaskListModel;
    }

    private FoldingTaskListModel getFoldingModel() {
        return this.isFoldingModel() ? (FoldingTaskListModel)this.getModel() : null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        if (this.isFoldingModel() && this.getFoldingModel().isGroupRow(n)) {
            return this.getFoldingModel().getGroupAtRow(n).getGroup().getDescription();
        }
        return super.getToolTipText(mouseEvent);
    }

    Task getSelectedTask() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return ((TaskListModel)this.getModel()).getTaskAtRow(n);
    }

    int getSortColumn() {
        return ((TaskListModel)this.getModel()).getSortingColumnn();
    }

    void setSortColumn(int n) {
        ((TaskListModel)this.getModel()).toggleSort(n);
    }

    boolean isAscendingSort() {
        return ((TaskListModel)this.getModel()).isAscendingSort();
    }

    void setAscendingSort(boolean bl) {
        ((TaskListModel)this.getModel()).setAscendingSort(bl);
    }

    private Point getPositionForPopup() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return null;
        }
        Rectangle rectangle = this.getCellRect(n, 0, true);
        if (rectangle == null) {
            return null;
        }
        return new Point(0, rectangle.y + rectangle.height);
    }

    public Color getSelectionBackground() {
        if (!(this.hasFocus() || TaskListTable.isNimbus() || TaskListTable.isGTK())) {
            return TaskListTable.getUnfocusedSelectionBackground();
        }
        return UIManager.getColor("Table.selectionBackground");
    }

    public Color getSelectionForeground() {
        if (!(this.hasFocus() || TaskListTable.isNimbus() || TaskListTable.isGTK())) {
            return TaskListTable.getUnfocusedSelectionForeground();
        }
        return UIManager.getColor("Table.selectionForeground");
    }

    private void repaintSelectedRow() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n, 0, true);
        Rectangle rectangle2 = this.getCellRect(n, this.getColumnCount() - 1, true);
        rectangle.width = rectangle2.x + rectangle2.width;
        this.repaint(rectangle);
    }

    private static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!Color.WHITE.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    private static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    private static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private static boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    private class PopupAction
    extends AbstractAction {
        public PopupAction() {
            super("Popup");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Point point = TaskListTable.this.getPositionForPopup();
            if (point == null) {
                point = new Point(0, 0);
            }
            JPopupMenu jPopupMenu = Util.createPopup(TaskListTable.this);
            jPopupMenu.show(TaskListTable.this, point.x, point.y);
        }

        public boolean isEnabled() {
            return TaskListTable.this.isFocusOwner();
        }
    }

    private class SortingHeaderRenderer
    implements TableCellRenderer,
    UIResource {
        private TableCellRenderer origRenderer;
        private static final String SORT_ASC_ICON = "org/netbeans/modules/tasklist/ui/resources/columnsSortedAsc.gif";
        private static final String SORT_DESC_ICON = "org/netbeans/modules/tasklist/ui/resources/columnsSortedDesc.gif";

        SortingHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.origRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.origRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                TaskListModel taskListModel = (TaskListModel)TaskListTable.this.getModel();
                if (n2 == taskListModel.getSortingColumnn()) {
                    jLabel.setIcon(this.getProperIcon(!taskListModel.isAscendingSort()));
                    jLabel.setHorizontalTextPosition(2);
                } else {
                    jLabel.setIcon(null);
                }
            }
            return component;
        }

        private ImageIcon getProperIcon(boolean bl) {
            if (bl) {
                return new ImageIcon(Utilities.loadImage((String)SORT_DESC_ICON));
            }
            return new ImageIcon(Utilities.loadImage((String)SORT_ASC_ICON));
        }
    }

    private static class TooltipRenderer
    extends DefaultTableCellRenderer {
        private TooltipRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.getColumnModel().getColumn(n2).getWidth();
            n3 = (int)((double)n3 - jTable.getIntercellSpacing().getWidth());
            Insets insets = this.getBorder().getBorderInsets(this);
            String string = this.getText();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (fontMetrics.stringWidth(string) > (n3 -= insets.left + insets.right)) {
                this.setToolTipText(string);
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private static class LeftDotRenderer
    extends DefaultTableCellRenderer {
        private LeftDotRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.getColumnModel().getColumn(n2).getWidth();
            n3 = (int)((double)n3 - jTable.getIntercellSpacing().getWidth());
            Insets insets = this.getBorder().getBorderInsets(this);
            String string = this.getText();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (fontMetrics.stringWidth(string) > (n3 -= insets.left + insets.right)) {
                int n4;
                this.setToolTipText(object.toString());
                String string2 = "...";
                int n5 = fontMetrics.stringWidth(string2);
                for (n4 = string.length() - 1; n4 > 0 && (n5 += fontMetrics.charWidth(string.charAt(n4))) <= n3; --n4) {
                }
                this.setText(string2 + string.substring(n4 + 1));
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private class MyTableColumn
    extends TableColumn {
        private float ratio;

        public MyTableColumn(int n) {
            super(n);
            if (n == 0) {
                this.setWidth(TaskListTable.this.isFoldingModel() ? 35 : 20);
                this.setMinWidth(TaskListTable.this.isFoldingModel() ? 35 : 20);
                this.setMaxWidth(TaskListTable.this.isFoldingModel() ? 35 : 20);
                this.setResizable(false);
            } else {
                switch (this.modelIndex) {
                    case 1: {
                        this.ratio = 0.65f;
                        break;
                    }
                    case 4: {
                        this.ratio = 0.2f;
                        break;
                    }
                    case 2: {
                        this.ratio = 0.1f;
                        break;
                    }
                    case 3: {
                        this.ratio = 0.05f;
                    }
                }
                this.ratio = Settings.getDefault().getPreferredColumnWidth(n, TaskListTable.this.isFoldingModel(), this.ratio);
            }
        }

        public int getPreferredWidth() {
            int n = this.getModelIndex();
            if (TaskListTable.this.isFoldingModel() && n == 0) {
                return this.getWidth();
            }
            int n2 = TaskListTable.this.getParent().getWidth();
            return (int)((float)n2 * this.ratio);
        }

        public void storeState() {
            float f = TaskListTable.this.getWidth();
            if (f > 0.0f) {
                this.ratio = (float)this.getWidth() / f;
                Settings.getDefault().setPreferredColumnWidth(this.getModelIndex(), TaskListTable.this.isFoldingModel(), this.ratio);
            }
        }
    }

    private class TaskNavigationAction
    extends AbstractAction {
        private boolean navigateToNextTask;

        public TaskNavigationAction(boolean bl) {
            super(bl ? NbBundle.getMessage(TaskListTable.class, (String)"LBL_NextTask") : NbBundle.getMessage(TaskListTable.class, (String)"LBL_PrevTask"));
            this.navigateToNextTask = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (0 == TaskListTable.this.getModel().getRowCount()) {
                return;
            }
            int n = TaskListTable.this.getSelectedRow();
            if (n < 0) {
                n = 0;
            } else if (!TaskListTable.this.isFoldingModel() || !TaskListTable.this.getFoldingModel().isGroupRow(n)) {
                n += this.navigateToNextTask ? 1 : -1;
            }
            TaskListModel taskListModel = (TaskListModel)TaskListTable.this.getModel();
            while (true) {
                Object object;
                if (n < 0) {
                    n = taskListModel.getRowCount() - 1;
                } else if (n >= taskListModel.getRowCount()) {
                    n = 0;
                }
                Task task = taskListModel.getTaskAtRow(n);
                if (null != task) {
                    TaskListTable.this.getSelectionModel().setSelectionInterval(n, n);
                    TaskListTable.this.scrollRectToVisible(TaskListTable.this.getCellRect(n, 0, true));
                    object = new OpenTaskAction(task);
                    if (object.isEnabled()) {
                        object.actionPerformed(actionEvent);
                        break;
                    }
                    TaskListTopComponent.findInstance().requestActive();
                    break;
                }
                if (TaskListTable.this.isFoldingModel() && !((FoldingTaskListModel.FoldingGroup)(object = TaskListTable.this.getFoldingModel().getGroupAtRow(n))).isExpanded()) {
                    ((FoldingTaskListModel.FoldingGroup)object).setExpanded(true);
                }
                n += this.navigateToNextTask ? 1 : -1;
            }
        }
    }

    private class DefaultAction
    extends AbstractAction {
        private DefaultAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Task task = TaskListTable.this.getSelectedTask();
            if (null != task) {
                Action action = Util.getDefaultAction(task);
                if (action.isEnabled()) {
                    action.actionPerformed(null);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    private class MyTableHeader
    extends JTableHeader {
        public MyTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() != 1) {
                        return;
                    }
                    int n = MyTableHeader.this.columnAtPoint(mouseEvent.getPoint());
                    if (n > 0 && TaskListTable.this.getModel() instanceof TaskListModel) {
                        ((TaskListModel)TaskListTable.this.getModel()).toggleSort(n);
                        MyTableHeader.this.repaint();
                    }
                }
            });
            this.setReorderingAllowed(false);
        }

        public void setDraggedColumn(TableColumn tableColumn) {
            if (null != tableColumn && tableColumn.getModelIndex() == 0) {
                return;
            }
            super.setDraggedColumn(tableColumn);
        }

        public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
            if (!(tableCellRenderer instanceof SortingHeaderRenderer)) {
                tableCellRenderer = new SortingHeaderRenderer(tableCellRenderer);
            }
            super.setDefaultRenderer(tableCellRenderer);
        }

        public void setUI(TableHeaderUI tableHeaderUI) {
            super.setUI(tableHeaderUI);
        }

        public void setResizingColumn(TableColumn tableColumn) {
            if (null != this.getResizingColumn() && null == tableColumn) {
                TaskListTable.this.storeColumnState();
            }
            super.setResizingColumn(tableColumn);
        }
    }

    private class ToggleGroupAction
    extends AbstractAction {
        private Action defaultAction;
        private boolean expand;

        public ToggleGroupAction(boolean bl, Action action) {
            this.defaultAction = action;
            this.expand = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TaskListTable.this.isFoldingModel()) {
                FoldingTaskListModel.FoldingGroup foldingGroup;
                FoldingTaskListModel foldingTaskListModel = TaskListTable.this.getFoldingModel();
                int n = TaskListTable.this.getSelectedRow();
                if (n >= 0 && null != (foldingGroup = foldingTaskListModel.getGroupAtRow(n)) && foldingGroup.isExpanded() != this.expand) {
                    foldingGroup.setExpanded(this.expand);
                    return;
                }
            }
            this.defaultAction.actionPerformed(actionEvent);
        }
    }

    private class FoldingTaskGroupRenderer
    extends DefaultTableCellRenderer {
        private final Color GTK_BK_COLOR = new Color(184, 207, 229);
        private final Color AQUA_BK_COLOR = new Color(225, 235, 240);
        private final boolean isGTK = "GTK".equals(UIManager.getLookAndFeel().getID());
        private final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());

        public FoldingTaskGroupRenderer() {
            UIManager.get("nb.propertysheet");
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component;
            if (TaskListTable.this.getFoldingModel().isGroupRow(n)) {
                // empty if block
            }
            if ((component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JLabel && object instanceof FoldingTaskListModel.FoldingGroup) {
                FoldingTaskListModel.FoldingGroup foldingGroup = (FoldingTaskListModel.FoldingGroup)object;
                JLabel jLabel = (JLabel)component;
                jLabel.setText(foldingGroup.getGroup().getDisplayName() + " (" + foldingGroup.getTaskCount() + ")");
                Icon icon = foldingGroup.isExpanded() ? openedIcon : closedIcon;
                jLabel.setIcon(icon);
                jLabel.setToolTipText(foldingGroup.getGroup().getDescription());
                jLabel.setHorizontalAlignment(2);
                if (!bl) {
                    jLabel.setBackground(this.getBackgroundColor());
                }
            }
            return component;
        }

        public Color getBackgroundColor() {
            if (this.isGTK) {
                return this.GTK_BK_COLOR;
            }
            if (this.isAqua) {
                return this.AQUA_BK_COLOR;
            }
            return UIManager.getColor("PropSheet.setBackground");
        }
    }

    private class TaskGroupRenderer
    extends DefaultTableCellRenderer {
        private TaskGroupRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel && object instanceof TaskGroup) {
                TaskGroup taskGroup = (TaskGroup)object;
                JLabel jLabel = (JLabel)component;
                jLabel.setText(null);
                ImageIcon imageIcon = (ImageIcon)iconCache.get(taskGroup.getIcon());
                if (null == imageIcon) {
                    imageIcon = new ImageIcon(taskGroup.getIcon());
                    iconCache.put(taskGroup.getIcon(), imageIcon);
                }
                jLabel.setIcon(imageIcon);
                jLabel.setToolTipText(taskGroup.getDescription());
                jLabel.setHorizontalAlignment(4);
            }
            return component;
        }
    }
}

