/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.tasklist.filter.FilterEditor;
import org.netbeans.modules.tasklist.filter.FilterRepository;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.ui.MenuToggleButton;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FiltersMenuButton
extends MenuToggleButton
implements PropertyChangeListener {
    private TaskManagerImpl taskManager = TaskManagerImpl.getInstance();

    public FiltersMenuButton(TaskFilter taskFilter) {
        super(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/tasklist/ui/resources/filter.png")), (Icon)new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/tasklist/ui/resources/filter_rollover.png")), 4);
        this.updateState(taskFilter);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!FiltersMenuButton.this.isSelected()) {
                    FiltersMenuButton.this.taskManager.observe(FiltersMenuButton.this.taskManager.getScope(), TaskFilter.EMPTY);
                } else {
                    FiltersMenuButton.openFilterEditor();
                    FiltersMenuButton.this.updateState(FiltersMenuButton.this.taskManager.getFilter());
                }
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.taskManager.addPropertyChangeListener("filter", this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.taskManager.removePropertyChangeListener("filter", this);
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        FiltersMenuButton.fillMenu(jPopupMenu, null);
        return jPopupMenu;
    }

    static void fillMenu(JPopupMenu jPopupMenu, JMenu jMenu) {
        assert (null != jPopupMenu || null != jMenu);
        FilterRepository filterRepository = FilterRepository.getDefault();
        TaskManagerImpl taskManagerImpl = TaskManagerImpl.getInstance();
        TaskFilter taskFilter = taskManagerImpl.getFilter();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new CancelFilterAction());
        jRadioButtonMenuItem.setSelected(TaskFilter.EMPTY.equals(taskFilter));
        if (null == jPopupMenu) {
            jMenu.add(jRadioButtonMenuItem);
        } else {
            jPopupMenu.add(jRadioButtonMenuItem);
        }
        if (null == jPopupMenu) {
            jMenu.addSeparator();
        } else {
            jPopupMenu.addSeparator();
        }
        List<TaskFilter> list = filterRepository.getAllFilters();
        for (TaskFilter taskFilter2 : list) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(new SetFilterAction(taskFilter2));
            jRadioButtonMenuItem.setSelected(taskFilter.equals(taskFilter2));
            if (null == jPopupMenu) {
                jMenu.add(jRadioButtonMenuItem);
                continue;
            }
            jPopupMenu.add(jRadioButtonMenuItem);
        }
        if (list.size() > 0) {
            if (null == jPopupMenu) {
                jMenu.addSeparator();
            } else {
                jPopupMenu.addSeparator();
            }
        }
        if (null == jPopupMenu) {
            jMenu.add(new ManageFiltersAction());
        } else {
            jPopupMenu.add(new ManageFiltersAction());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateState(this.taskManager.getFilter());
    }

    private void updateState(TaskFilter taskFilter) {
        if (null == taskFilter || TaskFilter.EMPTY.equals(taskFilter)) {
            this.setSelected(false);
            this.setToolTipText(NbBundle.getMessage(FiltersMenuButton.class, (String)"HINT_SelectFilter"));
            FilterRepository.getDefault().setActive(null);
        } else {
            this.setSelected(true);
            this.setToolTipText(taskFilter.getName());
            FilterRepository.getDefault().setActive(taskFilter);
        }
    }

    private static void openFilterEditor() {
        FilterRepository filterRepository = FilterRepository.getDefault();
        FilterRepository filterRepository2 = (FilterRepository)filterRepository.clone();
        FilterEditor filterEditor = new FilterEditor(filterRepository2);
        if (filterEditor.showWindow()) {
            filterRepository.assign(filterRepository2);
            TaskManagerImpl taskManagerImpl = TaskManagerImpl.getInstance();
            taskManagerImpl.observe(taskManagerImpl.getScope(), filterRepository.getActive());
            try {
                filterRepository.save();
            }
            catch (IOException iOException) {
                Logger.getLogger(FiltersMenuButton.class.getName()).log(Level.INFO, iOException.getMessage(), iOException);
            }
        }
    }

    private static class ManageFiltersAction
    extends AbstractAction {
        public ManageFiltersAction() {
            super(NbBundle.getMessage(FiltersMenuButton.class, (String)"LBL_EditFilters"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiltersMenuButton.openFilterEditor();
        }
    }

    private static class SetFilterAction
    extends AbstractAction {
        private TaskFilter filter;

        public SetFilterAction(TaskFilter taskFilter) {
            super(taskFilter.getName());
            this.filter = taskFilter;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterRepository.getDefault().setActive(this.filter);
            try {
                FilterRepository.getDefault().save();
            }
            catch (IOException iOException) {
                Logger.getLogger(FiltersMenuButton.class.getName()).log(Level.INFO, iOException.getMessage(), iOException);
            }
            TaskManagerImpl taskManagerImpl = TaskManagerImpl.getInstance();
            taskManagerImpl.observe(taskManagerImpl.getScope(), this.filter);
        }
    }

    private static class CancelFilterAction
    extends AbstractAction {
        public CancelFilterAction() {
            super(NbBundle.getMessage(FiltersMenuButton.class, (String)"LBL_CancelFilter"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterRepository.getDefault().setActive(null);
            try {
                FilterRepository.getDefault().save();
            }
            catch (IOException iOException) {
                Logger.getLogger(FiltersMenuButton.class.getName()).log(Level.INFO, iOException.getMessage(), iOException);
            }
            TaskManagerImpl taskManagerImpl = TaskManagerImpl.getInstance();
            taskManagerImpl.observe(taskManagerImpl.getScope(), TaskFilter.EMPTY);
        }
    }
}

