/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataAccessor;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCCatalog;
import org.netbeans.modules.db.metadata.model.spi.MetadataFactory;
import org.netbeans.modules.db.metadata.model.spi.MetadataImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCMetadata
implements MetadataImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCMetadata.class.getName());
    private final Connection conn;
    private final String defaultSchemaName;
    private final DatabaseMetaData dmd;
    protected Catalog defaultCatalog;
    protected Map<String, Catalog> catalogs;

    public JDBCMetadata(Connection connection, String string) {
        LOGGER.log(Level.FINE, "Creating metadata for default schema ''{0}''", string);
        this.conn = connection;
        this.defaultSchemaName = string;
        try {
            this.dmd = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            try {
                LOGGER.log(Level.FINE, "Retrieved DMD for product ''{0}'' version ''{1}'', driver ''{2}'' version ''{3}''", new Object[]{this.dmd.getDatabaseProductName(), this.dmd.getDatabaseProductVersion(), this.dmd.getDriverName(), this.dmd.getDriverVersion()});
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.FINE, "Exception while logging metadata information", sQLException);
            }
        }
    }

    @Override
    public final Catalog getDefaultCatalog() {
        this.initCatalogs();
        return this.defaultCatalog;
    }

    @Override
    public final Collection<Catalog> getCatalogs() {
        return this.initCatalogs().values();
    }

    @Override
    public final Catalog getCatalog(String string) {
        return MetadataUtilities.find(string, this.initCatalogs());
    }

    @Override
    public void refresh() {
        LOGGER.fine("Refreshing metadata");
        this.defaultCatalog = null;
        this.catalogs = null;
    }

    public String toString() {
        return "JDBCMetadata";
    }

    protected JDBCCatalog createCatalog(String string, boolean bl, String string2) {
        return new JDBCCatalog(this, string, bl, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createCatalogs() {
        LinkedHashMap<String, Catalog> linkedHashMap = new LinkedHashMap<String, Catalog>();
        try {
            String string = this.conn.getCatalog();
            LOGGER.log(Level.FINE, "Default catalog is ''{0}''", string);
            ResultSet resultSet = this.dmd.getCatalogs();
            try {
                while (resultSet.next()) {
                    String string2 = resultSet.getString("TABLE_CAT");
                    LOGGER.log(Level.FINE, "Read catalog ''{0}''", string2);
                    if (MetadataUtilities.equals(string2, string)) {
                        this.defaultCatalog = MetadataFactory.createCatalog(this.createCatalog(string2, true, this.defaultSchemaName));
                        linkedHashMap.put(this.defaultCatalog.getName(), this.defaultCatalog);
                        LOGGER.log(Level.FINE, "Created default catalog {0}", this.defaultCatalog);
                        continue;
                    }
                    Catalog catalog = MetadataFactory.createCatalog(this.createCatalog(string2, false, null));
                    linkedHashMap.put(string2, catalog);
                    LOGGER.log(Level.FINE, "Created catalog {0}", catalog);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        if (this.defaultCatalog == null) {
            this.defaultCatalog = MetadataFactory.createCatalog(this.createCatalog(null, true, this.defaultSchemaName));
            linkedHashMap.put(this.defaultCatalog.getName(), this.defaultCatalog);
            LOGGER.log(Level.FINE, "Created fallback default catalog {0}", this.defaultCatalog);
        }
        this.catalogs = Collections.unmodifiableMap(linkedHashMap);
    }

    private Map<String, Catalog> initCatalogs() {
        if (this.catalogs != null) {
            return this.catalogs;
        }
        LOGGER.fine("Initializing catalogs");
        this.createCatalogs();
        return this.catalogs;
    }

    public final void refreshTable(String string) {
        if (this.defaultCatalog != null) {
            ((JDBCCatalog)MetadataAccessor.getDefault().getCatalogImpl(this.defaultCatalog)).refreshTable(string);
        }
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final DatabaseMetaData getDmd() {
        return this.dmd;
    }
}

