/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.FunctionCache;
import org.netbeans.modules.javascript.editing.JsIndex;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.lexer.JsCommentLexer;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.filesystems.FileObject;

public class JsTypeAnalyzer {
    private JsIndex index;
    private Map<String, String> types;
    private final int astOffset;
    private final int lexOffset;
    private final Node root;
    private Node target;
    private final BaseDocument doc;
    private final FileObject fileObject;
    private final CompilationInfo info;
    private long startTime;
    private static Map<String, String> BROWSER_BUILTINS = new HashMap<String, String>();

    public JsTypeAnalyzer(CompilationInfo compilationInfo, JsIndex jsIndex, Node node, Node node2, int n, int n2, BaseDocument baseDocument, FileObject fileObject) {
        this.info = compilationInfo;
        this.index = jsIndex;
        this.root = node;
        this.target = node2;
        this.astOffset = n;
        this.lexOffset = n2;
        this.doc = baseDocument;
        this.fileObject = fileObject;
    }

    private boolean dependsOnLocals() {
        int n;
        Node node;
        Node node2 = null;
        for (node = this.target; node != null && (n = node.getType()) != 130 && n != 129 && n != 37 && n != 105; node = node.getParentNode()) {
            node2 = node;
        }
        if (node == null && (node = node2) == null) {
            return false;
        }
        return this.hasLocalRefs(node, node.getParentNode());
    }

    private boolean hasLocalRefs(Node node, Node node2) {
        if (node.getType() == 38) {
            if (node2 == null) {
                return true;
            }
            if (node2.getType() != 33 || Character.isLowerCase(node.getString().charAt(0))) {
                return true;
            }
        }
        if (this.root.hasChildren()) {
            for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                boolean bl = this.hasLocalRefs(node3, node);
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private String analyze(Node node) {
        Object object;
        if (node == this.target) {
            this.target = null;
        }
        if (this.target == null && node.getSourceStart() > this.astOffset) {
            return null;
        }
        switch (node.getType()) {
            case 118: {
                Node node2;
                object = AstUtilities.getFirstChild(node);
                if (object == null || (node2 = AstUtilities.getFirstChild(object)) == null) break;
                String string = object.getString();
                String string2 = this.expressionType(node2);
                this.setType(string2, string);
                break;
            }
            case 8: {
                object = AstUtilities.getFirstChild(node).getString();
                Node node2 = AstUtilities.getSecondChild(node);
                if (node2 == null) break;
                String string = this.expressionType(node2);
                this.setType(string, (String)object);
                break;
            }
        }
        for (object = node.getFirstChild(); object != null; object = object.getNext()) {
            this.analyze((Node)object);
        }
        return null;
    }

    private String expressionType(Node node) {
        switch (node.getType()) {
            case 39: {
                return "Number";
            }
            case 40: {
                if (node.getParentNode() == null || node.getParentNode().getType() != 33 || node == node.getParentNode().getFirstChild()) {
                    return "String";
                }
                return null;
            }
            case 35: {
                String string = this.expressionType(node.getFirstChild());
                if (string != null) {
                    if (string.startsWith("Array<")) {
                        int n = string.lastIndexOf(62);
                        if (n != -1) {
                            return string.substring("Array<".length(), n);
                        }
                    } else if ("HTMLCollection".equals(string)) {
                        return "Node";
                    }
                }
                return null;
            }
            case 47: {
                return "RegExp";
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 43: 
            case 44: {
                return "Boolean";
            }
            case 63: {
                return "Array";
            }
            case 105: {
                return "Function";
            }
            case 30: {
                Node node2 = AstUtilities.getFirstChild(node);
                if (node2.getType() == 38) {
                    return node2.getString();
                }
                return this.expressionType(node2);
            }
            case 37: {
                Node node3 = node.getFirstChild();
                if (node3.getType() == 38) {
                    String string = node3.getString();
                    if ("$".equals(string)) {
                        JsParseResult jsParseResult = AstUtilities.getParseResult(this.info);
                        boolean bl = false;
                        for (String string2 : jsParseResult.getStructure().getImports()) {
                            if (string2.indexOf("jquery") == -1) continue;
                            bl = true;
                        }
                        if (!bl && this.index != null) {
                            boolean bl2 = bl = this.index.getType("jQuery") != null;
                        }
                        if (bl) {
                            return "jQuery";
                        }
                        return "Element";
                    }
                    return FunctionCache.INSTANCE.getType(string, this.index);
                }
                if (node3.getType() == 33) {
                    Node node4;
                    Node node5 = node3.getFirstChild();
                    if (node5.getType() == 37) {
                        Node node6;
                        String string = this.expressionType(node5);
                        if (string == null || (node6 = node5.getNext()).getType() != 40) break;
                        String string3 = node6.getString();
                        String string4 = string + "." + string3;
                        return FunctionCache.INSTANCE.getType(string4, this.index);
                    }
                    if (node5.getType() == 38) {
                        Node node7;
                        String string = node5.getString();
                        String string5 = this.getTypeInternal(string);
                        if (string5 == null && (string5 = FunctionCache.INSTANCE.getType(string, this.index)) == null) {
                            string5 = string;
                        }
                        if (string5 == null || (node7 = node5.getNext()).getType() != 40) break;
                        String string6 = node7.getString();
                        String string7 = string5 + "." + string6;
                        return FunctionCache.INSTANCE.getType(string7, this.index);
                    }
                    String string = this.expressionType(node5);
                    if (string == null || (node4 = node5.getNext()).getType() != 40) break;
                    String string8 = node4.getString();
                    String string9 = string + "." + string8;
                    return FunctionCache.INSTANCE.getType(string9, this.index);
                }
                if (System.currentTimeMillis() > this.startTime + 2000L) {
                    return null;
                }
                String string = AstUtilities.getCallName(node, true);
                if (string == null || string.length() <= 0) break;
                return FunctionCache.INSTANCE.getType(string, this.index);
            }
            case 38: {
                return this.getTypeInternal(node.getString());
            }
            case 33: {
                Node node8 = AstUtilities.getFirstChild(node);
                Node node9 = AstUtilities.getSecondChild(node);
                if (node9.getType() == 164) {
                    String string;
                    String string10 = this.expressionType(node8);
                    if (string10 != null && !Character.isUpperCase(string10.charAt(0)) && (string = FunctionCache.INSTANCE.getType(string10, this.index)) != null) {
                        string10 = string;
                    }
                    return string10;
                }
                String string = this.expressionType(node8);
                if (string == null) {
                    if (!(node8 instanceof Node.StringNode)) {
                        return null;
                    }
                    string = node8.getString();
                }
                String string11 = node9.getString();
                assert (node9.getType() == 40);
                String string12 = string + "." + string11;
                String string13 = FunctionCache.INSTANCE.getType(string12, this.index);
                if (string13 != null) {
                    return string13;
                }
                return string12;
            }
        }
        return null;
    }

    public String getType(Node node) {
        String string;
        if (this.dependsOnLocals()) {
            this.init();
        }
        if ((string = this.expressionType(node)) != null && string.startsWith("Array<")) {
            return "Array";
        }
        return string;
    }

    public static String getCallFqn(CompilationInfo compilationInfo, Node node, boolean bl) {
        Node node2;
        JsIndex jsIndex = JsIndex.get(compilationInfo.getIndex("text/javascript"));
        for (node2 = node.getParentNode(); node2 != null && node2.getType() != 105; node2 = node2.getParentNode()) {
        }
        if (node2 == null) {
            node2 = AstUtilities.getRoot(compilationInfo);
        }
        JsTypeAnalyzer jsTypeAnalyzer = new JsTypeAnalyzer(compilationInfo, jsIndex, node2, node, 0, 0, LexUtilities.getDocument(compilationInfo, false), compilationInfo.getFileObject());
        if (bl && jsTypeAnalyzer.dependsOnLocals()) {
            jsTypeAnalyzer.init();
        }
        String string = jsTypeAnalyzer.getCallExpressionType(node);
        return string;
    }

    private String getCallExpressionType(Node node) {
        switch (node.getType()) {
            case 30: 
            case 37: {
                Node node2 = node.getFirstChild();
                if (node2.getType() == 38) {
                    String string = node2.getString();
                    return string;
                }
                if (node2.getType() == 33) {
                    Node node3;
                    Node node4 = node2.getFirstChild();
                    if (node4.getType() == 37) {
                        Node node5;
                        String string = this.expressionType(node4);
                        if (string == null || (node5 = node4.getNext()).getType() != 40) break;
                        String string2 = node5.getString();
                        String string3 = string + "." + string2;
                        return string3;
                    }
                    if (node4.getType() == 38) {
                        Node node6;
                        String string = node4.getString();
                        String string4 = this.getTypeInternal(string);
                        if (string4 == null && (string4 = FunctionCache.INSTANCE.getType(string, this.index)) == null) {
                            string4 = string;
                        }
                        if (string4 == null || (node6 = node4.getNext()).getType() != 40) break;
                        String string5 = node6.getString();
                        String string6 = string4 + "." + string5;
                        return string6;
                    }
                    String string = this.expressionType(node4);
                    if (string == null || (node3 = node4.getNext()).getType() != 40) break;
                    String string7 = node3.getString();
                    String string8 = string + "." + string7;
                    return string8;
                }
                if (System.currentTimeMillis() > this.startTime + 2000L) {
                    return null;
                }
                String string = AstUtilities.getCallName(node, true);
                if (string == null || string.length() <= 0) break;
                return string;
            }
        }
        return null;
    }

    private void init() {
        if (this.types == null) {
            this.startTime = System.currentTimeMillis();
            this.types = new HashMap<String, String>();
            if (this.doc != null) {
                this.initTypeAssertions();
            }
            this.analyze(this.root);
        }
    }

    private String getTypeInternal(String string) {
        String string2 = null;
        if (this.types != null) {
            string2 = this.types.get(string);
        }
        if (string2 == null && (string2 = BROWSER_BUILTINS.get(string)) == null && this.index != null) {
            string2 = FunctionCache.INSTANCE.getType(string, this.index);
        }
        return string2;
    }

    public String getType(String string) {
        this.init();
        String string2 = this.getTypeInternal(string);
        if (string2 != null && string2.startsWith("Array<")) {
            return "Array";
        }
        return string2;
    }

    private void setType(String string, String string2) {
        if (string != null) {
            this.types.put(string2, string);
        } else {
            this.types.remove(string2);
        }
    }

    private void initTypeAssertions() {
        TokenSequence<? extends JsCommentTokenId> tokenSequence;
        if (this.root.getType() == 105 && (tokenSequence = AstUtilities.getCommentFor(this.info, this.doc, (Node)((FunctionNode)this.root))) != null) {
            Map<String, String> map = JsCommentLexer.findFunctionTypes(tokenSequence);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.types.put(entry.getKey(), entry.getValue());
            }
        }
    }

    static {
        BROWSER_BUILTINS.put("java", "Java");
        BROWSER_BUILTINS.put("netscape", "Netscape");
        BROWSER_BUILTINS.put("sun", "Sun");
        BROWSER_BUILTINS.put("cssRule", "CssRule");
        BROWSER_BUILTINS.put("document", "HTMLDocument");
        BROWSER_BUILTINS.put("element", "HTMLElement");
        BROWSER_BUILTINS.put("event", "Event");
        BROWSER_BUILTINS.put("navigator", "Navigator");
        BROWSER_BUILTINS.put("style", "Style");
        BROWSER_BUILTINS.put("stylesheet", "Stylesheet");
        BROWSER_BUILTINS.put("table", "Table");
        BROWSER_BUILTINS.put("treeWalker", "TreeWalker");
        BROWSER_BUILTINS.put("window", "Window");
    }
}

