/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.InstantRenamer;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.JsCommentLexer;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsRenameHandler
implements InstantRenamer {
    public boolean isRenameAllowed(CompilationInfo compilationInfo, int n, String[] stringArray) {
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            if (stringArray != null) {
                stringArray[0] = NbBundle.getMessage(JsRenameHandler.class, (String)"NoRenameWithErrors");
            }
            return false;
        }
        BaseDocument baseDocument = LexUtilities.getDocument(compilationInfo, true);
        if (baseDocument == null) {
            return false;
        }
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        if (tokenSequence != null && tokenSequence.token().id() == JsTokenId.BLOCK_COMMENT) {
            TokenSequence tokenSequence2 = tokenSequence.embedded(JsCommentTokenId.language());
            boolean bl = false;
            if (tokenSequence2 != null) {
                boolean bl2 = bl = this.getParameterName((TokenSequence<? extends JsCommentTokenId>)tokenSequence2, n) != null;
            }
            if (!bl && stringArray != null) {
                stringArray[0] = NbBundle.getMessage(JsRenameHandler.class, (String)"RenameOnlyParams");
            }
            return bl;
        }
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n2 == -1) {
            return false;
        }
        AstPath astPath = new AstPath(node, n2);
        Node node2 = astPath.leaf();
        switch (node2.getType()) {
            case 38: 
            case 48: 
            case 155: 
            case 156: {
                return true;
            }
            case 157: {
                return AstUtilities.isLabelledFunction(node2);
            }
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(CompilationInfo compilationInfo, int n) {
        Object object;
        Object object2;
        JsTokenId jsTokenId;
        Object object3;
        int n2;
        Object object4;
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        if (jsParseResult == null) {
            return Collections.emptySet();
        }
        Node node = jsParseResult.getRootNode();
        BaseDocument baseDocument = LexUtilities.getDocument(compilationInfo, true);
        if (node == null || baseDocument == null) {
            return Collections.emptySet();
        }
        Object object5 = null;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        if (tokenSequence != null && tokenSequence.token().id() == JsTokenId.BLOCK_COMMENT) {
            object4 = tokenSequence.embedded(JsCommentTokenId.language());
            if (object4 != null) {
                object5 = this.getParameterName((TokenSequence<? extends JsCommentTokenId>)object4, n);
            } else {
                return Collections.emptySet();
            }
        }
        if ((object4 = object5) != null) {
            assert (tokenSequence != null);
            n2 = 0;
            boolean bl = false;
            while (tokenSequence.moveNext()) {
                object3 = tokenSequence.token();
                jsTokenId = (JsTokenId)object3.id();
                if (jsTokenId == JsTokenId.FUNCTION) {
                    n2 = 1;
                    continue;
                }
                if (jsTokenId == JsTokenId.LPAREN) {
                    assert (n2 != 0);
                    bl = true;
                    n = tokenSequence.offset() + 1;
                    break;
                }
                if (jsTokenId != JsTokenId.BLOCK_COMMENT) continue;
                break;
            }
            if (!bl) {
                return Collections.emptySet();
            }
        }
        if ((n2 = AstUtilities.getAstOffset(compilationInfo, n)) == -1) {
            return Collections.emptySet();
        }
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        object3 = new AstPath(node, n2);
        jsTokenId = ((AstPath)object3).leaf();
        if (object4 == null) {
            if (!(jsTokenId instanceof Node.StringNode)) {
                return Collections.emptySet();
            }
            object4 = jsTokenId.getString();
        }
        Map<String, List<Node>> map = variableVisitor.getLocalVars((Node)jsTokenId);
        List<Node> list = map.get(object4);
        Object object6 = new HashSet();
        Object object7 = null;
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                object6.add((OffsetRange)AstUtilities.getNameRange((Node)object));
                if (object.getType() != 155) continue;
                object7 = object;
            }
        }
        if (object6.size() > 0 && jsParseResult.getTranslatedSource() != null) {
            object2 = new HashSet(2 * object6.size());
            object = object6.iterator();
            while (object.hasNext()) {
                OffsetRange offsetRange = (OffsetRange)object.next();
                OffsetRange offsetRange2 = LexUtilities.getLexerOffsets(compilationInfo, offsetRange);
                if (offsetRange2 == OffsetRange.NONE) continue;
                object2.add(offsetRange2);
            }
            object6 = object2;
        }
        if (object7 != null && (object2 = this.findParameterDoc(compilationInfo, (Node)object7, (String)object4)) != OffsetRange.NONE) {
            object6.add((OffsetRange)object2);
        }
        return object6;
    }

    @NonNull
    private OffsetRange findParameterDoc(CompilationInfo compilationInfo, Node node, String string) {
        TokenSequence<? extends JsCommentTokenId> tokenSequence;
        Node node2;
        for (node2 = node.getParentNode(); node2 != null && node2.getType() != 105; node2 = node2.getParentNode()) {
        }
        if (node2 == null) {
            return OffsetRange.NONE;
        }
        BaseDocument baseDocument = LexUtilities.getDocument(compilationInfo, true);
        if (baseDocument != null && (tokenSequence = AstUtilities.getCommentFor(compilationInfo, baseDocument, node2)) != null) {
            tokenSequence.moveStart();
            while (tokenSequence.moveNext()) {
                String string2;
                CharSequence charSequence;
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                if (tokenId != JsCommentTokenId.COMMENT_TAG || !TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)(charSequence = token.text()))) continue;
                int n = tokenSequence.index();
                String string3 = JsCommentLexer.nextType(tokenSequence);
                if (string3 == null) {
                    tokenSequence.moveIndex(n);
                    tokenSequence.moveNext();
                }
                if ((string2 = JsCommentLexer.nextIdent(tokenSequence)) != null) {
                    if (!string.equals(string2)) continue;
                    int n2 = tokenSequence.offset();
                    return new OffsetRange(n2, n2 + string.length());
                }
                tokenSequence.moveIndex(n);
                tokenSequence.moveNext();
            }
        }
        return OffsetRange.NONE;
    }

    @CheckForNull
    private String getParameterName(TokenSequence<? extends JsCommentTokenId> tokenSequence, int n) {
        assert (tokenSequence != null);
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() || tokenSequence.token().id() != JsCommentTokenId.IDENT) {
            return null;
        }
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            String string;
            CharSequence charSequence;
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (tokenId != JsCommentTokenId.COMMENT_TAG || !TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)(charSequence = token.text()))) continue;
            int n2 = tokenSequence.index() + 1;
            String string2 = JsCommentLexer.nextType(tokenSequence);
            if (string2 == null) {
                tokenSequence.moveIndex(n2);
                tokenSequence.moveNext();
            }
            if ((string = JsCommentLexer.nextIdent(tokenSequence)) != null) {
                int n3 = tokenSequence.offset();
                if (n < n3 || n > n3 + string.length()) continue;
                return string;
            }
            tokenSequence.moveIndex(n2);
            tokenSequence.moveNext();
        }
        return null;
    }
}

