/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SourceModel;
import org.netbeans.modules.gsf.api.SourceModelFactory;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.FunctionAstElement;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstUtilities {
    public static final String DOT_PROTOTYPE = ".prototype";

    private AstUtilities() {
    }

    public static int getAstOffset(CompilationInfo compilationInfo, int n) {
        TranslatedSource translatedSource;
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/javascript", 0);
        if (parserResult == null) {
            parserResult = compilationInfo.getEmbeddedResult("text/x-json", 0);
        }
        if (parserResult != null && (translatedSource = parserResult.getTranslatedSource()) != null) {
            return translatedSource.getAstOffset(n);
        }
        return n;
    }

    public static OffsetRange getAstOffsets(CompilationInfo compilationInfo, OffsetRange offsetRange) {
        TranslatedSource translatedSource;
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/javascript", 0);
        if (parserResult == null) {
            parserResult = compilationInfo.getEmbeddedResult("text/x-json", 0);
        }
        if (parserResult != null && (translatedSource = parserResult.getTranslatedSource()) != null) {
            int n = offsetRange.getStart();
            int n2 = translatedSource.getAstOffset(n);
            if (n2 == n) {
                return offsetRange;
            }
            if (n2 == -1) {
                return OffsetRange.NONE;
            }
            return new OffsetRange(n2, n2 + offsetRange.getLength());
        }
        return offsetRange;
    }

    public static boolean isGlobalVar(CompilationInfo compilationInfo, Node node) {
        if (!AstUtilities.isNameNode(node)) {
            return false;
        }
        String string = node.getString();
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        if (jsParseResult == null) {
            return false;
        }
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        Map<String, List<Node>> map = variableVisitor.getLocalVars(node);
        List<Node> list = map.get(string);
        if (list == null) {
            return true;
        }
        return list.contains(node);
    }

    public static TokenSequence<? extends JsCommentTokenId> getCommentFor(CompilationInfo compilationInfo, BaseDocument baseDocument, Node node) {
        int n = node.getSourceStart();
        int n2 = LexUtilities.getLexerOffset(compilationInfo, n);
        if (n2 == -1 || n2 > baseDocument.getLength()) {
            return null;
        }
        try {
            int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2);
            if (n3 > 0) {
                n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)(n3 - 1));
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return LexUtilities.getCommentFor(baseDocument, n2);
    }

    public static Node getFirstChild(Node node) {
        return node.getFirstChild();
    }

    public static Node getSecondChild(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        return node2.getNext();
    }

    public static Node getRoot(CompilationInfo compilationInfo) {
        Node node = AstUtilities.getRoot(compilationInfo, "text/javascript");
        if (node == null && JsUtils.isJsonFile(compilationInfo.getFileObject())) {
            node = AstUtilities.getRoot(compilationInfo, "text/x-json");
        }
        return node;
    }

    public static JsParseResult getParseResult(CompilationInfo compilationInfo) {
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/javascript", 0);
        if (parserResult == null && JsUtils.isJsonFile(compilationInfo.getFileObject())) {
            parserResult = compilationInfo.getEmbeddedResult("text/x-json", 0);
        }
        if (parserResult == null) {
            return null;
        }
        return (JsParseResult)parserResult;
    }

    public static Node getRoot(CompilationInfo compilationInfo, String string) {
        ParserResult parserResult = compilationInfo.getEmbeddedResult(string, 0);
        if (parserResult == null) {
            return null;
        }
        return AstUtilities.getRoot(parserResult);
    }

    public static Node getRoot(ParserResult parserResult) {
        assert (parserResult instanceof JsParseResult);
        JsParseResult jsParseResult = (JsParseResult)parserResult;
        return jsParseResult.getRootNode();
    }

    public static Node getForeignNode(IndexedElement indexedElement, CompilationInfo[] compilationInfoArray) {
        boolean bl;
        JsParseResult jsParseResult;
        ParserFile parserFile = indexedElement.getFile();
        if (parserFile == null) {
            return null;
        }
        FileObject fileObject = parserFile.getFileObject();
        if (fileObject == null) {
            return null;
        }
        SourceModel sourceModel = SourceModelFactory.getInstance().getModel(fileObject);
        if (sourceModel == null) {
            return null;
        }
        final CompilationInfo[] compilationInfoArray2 = new CompilationInfo[1];
        try {
            sourceModel.runUserActionTask((CancellableTask)new CancellableTask<CompilationInfo>(){

                public void cancel() {
                }

                public void run(CompilationInfo compilationInfo) throws Exception {
                    compilationInfoArray2[0] = compilationInfo;
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
        CompilationInfo compilationInfo = compilationInfoArray2[0];
        if (compilationInfoArray != null) {
            compilationInfoArray[0] = compilationInfo;
        }
        if ((jsParseResult = AstUtilities.getParseResult(compilationInfo)) == null) {
            return null;
        }
        Node node = AstUtilities.getRoot(jsParseResult);
        if (node == null) {
            return null;
        }
        String string = indexedElement.getSignature();
        if (string == null) {
            return null;
        }
        JsParseResult jsParseResult2 = jsParseResult;
        boolean bl2 = bl = indexedElement.getKind() == ElementKind.CONSTRUCTOR || indexedElement.getKind() == ElementKind.METHOD;
        if (bl) {
            for (AstElement astElement : jsParseResult2.getStructure().getElements()) {
                FunctionAstElement functionAstElement;
                if (!(astElement instanceof FunctionAstElement) || !string.equals((functionAstElement = (FunctionAstElement)astElement).getSignature())) continue;
                return functionAstElement.getNode();
            }
        }
        for (AstElement astElement : jsParseResult2.getStructure().getElements()) {
            if (!string.equals(astElement.getSignature())) continue;
            return astElement.getNode();
        }
        return null;
    }

    public static OffsetRange getRange(CompilationInfo compilationInfo, Node node) {
        return new OffsetRange(node.getSourceStart(), node.getSourceEnd());
    }

    public static OffsetRange getNameRange(Node node) {
        int n = node.getType();
        switch (n) {
            case 105: {
                if (node.hasChildren()) {
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                        if (node2.getType() != 156) continue;
                        return AstUtilities.getNameRange(node2);
                    }
                }
                return AstUtilities.getRange(node);
            }
            case 38: 
            case 48: 
            case 155: 
            case 156: 
            case 157: {
                int n2 = node.getSourceStart();
                String string = node.getString();
                return new OffsetRange(n2, n2 + string.length());
            }
            case 37: {
                Node node3 = AstUtilities.findCallNameNode(node);
                if (node3 == null) break;
                return AstUtilities.getNameRange(node3);
            }
        }
        return AstUtilities.getRange(node);
    }

    public static int findArgumentIndex(Node node, int n, AstPath astPath) {
        assert (node.getType() == 37 || node.getType() == 30);
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return 0;
        }
        if ((node2 = node2.getNext()) == null || n < node2.getSourceStart()) {
            return -1;
        }
        int n2 = 0;
        while (node2 != null) {
            if (node2.getSourceEnd() >= n) {
                return n2;
            }
            if ((node2 = node2.getNext()) == null) continue;
            ++n2;
        }
        return n2;
    }

    private static Node findCallNameNode(Node node) {
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            if (node2 != null) {
                if (node2.getType() == 38) {
                    return node2;
                }
                if (node2.getType() == 33) {
                    Node node3 = node2.getFirstChild();
                    assert (node3.getNext().getNext() == null) : node3.getNext().getNext();
                    return node3.getNext();
                }
            } else assert (false) : "Unexpected call firstchild - " + node2;
        }
        return null;
    }

    @NonNull
    public static String getCallName(Node node, boolean bl) {
        Node node2;
        assert (node.getType() == 37 || node.getType() == 30);
        if (!bl) {
            Node node3 = AstUtilities.findCallNameNode(node);
            if (node3 != null) {
                return node3.getString();
            }
        } else if (node.hasChildren() && (node2 = node.getFirstChild()) != null) {
            if (node2.getType() == 35 && (node2 = node2.getNext()) == null) {
                return "";
            }
            if (node2.getType() == 38) {
                return node2.getString();
            }
            if (node2.getType() == 33) {
                Node node4 = node2.getFirstChild();
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder();
                    AstUtilities.addName(stringBuilder, node2);
                    return stringBuilder.toString();
                }
                return node4.getNext().getString();
            }
        }
        return "";
    }

    public static OffsetRange getRange(Node node) {
        assert (node.getSourceEnd() >= node.getSourceStart()) : "Invalid offsets for " + node;
        return new OffsetRange(node.getSourceStart(), node.getSourceEnd());
    }

    public static FunctionNode findMethodAtOffset(Node node, int n) {
        AstPath astPath = new AstPath(node, n);
        ListIterator<Node> listIterator = astPath.leafToRoot();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (node2.getType() != 105) continue;
            return (FunctionNode)node2;
        }
        return null;
    }

    public static Node findLocalScope(Node node, AstPath astPath) {
        ListIterator<Node> listIterator = astPath.leafToRoot();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (node2.getType() != 105) continue;
            return node2;
        }
        return astPath.root();
    }

    public static boolean isNameNode(Node node) {
        int n = node.getType();
        return n == 38 || n == 48 || n == 155 || n == 156 || n == 157;
    }

    public static void addNodesByType(Node node, int[] nArray, List<Node> list) {
        for (int i = 0; i < nArray.length; ++i) {
            if (node.getType() != nArray[i]) continue;
            list.add(node);
            break;
        }
        if (node.hasChildren()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                AstUtilities.addNodesByType(node2, nArray, list);
            }
        }
    }

    public static boolean isLabelledFunction(Node node) {
        assert (node.getType() == 157);
        Node.LabelledNode labelledNode = (Node.LabelledNode)node;
        Node node2 = labelledNode.getLabelledNode();
        return node2.getType() == 105;
    }

    public static FunctionNode getLabelledFunction(Node node) {
        assert (node.getType() == 157);
        Node.LabelledNode labelledNode = (Node.LabelledNode)node;
        Node node2 = labelledNode.getLabelledNode();
        if (node2.getType() == 105) {
            return (FunctionNode)node2;
        }
        return null;
    }

    public static Node getLabelledNode(Node node) {
        assert (node.getType() == 157);
        Node.LabelledNode labelledNode = (Node.LabelledNode)node;
        Node node2 = labelledNode.getLabelledNode();
        return node2;
    }

    public static String getFunctionFqn(Node node, boolean[] blArray) {
        if (blArray != null) {
            blArray[0] = true;
        }
        FunctionNode functionNode = (FunctionNode)node;
        Object object = node.getParentNode();
        int n = object != null ? object.getType() : 0;
        String string = functionNode.getFunctionName();
        if (string == null || string.length() == 0) {
            String string2;
            int n2;
            String string3 = null;
            boolean bl = false;
            if (n == 37 && functionNode.getNext() == null && object.getParentNode() != null && object.getFirstChild() == functionNode && ((n2 = (string2 = object.getParentNode()).getType()) == 34 || n2 == 8)) {
                object = string2;
                n = object.getType();
            }
            if (n == 38) {
                string2 = object.getString();
                if (Character.isUpperCase(string2.charAt(0))) {
                    string3 = string2;
                }
            } else if (n != 64 && (n == 34 || n == 8)) {
                StringBuilder stringBuilder;
                string2 = object.getFirstChild();
                if (string2.getType() == 42) {
                    bl = true;
                    Node node2 = object.getFirstChild().getNext();
                    if (node2.getType() == 40) {
                        String string4 = node2.getString();
                        for (Object object2 = object; object2 != null; object2 = object2.getParentNode()) {
                            String string5;
                            if (object2.getType() != 105 || (string5 = AstUtilities.getFunctionFqn(object2, null)) == null) continue;
                            int n3 = string5.lastIndexOf(46);
                            if (n3 != -1 && Character.isUpperCase(string5.charAt(n3 + 1))) {
                                return string5 + '.' + string4;
                            }
                            if (!Character.isUpperCase(string5.charAt(0))) continue;
                            return string5 + '.' + string4;
                        }
                    }
                } else if (string2.getType() == 33 && string2.hasChildren() && string2.getFirstChild().getType() == 42) {
                    bl = true;
                    Node node3 = object.getFirstChild().getNext();
                    if (node3.getType() == 40) {
                        String string6 = AstUtilities.getJoinedName(object);
                        for (Object object3 = object; object3 != null; object3 = object3.getParentNode()) {
                            String string7;
                            if (object3.getType() != 105 || (string7 = AstUtilities.getFunctionFqn(object3, null)) == null) continue;
                            int n4 = string7.lastIndexOf(46);
                            if (n4 != -1 && Character.isUpperCase(string7.charAt(n4 + 1))) {
                                return string7 + '.' + string6;
                            }
                            if (!Character.isUpperCase(string7.charAt(0))) continue;
                            return string7 + '.' + string6;
                        }
                    }
                }
                if (AstUtilities.addName(stringBuilder = new StringBuilder(), object)) {
                    string3 = stringBuilder.toString();
                }
            }
            if (string3 != null) {
                string2 = AstUtilities.getSurroundingWith(object);
                if (string2 != null) {
                    string3 = string2 + "." + string3;
                }
                int n5 = n2 = bl || string3.indexOf(46) == -1 ? 1 : 0;
                if (string3.indexOf(DOT_PROTOTYPE) != -1) {
                    string3 = string3.replace(DOT_PROTOTYPE, "");
                    n2 = 1;
                }
                if (blArray != null) {
                    blArray[0] = n2;
                }
            }
            return string3;
        }
        return string;
    }

    @NonNull
    public static String[] getObjectLitFqn(Node node) {
        String string;
        Object object;
        int n;
        assert (node.getType() == 64);
        Node node2 = node.getParentNode();
        String string2 = null;
        String string3 = null;
        int n2 = n = node2 != null ? node2.getType() : 0;
        if (n == 4) {
            for (object = node2.getParentNode(); object != null; object = object.getParentNode()) {
                if (object.getType() == 105) {
                    string = AstUtilities.getFunctionFqn((Node)object, null);
                    if (string == null) break;
                    if (!Character.isUpperCase(string.charAt(0))) {
                        return new String[]{null, null};
                    }
                    return new String[]{string, null};
                }
                if (object.getType() != 157) continue;
                return AstUtilities.getObjectLitFqn((Node)object);
            }
        }
        if (n == 38) {
            string2 = node2.getString();
        } else if (n == 34 || n == 8) {
            object = new StringBuilder();
            if (AstUtilities.addName((StringBuilder)object, node2)) {
                string2 = object.toString();
            }
        } else if (n == 37 && node2.getParentNode() != null && (node2.getParentNode().getType() == 34 || node2.getParentNode().getType() == 38)) {
            object = node2.getFirstChild();
            if (object != null && object.getType() == 33) {
                Node node3;
                string = object.getFirstChild();
                Node node4 = node3 = string != null ? string.getNext() : null;
                if (string != null && node3 != null) {
                    Node node5;
                    String string4;
                    if (string.getType() == 38 && "Object".equals(string.getString()) && node3.getType() == 40 && "extend".equals(node3.getString())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (AstUtilities.addName(stringBuilder, node2.getParentNode())) {
                            StringBuilder stringBuilder2;
                            string2 = stringBuilder.toString();
                            Node node6 = node2.getFirstChild().getNext();
                            if (node6 != null && node6.getType() == 30 && node6.getFirstChild() != null && AstUtilities.addName(stringBuilder2 = new StringBuilder(), node6.getFirstChild()) && (string3 = stringBuilder2.toString()).length() == 0) {
                                string3 = null;
                            }
                        }
                    } else if (string.getType() == 38 && "Class".equals(string.getString()) && node3.getType() == 40 && "create".equals(node3.getString())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (AstUtilities.addName(stringBuilder, node2.getParentNode())) {
                            StringBuilder stringBuilder3;
                            string2 = stringBuilder.toString();
                            Node node7 = object.getNext();
                            if ((node7.getType() == 38 || node7.getType() == 33) && AstUtilities.addName(stringBuilder3 = new StringBuilder(), node7) && (string3 = stringBuilder3.toString()).length() == 0) {
                                string3 = null;
                            }
                        }
                    } else if (string.getType() == 38 && "Ext".equals(string.getString()) && node3.getType() == 40 && "extend".equals(node3.getString())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (AstUtilities.addName(stringBuilder, node2.getParentNode())) {
                            StringBuilder stringBuilder4;
                            string2 = stringBuilder.toString();
                            Node node8 = object.getNext();
                            if ((node8.getType() == 38 || node8.getType() == 33) && AstUtilities.addName(stringBuilder4 = new StringBuilder(), node8) && (string3 = stringBuilder4.toString()).length() == 0) {
                                string3 = null;
                            }
                        }
                    } else if (n == 37 && node2.getParentNode() != null && node2.getFirstChild().getType() == 33 && node2.getFirstChild().getNext() != null && node2.getFirstChild().getNext().getType() == 33 && node2.getFirstChild().getNext().getNext() == node && (string4 = AstUtilities.getJoinedName(node5 = node2.getFirstChild())).endsWith(".extend") && string4.indexOf("dojo") != -1) {
                        string2 = AstUtilities.getJoinedName(node5.getNext());
                    }
                }
            }
        } else if (n == 37 && (object = node2.getFirstChild()) != null && object.getType() == 33) {
            Node node9;
            string = object.getFirstChild();
            Node node10 = node9 = string != null ? string.getNext() : null;
            if (string != null && node9 != null) {
                Node node11;
                String string5;
                if (string.getType() == 38 && "Ext".equals(string.getString()) && node9.getType() == 40 && "extend".equals(node9.getString())) {
                    StringBuilder stringBuilder;
                    Node node12;
                    Node node13 = object.getNext();
                    if (!(node13 == null || node13.getType() != 38 && node13.getType() != 33 || (node12 = node13.getNext()) == null || node12.getType() != 38 && node12.getType() != 33 || !AstUtilities.addName(stringBuilder = new StringBuilder(), node13))) {
                        string2 = stringBuilder.toString();
                        StringBuilder stringBuilder5 = new StringBuilder();
                        if (AstUtilities.addName(stringBuilder5, node12) && (string3 = stringBuilder5.toString()).length() == 0) {
                            string3 = null;
                        }
                    }
                } else if (node9.getType() == 40 && "declare".equals(node9.getString()) && (string.getType() == 38 && "dojo".equals(string.getString()) || string.getType() == 33 && AstUtilities.getJoinedName((Node)string).endsWith("dojo"))) {
                    Node node14 = object.getNext();
                    if (node14 != null) {
                        string2 = AstUtilities.getJoinedName(node14);
                        Node node15 = node14.getNext();
                        if (node15 != null && (string3 = AstUtilities.getJoinedName(node15)).length() == 0) {
                            string3 = null;
                        }
                    }
                } else if (node2.getParentNode() != null && node2.getFirstChild().getType() == 33 && node2.getFirstChild().getNext() != null && node2.getFirstChild().getNext().getType() == 33 && node2.getFirstChild().getNext().getNext() == node && (string5 = AstUtilities.getJoinedName(node11 = node2.getFirstChild())).endsWith(".extend") && string5.indexOf("dojo") != -1) {
                    string2 = AstUtilities.getJoinedName(node11.getNext());
                }
            }
        }
        object = new String[]{string2, string3};
        return object;
    }

    public static String getJoinedName(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        AstUtilities.addName(stringBuilder, node);
        return stringBuilder.toString();
    }

    public static boolean addName(StringBuilder stringBuilder, Node node) {
        switch (node.getType()) {
            case 38: 
            case 40: 
            case 48: {
                String string = node.getString();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('.');
                }
                stringBuilder.append(string);
                return true;
            }
            case 34: {
                if (!node.hasChildren()) break;
                Node node2 = node.getFirstChild();
                AstUtilities.addName(stringBuilder, node2);
                node2 = node2.getNext();
                if (node2 != null) {
                    AstUtilities.addName(stringBuilder, node2);
                }
                return true;
            }
            case 8: 
            case 33: {
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    AstUtilities.addName(stringBuilder, node3);
                }
                break;
            }
        }
        return true;
    }

    public static String getFqn(AstPath astPath, boolean[] blArray, String[] stringArray) {
        Node node = astPath.leaf();
        return AstUtilities.getFqn(node, blArray, stringArray);
    }

    public static String getFqn(Node node, boolean[] blArray, String[] stringArray) {
        Node node2 = null;
        while (node != null) {
            String string;
            if (node.getType() == 105) {
                string = AstUtilities.getFunctionFqn(node, blArray);
                if (string != null && node2 == null) {
                    node2 = node;
                }
                if (string != null && Character.isUpperCase(string.charAt(0))) {
                    int n = string.lastIndexOf(46);
                    if (n != -1 && n < string.length() - 1 && !Character.isUpperCase(string.charAt(n + 1))) {
                        if (stringArray != null) {
                            stringArray[0] = string.substring(n + 1);
                        }
                        string = string.substring(0, n);
                    }
                    return string;
                }
            } else if (node.getType() == 64 && (string = AstUtilities.getObjectLitFqn(node)[0]) != null) {
                if (string.endsWith(DOT_PROTOTYPE)) {
                    string = string.substring(0, string.length() - DOT_PROTOTYPE.length());
                }
                if (stringArray != null && node2 != null) {
                    for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                        Node node4;
                        if (node3.getType() != 157 || (node4 = AstUtilities.getLabelledNode(node3)) != node2) continue;
                        stringArray[0] = node3.getString();
                        break;
                    }
                }
                return string;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static String getExpressionType(Node node) {
        String string;
        switch (node.getType()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 43: 
            case 44: 
            case 100: 
            case 101: {
                string = "Boolean";
                break;
            }
            case 39: {
                string = "Number";
                break;
            }
            case 40: {
                if ("undefined".equals(node.getString())) {
                    string = Node.UNKNOWN_TYPE;
                    break;
                }
                string = "String";
                break;
            }
            case 47: {
                string = "RegExp";
                break;
            }
            case 63: {
                string = "Array";
                break;
            }
            case 105: {
                string = "Function";
                break;
            }
            case 165: {
                string = "Undefined";
                break;
            }
            case 122: {
                string = "void";
                break;
            }
            case 30: {
                Node node2 = AstUtilities.getFirstChild(node);
                if (node2 != null) {
                    string = AstUtilities.getJoinedName(node2);
                    break;
                }
                string = Node.UNKNOWN_TYPE;
                break;
            }
            case 33: {
                string = AstUtilities.getJoinedName(node);
                int n = string.lastIndexOf(46);
                if (n == -1 || Character.isUpperCase(string.charAt(n + 1))) break;
                string = null;
                break;
            }
            default: {
                string = Node.UNKNOWN_TYPE;
            }
        }
        return string;
    }

    public static String getSurroundingWith(Node node) {
        int n;
        for (Node node2 = node; node2 != null && (n = node2.getType()) != 105; node2 = node2.getParentNode()) {
            String string;
            Node node3;
            if (n != 119) continue;
            for (node3 = node2.getParentNode().getFirstChild(); node3 != null && node3.getNext() != node2; node3 = node3.getNext()) {
            }
            if (node3 == null || node3.getType() != 2 || node3.getFirstChild() == null || (string = AstUtilities.getJoinedName(node3.getFirstChild())) == null || string.length() <= 0) break;
            return string;
        }
        return null;
    }
}

