/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide.ui;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.openide.filesystems.JarFileSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBPluginUtils {
    public static final String SERVER_4_XML = File.separator + "deploy" + File.separator + "jbossweb-tomcat55.sar" + File.separator + "server.xml";
    public static final String SERVER_4_2_XML = File.separator + "deploy" + File.separator + "jboss-web.deployer" + File.separator + "server.xml";
    public static final String SERVER_5_XML = File.separator + "deployers" + File.separator + "jbossweb.deployer" + File.separator + "server.xml";
    private static final Logger LOGGER = Logger.getLogger(JBPluginUtils.class.getName());
    private static final Version DOM4J_SERVER = new Version("4.0.4");
    private static List<String> domainRequirements4x;
    private static List<String> domainRequirements5x;
    private static List<String> domainAlterRequirements5x;
    private static List<String> serverRequirements4x;
    private static List<String> serverAlterRequirements4x;
    private static List<String> serverRequirements5x;

    private static synchronized List<String> getDomainRequirements4x() {
        if (domainRequirements4x == null) {
            domainRequirements4x = new ArrayList<String>(13);
            Collections.addAll(domainRequirements4x, "conf", "deploy", "lib", "conf/jboss-service.xml", "lib/jboss-j2ee.jar", "lib/jboss.jar", "lib/jbosssx.jar", "lib/jboss-transaction.jar", "lib/jmx-adaptor-plugin.jar", "lib/jnpserver.jar", "lib/log4j.jar", "lib/xmlentitymgr.jar", "deploy/jmx-invoker-service.xml");
        }
        return domainRequirements4x;
    }

    private static synchronized List<String> getDomainRequirements5x() {
        if (domainRequirements5x == null) {
            domainRequirements5x = new ArrayList<String>(11);
            Collections.addAll(domainRequirements5x, "conf", "deploy", "lib", "conf/jboss-service.xml", "lib/jboss-javaee.jar", "lib/jboss.jar", "lib/jbosssx.jar", "lib/jmx-adaptor-plugin.jar", "lib/jnpserver.jar", "lib/log4j.jar", "deploy/jmx-invoker-service.xml");
        }
        return domainRequirements5x;
    }

    private static synchronized List<String> getDomainAlterRequirements5x() {
        if (domainAlterRequirements5x == null) {
            domainAlterRequirements5x = new ArrayList<String>(12);
            Collections.addAll(domainAlterRequirements5x, "conf", "deploy", "lib", "conf/jboss-service.xml", "lib/jboss-j2ee.jar", "lib/jboss.jar", "lib/jbosssx.jar", "lib/jboss-transaction.jar", "lib/jmx-adaptor-plugin.jar", "lib/jnpserver.jar", "lib/log4j.jar", "deploy/jmx-invoker-service.xml");
        }
        return domainAlterRequirements5x;
    }

    private static synchronized List<String> getServerRequirements4x() {
        if (serverRequirements4x == null) {
            serverRequirements4x = new ArrayList<String>(6);
            Collections.addAll(serverRequirements4x, "bin", "client", "lib", "server", "lib/jboss-common.jar", "lib/endorsed/resolver.jar");
        }
        return serverRequirements4x;
    }

    private static synchronized List<String> getServerAlterRequirements4x() {
        if (serverAlterRequirements4x == null) {
            serverAlterRequirements4x = new ArrayList<String>(8);
            Collections.addAll(serverAlterRequirements4x, "bin", "client", "lib", "server", "lib/jboss-common.jar", "client/jaxb-xjc.jar", "client/jaxb-impl.jar", "client/jaxb-api.jar");
        }
        return serverAlterRequirements4x;
    }

    private static synchronized List<String> getServerRequirements5x() {
        if (serverRequirements5x == null) {
            serverRequirements5x = new ArrayList<String>(6);
            Collections.addAll(serverRequirements5x, "bin", "client", "lib", "server", "lib/dom4j.jar", "lib/jboss-common-core.jar", "lib/endorsed/resolver.jar");
        }
        return serverRequirements5x;
    }

    public static Hashtable getRegisteredDomains(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        File file = new File(string);
        if (JBPluginUtils.isGoodJBServerLocation(file)) {
            File file2 = new File(string + File.separator + "server");
            String[] stringArray = file2.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return new File(file.getAbsolutePath() + File.separator + string).isDirectory();
                }
            });
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = file2.getAbsolutePath() + File.separator + stringArray[i];
                if (!JBPluginUtils.isGoodJBInstanceLocation(file, new File(string2))) continue;
                hashtable.put(stringArray[i], string2);
            }
        }
        return hashtable;
    }

    private static boolean isGoodJBInstanceLocation(File file, List<String> list) {
        return null != file && file.exists() && file.canRead() && file.isDirectory() && JBPluginUtils.hasRequiredChildren(file, list);
    }

    private static boolean isGoodJBInstanceLocation4x(File file, File file2) {
        if (!JBPluginUtils.isGoodJBInstanceLocation(file2, JBPluginUtils.getDomainRequirements4x())) {
            return false;
        }
        Version version = JBPluginUtils.getServerVersion(file);
        if (version == null) {
            return true;
        }
        if (version.compareToIgnoreUpdate(DOM4J_SERVER) > 0) {
            File file3 = new File(file2, "lib/dom4j.jar");
            return file3.exists() && file3.canRead();
        }
        return true;
    }

    private static boolean isGoodJBInstanceLocation5x(File file, File file2) {
        return JBPluginUtils.isGoodJBInstanceLocation(file2, JBPluginUtils.getDomainRequirements5x()) || JBPluginUtils.isGoodJBInstanceLocation(file2, JBPluginUtils.getDomainAlterRequirements5x());
    }

    public static boolean isGoodJBInstanceLocation(File file, File file2) {
        Version version = JBPluginUtils.getServerVersion(file);
        if (version == null || !"4".equals(version.getMajorNumber()) && !"5".equals(version.getMajorNumber())) {
            return JBPluginUtils.isGoodJBInstanceLocation4x(file, file2) || JBPluginUtils.isGoodJBInstanceLocation5x(file, file2);
        }
        return "4".equals(version.getMajorNumber()) && JBPluginUtils.isGoodJBInstanceLocation4x(file, file2) || "5".equals(version.getMajorNumber()) && JBPluginUtils.isGoodJBInstanceLocation5x(file, file2);
    }

    private static boolean isGoodJBServerLocation(File file, List<String> list) {
        return null != file && file.exists() && file.canRead() && file.isDirectory() && JBPluginUtils.hasRequiredChildren(file, list);
    }

    private static boolean isGoodJBServerLocation4x(File file) {
        if (!JBPluginUtils.isGoodJBServerLocation(file, JBPluginUtils.getServerRequirements4x()) && !JBPluginUtils.isGoodJBServerLocation(file, JBPluginUtils.getServerAlterRequirements4x())) {
            return false;
        }
        Version version = JBPluginUtils.getServerVersion(file);
        if (version == null) {
            return true;
        }
        if (version.compareToIgnoreUpdate(DOM4J_SERVER) <= 0) {
            File file2 = new File(file, "lib/dom4j.jar");
            return file2.exists() && file2.canRead();
        }
        return true;
    }

    private static boolean isGoodJBServerLocation5x(File file) {
        return JBPluginUtils.isGoodJBServerLocation(file, JBPluginUtils.getServerRequirements5x());
    }

    public static boolean isGoodJBServerLocation(File file) {
        Version version = JBPluginUtils.getServerVersion(file);
        if (version == null || !"4".equals(version.getMajorNumber()) && !"5".equals(version.getMajorNumber())) {
            return JBPluginUtils.isGoodJBServerLocation4x(file) || JBPluginUtils.isGoodJBServerLocation5x(file);
        }
        return "4".equals(version.getMajorNumber()) && JBPluginUtils.isGoodJBServerLocation4x(file) || "5".equals(version.getMajorNumber()) && JBPluginUtils.isGoodJBServerLocation5x(file);
    }

    public static boolean isJB4(JBDeploymentManager jBDeploymentManager) {
        String string = jBDeploymentManager.getInstanceProperties().getProperty("root-dir");
        Version version = JBPluginUtils.getServerVersion(new File(string));
        if (version == null) {
            return JBPluginUtils.isGoodJBServerLocation4x(new File(string));
        }
        return "4".equals(version.getMajorNumber());
    }

    public static boolean isGoodJBLocation(File file, File file2) {
        return JBPluginUtils.isGoodJBServerLocation4x(file) && JBPluginUtils.isGoodJBInstanceLocation4x(file, file2) || JBPluginUtils.isGoodJBServerLocation5x(file) && JBPluginUtils.isGoodJBInstanceLocation5x(file, file2);
    }

    private static boolean hasRequiredChildren(File file, List<String> list) {
        if (null == file || null == file.list()) {
            return false;
        }
        if (null == list) {
            return true;
        }
        for (String string : list) {
            File file2 = new File(file.getPath() + File.separator + string);
            if (file2.exists()) continue;
            return false;
        }
        return true;
    }

    public static String getDeployDir(String string) {
        return string + File.separator + "deploy";
    }

    public static String getHTTPConnectorPort(String string) {
        String string2 = "8080";
        File file = new File(string + SERVER_4_XML);
        if (!(file.exists() || (file = new File(string + SERVER_4_2_XML)).exists() || (file = new File(string + SERVER_5_XML)).exists())) {
            return string2;
        }
        FileInputStream fileInputStream = null;
        Document document = null;
        try {
            fileInputStream = new FileInputStream(file);
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("Service")) continue;
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equals("Connector")) continue;
                    return node2.getAttributes().getNamedItem("port").getNodeValue();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static String getJnpPort(String string) {
        String string2 = string + File.separator + "conf" + File.separator + "jboss-service.xml";
        File file = new File(string2);
        if (!file.exists()) {
            return "";
        }
        FileInputStream fileInputStream = null;
        Document document = null;
        try {
            fileInputStream = new FileInputStream(file);
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("mbean")) continue;
                NodeList nodeList2 = node.getChildNodes();
                if (!node.getAttributes().getNamedItem("name").getNodeValue().equals("jboss:service=Naming")) continue;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equals("attribute") || !node2.getAttributes().getNamedItem("name").getNodeValue().equals("Port")) continue;
                    return node2.getFirstChild().getNodeValue();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
        }
        return "";
    }

    public static String getRMINamingServicePort(String string) {
        String string2 = string + File.separator + "conf" + File.separator + "jboss-service.xml";
        File file = new File(string2);
        if (!file.exists()) {
            return "";
        }
        FileInputStream fileInputStream = null;
        Document document = null;
        try {
            fileInputStream = new FileInputStream(file);
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("mbean")) continue;
                NodeList nodeList2 = node.getChildNodes();
                if (!node.getAttributes().getNamedItem("name").getNodeValue().equals("jboss:service=Naming")) continue;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equals("attribute") || !node2.getAttributes().getNamedItem("name").getNodeValue().equals("RmiPort")) continue;
                    return node2.getFirstChild().getNodeValue();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
        }
        return "";
    }

    public static String getRMIInvokerPort(String string) {
        String string2 = string + File.separator + "conf" + File.separator + "jboss-service.xml";
        File file = new File(string2);
        if (!file.exists()) {
            return "";
        }
        FileInputStream fileInputStream = null;
        Document document = null;
        try {
            fileInputStream = new FileInputStream(file);
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("mbean")) continue;
                NodeList nodeList2 = node.getChildNodes();
                if (!node.getAttributes().getNamedItem("name").getNodeValue().equals("jboss:service=invoker,type=jrmp")) continue;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equals("attribute") || !node2.getAttributes().getNamedItem("name").getNodeValue().equals("RMIObjectPort")) continue;
                    return node2.getFirstChild().getNodeValue();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortFree(int n) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static Version getServerVersion(File file) {
        assert (file != null) : "Can't determine version with null server path";
        File file2 = new File(file, "lib/jboss-system.jar");
        return JBPluginUtils.getVersion(file2);
    }

    private static Version getVersion(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            JarFileSystem jarFileSystem = new JarFileSystem();
            jarFileSystem.setJarFile(file);
            Attributes attributes = jarFileSystem.getManifest().getMainAttributes();
            String string = attributes.getValue("Specification-Version");
            if (string != null) {
                return new Version(string);
            }
            return null;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return null;
        }
        catch (PropertyVetoException propertyVetoException) {
            LOGGER.log(Level.INFO, null, propertyVetoException);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Version
    implements Comparable<Version> {
        private String majorNumber = "0";
        private String minorNumber = "0";
        private String microNumber = "0";
        private String update = "";

        public Version(String string) {
            assert (string != null) : "Version can't be null";
            String[] stringArray = string.split("\\.");
            if (stringArray.length >= 4) {
                this.update = stringArray[3];
            }
            if (stringArray.length >= 3) {
                this.microNumber = stringArray[2];
            }
            if (stringArray.length >= 2) {
                this.minorNumber = stringArray[1];
            }
            this.majorNumber = stringArray[0];
        }

        public String getMajorNumber() {
            return this.majorNumber;
        }

        public String getMinorNumber() {
            return this.minorNumber;
        }

        public String getMicroNumber() {
            return this.microNumber;
        }

        public String getUpdate() {
            return this.update;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Version version = (Version)object;
            if (!(this.majorNumber == version.majorNumber || this.majorNumber != null && this.majorNumber.equals(version.majorNumber))) {
                return false;
            }
            if (!(this.minorNumber == version.minorNumber || this.minorNumber != null && this.minorNumber.equals(version.minorNumber))) {
                return false;
            }
            if (!(this.microNumber == version.microNumber || this.microNumber != null && this.microNumber.equals(version.microNumber))) {
                return false;
            }
            return this.update == version.update || this.update != null && this.update.equals(version.update);
        }

        public int hashCode() {
            int n = 7;
            n = 17 * n + (this.majorNumber != null ? this.majorNumber.hashCode() : 0);
            n = 17 * n + (this.minorNumber != null ? this.minorNumber.hashCode() : 0);
            n = 17 * n + (this.microNumber != null ? this.microNumber.hashCode() : 0);
            n = 17 * n + (this.update != null ? this.update.hashCode() : 0);
            return n;
        }

        @Override
        public int compareTo(Version version) {
            int n = this.compareToIgnoreUpdate(version);
            if (n != 0) {
                return n;
            }
            return this.update.compareTo(version.update);
        }

        public int compareToIgnoreUpdate(Version version) {
            int n = this.majorNumber.compareTo(version.majorNumber);
            if (n != 0) {
                return n;
            }
            n = this.minorNumber.compareTo(version.minorNumber);
            if (n != 0) {
                return n;
            }
            return this.microNumber.compareTo(version.microNumber);
        }
    }
}

