/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.BinaryElementOpen;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementOpen {
    private ElementOpen() {
    }

    public static boolean open(ClasspathInfo classpathInfo, ElementHandle<? extends Element> elementHandle) {
        Object[] objectArray;
        FileObject fileObject = SourceUtils.getFile(elementHandle, (ClasspathInfo)classpathInfo);
        Object[] objectArray2 = objectArray = fileObject != null ? ElementOpen.getOpenInfo(fileObject, elementHandle) : null;
        if (objectArray != null) {
            assert (objectArray[0] instanceof FileObject);
            assert (objectArray[1] instanceof Integer);
            return ElementOpen.doOpen((FileObject)objectArray[0], (Integer)objectArray[1]);
        }
        BinaryElementOpen binaryElementOpen = (BinaryElementOpen)Lookup.getDefault().lookup(BinaryElementOpen.class);
        if (binaryElementOpen != null) {
            return binaryElementOpen.open(classpathInfo, elementHandle);
        }
        return false;
    }

    public static boolean open(ClasspathInfo classpathInfo, Element element) {
        return ElementOpen.open(classpathInfo, (ElementHandle<? extends Element>)ElementHandle.create((Element)element));
    }

    public static boolean open(FileObject fileObject, ElementHandle<? extends Element> elementHandle) {
        if (fileObject == null || elementHandle == null) {
            throw new IllegalArgumentException("null not supported");
        }
        Object[] objectArray = ElementOpen.getOpenInfo(fileObject, elementHandle);
        if (objectArray != null) {
            assert (objectArray[0] instanceof FileObject);
            assert (objectArray[1] instanceof Integer);
            return ElementOpen.doOpen((FileObject)objectArray[0], (Integer)objectArray[1]);
        }
        BinaryElementOpen binaryElementOpen = (BinaryElementOpen)Lookup.getDefault().lookup(BinaryElementOpen.class);
        if (binaryElementOpen != null) {
            return binaryElementOpen.open(ClasspathInfo.create((FileObject)fileObject), elementHandle);
        }
        return false;
    }

    private static Object[] getOpenInfo(FileObject fileObject, ElementHandle<? extends Element> elementHandle) {
        assert (fileObject != null);
        try {
            int n = ElementOpen.getOffset(fileObject, elementHandle);
            return new Object[]{fileObject, n};
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private static boolean doOpen(FileObject fileObject, int n) {
        try {
            Object object;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (editorCookie != null && lineCookie != null && n != -1 && (object = editorCookie.openDocument()) != null) {
                Line line;
                int n2 = NbDocument.findLineNumber((StyledDocument)object, (int)n);
                int n3 = NbDocument.findLineOffset((StyledDocument)object, (int)n2);
                int n4 = n - n3;
                if (n2 != -1 && (line = lineCookie.getLineSet().getCurrent(n2)) != null) {
                    line.show(2, n4);
                    return true;
                }
            }
            if ((object = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                object.open();
                return true;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    private static int getOffset(FileObject fileObject, final ElementHandle<? extends Element> elementHandle) throws IOException {
        final int[] nArray = new int[]{-1};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource != null) {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) {
                    try {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    Element element = elementHandle.resolve((CompilationInfo)compilationController);
                    if (element == null) {
                        ErrorManager.getDefault().log(65536, "Cannot resolve " + elementHandle + ". " + compilationController.getClasspathInfo());
                        return;
                    }
                    FindDeclarationVisitor findDeclarationVisitor = new FindDeclarationVisitor(element, (CompilationInfo)compilationController);
                    CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                    findDeclarationVisitor.scan(compilationUnitTree, null);
                    Tree tree = findDeclarationVisitor.declTree;
                    if (tree != null) {
                        nArray[0] = (int)compilationController.getTrees().getSourcePositions().getStartPosition(compilationUnitTree, tree);
                    }
                }
            }, true);
        }
        return nArray[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindDeclarationVisitor
    extends TreePathScanner<Void, Void> {
        private Element element;
        private Tree declTree;
        private CompilationInfo info;

        public FindDeclarationVisitor(Element element, CompilationInfo compilationInfo) {
            this.element = element;
            this.info = compilationInfo;
        }

        @Override
        public Void visitClass(ClassTree classTree, Void void_) {
            this.handleDeclaration();
            super.visitClass(classTree, void_);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree methodTree, Void void_) {
            this.handleDeclaration();
            super.visitMethod(methodTree, void_);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void void_) {
            this.handleDeclaration();
            super.visitVariable(variableTree, void_);
            return null;
        }

        public void handleDeclaration() {
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            if (((Object)this.element).equals(element)) {
                this.declTree = this.getCurrentPath().getLeaf();
            }
        }
    }
}

