/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.ui.LastUsedFolders;
import org.netbeans.modules.php.project.ui.ProjectNameProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ProjectFolder
extends JPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 7976754658426848L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final ProjectNameProvider projectNameProvider;
    private JButton projectFolderBrowseButton;
    private JCheckBox projectFolderCheckBox;
    private JLabel projectFolderLabel;
    private JScrollPane projectFolderScrollPane;
    private JTextArea projectFolderTextArea;
    private JTextField projectFolderTextField;

    public ProjectFolder(ProjectNameProvider projectNameProvider) {
        this.projectNameProvider = projectNameProvider;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.projectFolderCheckBox.addActionListener(this);
        this.projectFolderTextField.getDocument().addDocumentListener(this);
    }

    void addProjectFolderListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    void removeProjectFolderListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    boolean isProjectFolderUsed() {
        return this.projectFolderCheckBox.isSelected();
    }

    void setProjectFolderUsed(boolean bl) {
        this.projectFolderCheckBox.setSelected(bl);
        this.setState(bl);
    }

    String getProjectFolder() {
        return this.projectFolderTextField.getText().trim();
    }

    void setProjectFolder(String string) {
        this.projectFolderTextField.setText(string);
    }

    void setState(boolean bl) {
        this.projectFolderLabel.setEnabled(bl);
        this.projectFolderTextField.setEnabled(bl);
        this.projectFolderBrowseButton.setEnabled(bl);
    }

    private void initComponents() {
        this.projectFolderCheckBox = new JCheckBox();
        this.projectFolderLabel = new JLabel();
        this.projectFolderTextField = new JTextField();
        this.projectFolderBrowseButton = new JButton();
        this.projectFolderScrollPane = new JScrollPane();
        this.projectFolderTextArea = new JTextArea();
        Mnemonics.setLocalizedText((AbstractButton)this.projectFolderCheckBox, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_SeparateProjectFolder"));
        this.projectFolderLabel.setLabelFor(this.projectFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_MetadataFolder"));
        this.projectFolderLabel.setEnabled(false);
        this.projectFolderTextField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.projectFolderBrowseButton, (String)NbBundle.getMessage(ProjectFolder.class, (String)"LBL_BrowseProject"));
        this.projectFolderBrowseButton.setEnabled(false);
        this.projectFolderBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFolder.this.projectFolderBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.projectFolderScrollPane.setBorder(null);
        this.projectFolderTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.projectFolderTextArea.setEditable(false);
        this.projectFolderTextArea.setLineWrap(true);
        this.projectFolderTextArea.setText(NbBundle.getMessage(ProjectFolder.class, (String)"TXT_MetadataInfo"));
        this.projectFolderTextArea.setWrapStyleWord(true);
        this.projectFolderTextArea.setBorder(null);
        this.projectFolderTextArea.setDisabledTextColor(UIManager.getDefaults().getColor("Label.disabledForeground"));
        this.projectFolderTextArea.setEnabled(false);
        this.projectFolderScrollPane.setViewportView(this.projectFolderTextArea);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.projectFolderScrollPane, -1, 459, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectFolderCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.projectFolderLabel).addPreferredGap(0).add((Component)this.projectFolderTextField, -1, 249, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.projectFolderBrowseButton))).add(0, 0, 0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.projectFolderCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectFolderTextField, -2, -1, -2).add((Component)this.projectFolderLabel).add((Component)this.projectFolderBrowseButton)).addPreferredGap(0).add((Component)this.projectFolderScrollPane, -1, 60, Short.MAX_VALUE)));
    }

    private void projectFolderBrowseButtonActionPerformed(ActionEvent actionEvent) {
        File file = Utils.browseLocationAction(this, LastUsedFolders.getProject(), NbBundle.getMessage(ProjectFolder.class, (String)"LBL_SelectProjectFolder"));
        if (file != null) {
            this.setProjectFolder(new File(file, this.projectNameProvider.getProjectName()).getAbsolutePath());
            LastUsedFolders.setProject(file);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setState(this.projectFolderCheckBox.isSelected());
        this.changeSupport.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.processUpdate();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.processUpdate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.processUpdate();
    }

    private void processUpdate() {
        this.changeSupport.fireChange();
    }
}

