/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.Utils;
import org.netbeans.modules.php.project.ui.logicalview.PhpSourcesFilter;
import org.netbeans.modules.php.project.ui.logicalview.SrcNode;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;

public class SourcesNodeFactory
implements NodeFactory {
    private static final Logger LOGGER = Logger.getLogger(SourcesNodeFactory.class.getName());

    public NodeList createNodes(Project project) {
        PhpProject phpProject = (PhpProject)project.getLookup().lookup(PhpProject.class);
        return new SourceChildrenList(phpProject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceChildrenList
    implements NodeList<SourceGroup>,
    ChangeListener {
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;
        private final PhpProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public SourceChildrenList(PhpProject phpProject) {
            this.project = phpProject;
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SourceChildrenList.this.fireChange();
                }
            });
        }

        private void fireChange() {
            this.changeSupport.fireChange();
        }

        private DataFolder getFolder(FileObject fileObject) {
            if (fileObject != null && fileObject.isValid()) {
                try {
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    return dataFolder;
                }
                catch (Exception exception) {
                    LOGGER.log(Level.INFO, null, exception);
                }
            }
            return null;
        }

        public List<SourceGroup> keys() {
            Sources sources = this.getSources();
            SourceGroup[] sourceGroupArray = Utils.getSourceGroups(this.project);
            SourceGroup[] sourceGroupArray2 = new SourceGroup[sourceGroupArray.length];
            System.arraycopy(sourceGroupArray, 0, sourceGroupArray2, 0, sourceGroupArray.length);
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>(sourceGroupArray2.length);
            FileObject fileObject = null;
            for (int i = 0; i < sourceGroupArray2.length; ++i) {
                fileObject = sourceGroupArray2[i].getRootFolder();
                DataFolder dataFolder = this.getFolder(fileObject);
                if (dataFolder == null) continue;
                arrayList.add(sourceGroupArray2[i]);
            }
            return arrayList;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public Node node(SourceGroup sourceGroup) {
            DataFolder dataFolder;
            SrcNode srcNode = null;
            if (sourceGroup != null && (dataFolder = this.getFolder(sourceGroup.getRootFolder())) != null) {
                srcNode = new SrcNode(this.project, dataFolder, (DataFilter)new PhpSourcesFilter(this.project));
            }
            return srcNode;
        }
    }
}

