/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.net.MalformedURLException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.DebugCommand;
import org.netbeans.modules.php.project.ui.actions.DebugLocalCommand;
import org.netbeans.modules.php.project.ui.actions.XDebugStarterFactory;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DebugSingleCommand
extends DebugCommand {
    public static final String ID = "debug.single";
    public static String DISPLAY_NAME = DebugCommand.DISPLAY_NAME;
    private final DebugLocalCommand debugLocalCommand;

    public DebugSingleCommand(PhpProject phpProject) {
        super(phpProject);
        this.debugLocalCommand = new DebugLocalCommand(phpProject);
    }

    public void invokeAction(final Lookup lookup) throws IllegalArgumentException {
        if (this.isScriptSelected()) {
            this.debugLocalCommand.invokeAction(lookup);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        DebugSingleCommand.this.showURLForDebugContext(lookup);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            };
            boolean bl = WebClientToolsSessionStarterService.isAvailable();
            if (!bl || WebClientToolsProjectUtils.getServerDebugProperty((Project)this.getProject())) {
                XDebugStarter xDebugStarter = XDebugStarterFactory.getInstance();
                if (xDebugStarter != null) {
                    if (xDebugStarter.isAlreadyRunning()) {
                        String string = NbBundle.getMessage(DebugSingleCommand.class, (String)"MSG_NoMoreDebugSession");
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
                        boolean bl2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.OK_OPTION);
                        if (bl2) {
                            xDebugStarter.stop();
                            this.invokeAction(lookup);
                        }
                    } else {
                        xDebugStarter.start(this.getProject(), runnable, this.fileForContext(lookup), this.isScriptSelected());
                    }
                }
            } else {
                runnable.run();
            }
        }
    }

    public boolean isActionEnabled(Lookup lookup) throws IllegalArgumentException {
        return this.fileForContext(lookup) != null && XDebugStarterFactory.getInstance() != null;
    }

    public String getCommandId() {
        return ID;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

