/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.net.MalformedURLException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.DebugLocalCommand;
import org.netbeans.modules.php.project.ui.actions.Displayable;
import org.netbeans.modules.php.project.ui.actions.XDebugStarterFactory;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DebugCommand
extends Command
implements Displayable {
    public static final String ID = "debug";
    public static String DISPLAY_NAME = NbBundle.getMessage(DebugCommand.class, (String)"LBL_DebugProject");
    private final DebugLocalCommand debugLocalCommand;

    public DebugCommand(PhpProject phpProject) {
        super(phpProject);
        this.debugLocalCommand = new DebugLocalCommand(phpProject);
    }

    public void invokeAction(Lookup lookup) throws IllegalArgumentException {
        if (this.isScriptSelected()) {
            this.debugLocalCommand.invokeAction(null);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        DebugCommand.this.showURLForDebugProjectFile();
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            };
            boolean bl = WebClientToolsSessionStarterService.isAvailable();
            if (!bl || WebClientToolsProjectUtils.getServerDebugProperty((Project)this.getProject())) {
                XDebugStarter xDebugStarter = XDebugStarterFactory.getInstance();
                if (xDebugStarter != null) {
                    if (xDebugStarter.isAlreadyRunning()) {
                        String string = NbBundle.getMessage(DebugCommand.class, (String)"MSG_NoMoreDebugSession");
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
                        boolean bl2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.OK_OPTION);
                        if (bl2) {
                            xDebugStarter.stop();
                            this.invokeAction(lookup);
                        }
                    } else {
                        FileObject fileObject = this.fileForProject();
                        if (fileObject != null) {
                            xDebugStarter.start(this.getProject(), runnable, fileObject, this.isScriptSelected());
                        } else {
                            String string = this.getProperty("index.file");
                            String string2 = NbBundle.getMessage(DebugLocalCommand.class, (String)"ERR_Missing_IndexFile", (Object)string);
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 2);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        }
                    }
                }
            } else {
                runnable.run();
            }
        }
    }

    public boolean isActionEnabled(Lookup lookup) throws IllegalArgumentException {
        return XDebugStarterFactory.getInstance() != null;
    }

    public String getCommandId() {
        return ID;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

