/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.netbeans.modules.php.project.PhpProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandUtils {
    private PhpProject project;

    public CommandUtils(PhpProject phpProject) {
        this.project = phpProject;
    }

    public FileObject[] phpFilesForContext(Lookup lookup, boolean bl, String string) {
        FileObject fileObject = bl ? this.getProject().getSourcesDirectory() : this.getProject().getWebRootDirectory();
        return CommandUtils.filter(this.filesForContext(lookup), fileObject);
    }

    public FileObject[] phpFilesForSelectedNodes(boolean bl, String string) {
        FileObject fileObject = bl ? this.getProject().getSourcesDirectory() : this.getProject().getWebRootDirectory();
        return CommandUtils.filter(Arrays.asList(CommandUtils.filesForSelectedNodes()), fileObject);
    }

    public Collection<? extends FileObject> filesForContext(Lookup lookup) {
        return lookup.lookupAll(FileObject.class);
    }

    public static FileObject[] filesForSelectedNodes() {
        Node[] nodeArray = CommandUtils.getSelectedNodes();
        if (nodeArray == null) {
            return new FileObject[0];
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(nodeArray.length);
        for (Node node : nodeArray) {
            FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
            if (fileObject == null) {
                fileObject = CommandUtils.getFileObject(node);
            }
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    public static Node[] getSelectedNodes() {
        return TopComponent.getRegistry().getCurrentNodes();
    }

    public String getRelativeSrcPath(FileObject fileObject) {
        return this.getRelativePhpPath(this.getProject().getSourcesDirectory(), fileObject);
    }

    public String getRelativeWebRootPath(FileObject fileObject, String string) {
        return this.getRelativePhpPath(this.getProject().getWebRootDirectory(), fileObject);
    }

    public String getRelativePhpPath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2 != null) {
            if (fileObject2.equals(this.getProject().getProjectDirectory())) {
                return "";
            }
            if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
                return FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
            }
            if (fileObject.equals(fileObject2)) {
                return "";
            }
        }
        return null;
    }

    private static boolean isUnderSourceRoot(FileObject fileObject, FileObject fileObject2) {
        return FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) && FileUtil.toFile((FileObject)fileObject2) != null;
    }

    public static boolean isPhpFile(FileObject fileObject) {
        return fileObject.getMIMEType().equals("text/x-php5");
    }

    private static FileObject[] filter(Collection<? extends FileObject> collection, FileObject fileObject) {
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        for (FileObject fileObject2 : collection) {
            if (!CommandUtils.isUnderSourceRoot(fileObject, fileObject2) || !CommandUtils.isPhpFile(fileObject2)) {
                return null;
            }
            linkedHashSet.add(fileObject2);
        }
        return !linkedHashSet.isEmpty() ? linkedHashSet.toArray(new FileObject[linkedHashSet.size()]) : null;
    }

    private static FileObject getFileObject(Node node) {
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }

    private PhpProject getProject() {
        return this.project;
    }
}

