/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableChangeListener;
import org.netbeans.modules.php.project.connections.ui.TransferFileUnit;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransferFileTableModel
extends AbstractTableModel {
    private List<TransferFileUnit> fileData = Collections.emptyList();
    private List<TransferFileTableChangeListener> listeners = new ArrayList<TransferFileTableChangeListener>();
    private String filter = "";
    private Comparator<TransferFileUnit> fileCmp;

    List<TransferFileUnit> getData() {
        return this.fileData;
    }

    static Map<Integer, Boolean> captureState(List<TransferFileUnit> list) {
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        for (TransferFileUnit transferFileUnit : list) {
            hashMap.put(transferFileUnit.getId(), transferFileUnit.isMarked());
        }
        return hashMap;
    }

    static void restoreState(List<TransferFileUnit> list, Map<Integer, Boolean> map, boolean bl) {
        for (TransferFileUnit transferFileUnit : list) {
            Boolean bl2 = map.get(transferFileUnit.getId());
            if (bl2 != null) {
                if (bl2.booleanValue() && !transferFileUnit.isMarked() && transferFileUnit.canBeMarked()) {
                    transferFileUnit.setMarked(true);
                    continue;
                }
                if (bl2.booleanValue() || !transferFileUnit.isMarked() || !transferFileUnit.canBeMarked()) continue;
                transferFileUnit.setMarked(false);
                continue;
            }
            if (!bl || transferFileUnit.isMarked() || !transferFileUnit.canBeMarked()) continue;
            transferFileUnit.setMarked(true);
        }
    }

    public static boolean isMarkedAsDefault() {
        return true;
    }

    public abstract Type getType();

    @Override
    public abstract Object getValueAt(int var1, int var2);

    public abstract Class getColumnClass(int var1);

    public abstract boolean isSortAllowed(Object var1);

    protected abstract Comparator<TransferFileUnit> getComparator(Object var1, boolean var2);

    public String getTabTooltipText() {
        return null;
    }

    public abstract String getTabTitle();

    public final String getDecoratedTabTitle() {
        int n;
        int n2 = this.getItemCount();
        String string = n2 == (n = this.getRawItemCount()) ? String.valueOf(n) : NbBundle.getMessage(TransferFileTableModel.class, (String)"FileConfirmationUI_Tabs_CountFormat", (Object)n2, (Object)n);
        String string2 = NbBundle.getMessage(TransferFileTableModel.class, (String)"FileConfirmationUI_Tabs_NameFormat", (Object)this.getTabTitle(), (Object)string);
        return n == 0 ? this.getTabTitle() : string2;
    }

    public String getToolTipText(int n, int n2) {
        String string = null;
        if (n2 == 0) {
            string = this.getTooltipForCheckBox(n);
        } else if (n2 == 1) {
            string = (String)this.getValueAt(n, 1);
        }
        return string;
    }

    public int getMinWidth(JTableHeader jTableHeader, int n) {
        return jTableHeader.getHeaderRect((int)n).width;
    }

    public abstract int getPreferredWidth(JTableHeader var1, int var2);

    protected Comparator<TransferFileUnit> getDefaultComparator() {
        return new Comparator<TransferFileUnit>(){

            @Override
            public int compare(TransferFileUnit transferFileUnit, TransferFileUnit transferFileUnit2) {
                return TransferFileUnit.compare(transferFileUnit, transferFileUnit2);
            }
        };
    }

    public final void sort(Object object, boolean bl) {
        if (object == null) {
            this.setFileUnitComparator(this.getDefaultComparator());
        } else {
            this.setFileUnitComparator(this.getComparator(object, bl));
        }
        this.fireTableDataChanged();
    }

    private String getTooltipForCheckBox(int n) {
        String string = "FileConfirmation_TooltipCheckBox";
        return string != null ? NbBundle.getMessage(TransferFileTableModel.class, (String)string, (Object)((String)this.getValueAt(n, 1))) : null;
    }

    private final void setData(List<TransferFileUnit> list, Comparator<TransferFileUnit> comparator) {
        Comparator<TransferFileUnit> comparator2 = this.fileCmp = comparator != null ? comparator : this.getDefaultComparator();
        if (list != null) {
            this.fileData = Collections.emptyList();
            this.fileData = new ArrayList<TransferFileUnit>();
            this.fileData.addAll(list);
        } else assert (this.fileData != null);
        if (comparator != null) {
            Collections.sort(this.fileData, comparator);
        }
        this.fireTableDataChanged();
    }

    public final void setFileUnitComparator(Comparator<TransferFileUnit> comparator) {
        this.setData(null, comparator);
    }

    public final void setData(List<TransferFileUnit> list) {
        this.setData(list, null);
    }

    public void setFilter(final String string, final Runnable runnable) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class<TransferFileTableModel> clazz = TransferFileTableModel.class;
                synchronized (TransferFileTableModel.class) {
                    TransferFileTableModel.this.filter = string.toLowerCase();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    TransferFileTableModel.this.fireFilterChange();
                    if (runnable != null) {
                        runnable.run();
                    }
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilter() {
        Class<TransferFileTableModel> clazz = TransferFileTableModel.class;
        synchronized (TransferFileTableModel.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.filter == null ? "" : this.filter;
        }
    }

    public void addUpdateUnitListener(TransferFileTableChangeListener transferFileTableChangeListener) {
        this.listeners.add(transferFileTableChangeListener);
    }

    public void removeUpdateUnitListener(TransferFileTableChangeListener transferFileTableChangeListener) {
        this.listeners.remove(transferFileTableChangeListener);
    }

    void fireUpdataUnitChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (TransferFileTableChangeListener transferFileTableChangeListener : this.listeners) {
            transferFileTableChangeListener.updateUnitsChanged();
        }
    }

    void fireButtonsChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (TransferFileTableChangeListener transferFileTableChangeListener : this.listeners) {
            transferFileTableChangeListener.buttonsChanged();
        }
    }

    void fireFilterChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (TransferFileTableChangeListener transferFileTableChangeListener : this.listeners) {
            transferFileTableChangeListener.filterChanged();
        }
    }

    List<TransferFileUnit> getVisibleFileUnits() {
        return this.getVisibleFileUnits(this.getData(), this.getFilter(), true);
    }

    private List<TransferFileUnit> getVisibleFileUnits(List<TransferFileUnit> list, String string, boolean bl) {
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>();
        for (TransferFileUnit transferFileUnit : list) {
            if (bl) {
                if (!transferFileUnit.isVisible(string)) continue;
                arrayList.add(transferFileUnit);
                continue;
            }
            if (!transferFileUnit.isVisible(string)) continue;
            arrayList.add(transferFileUnit);
        }
        return arrayList;
    }

    @Override
    public int getRowCount() {
        return this.getVisibleFileUnits().size();
    }

    public int getRawItemCount() {
        return this.fileData.size();
    }

    public int getItemCount() {
        return this.getVisibleFileUnits().size();
    }

    public List<TransferFileUnit> getMarkedFileUnits() {
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>();
        List<TransferFileUnit> list = this.getMarkedUnits();
        for (TransferFileUnit transferFileUnit : list) {
            if (!transferFileUnit.getTransferFile().isFile()) continue;
            arrayList.add(transferFileUnit);
        }
        return arrayList;
    }

    public List<TransferFileUnit> getFilteredUnits() {
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>();
        List<TransferFileUnit> list = this.getData();
        for (TransferFileUnit transferFileUnit : list) {
            if (!transferFileUnit.isMarked() || !transferFileUnit.getTransferFile().isFile()) continue;
            arrayList.add(transferFileUnit);
        }
        return arrayList;
    }

    public List<TransferFileUnit> getMarkedUnits() {
        ArrayList<TransferFileUnit> arrayList = new ArrayList<TransferFileUnit>();
        List<TransferFileUnit> list = this.getData();
        for (TransferFileUnit transferFileUnit : list) {
            if (!transferFileUnit.isMarked()) continue;
            arrayList.add(transferFileUnit);
        }
        return arrayList;
    }

    public TransferFileUnit getUnitAtRow(int n) {
        return this.getVisibleFileUnits().size() <= n ? null : this.getVisibleFileUnits().get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 && Boolean.class.equals((Object)this.getColumnClass(n2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UPLOAD,
        DOWNLOAD;

    }
}

