/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.io.File;
import org.apache.commons.net.ftp.FTPFile;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class TransferFile {
    public static final String SEPARATOR = "/";
    public static final String CWD = ".";
    private final String name;
    private final String relativePath;
    private final String parentRelativePath;
    private final long size;
    private final boolean directory;
    private final boolean file;

    private TransferFile(String string, String string2, String string3, long l, boolean bl, boolean bl2) {
        assert (l >= 0L) : "Size cannot be smaller than 0";
        if (bl && l != 0L) {
            throw new IllegalArgumentException("Size of a directory has to be 0 bytes");
        }
        this.name = string;
        this.relativePath = string2;
        this.parentRelativePath = string3;
        this.directory = bl;
        this.file = bl2;
        this.size = l;
    }

    public static TransferFile fromFile(File file, String string) {
        assert (file != null);
        assert (string != null);
        file = FileUtil.normalizeFile((File)file);
        assert (file.getAbsolutePath().startsWith(string)) : "File must be underneath base directory [" + file.getAbsolutePath() + " => " + string + "]";
        String string2 = file.getName();
        String string3 = TransferFile.getPlatformIndependentPath(TransferFile.getRelativePath(file.getAbsolutePath(), string));
        String string4 = TransferFile.getPlatformIndependentPath(TransferFile.getParentRelativePath(file.getParentFile().getAbsolutePath(), string));
        boolean bl = file.isDirectory();
        boolean bl2 = file.isFile();
        long l = bl ? 0L : file.length();
        return new TransferFile(string2, string3, string4, l, bl, bl2);
    }

    public static TransferFile fromFileObject(FileObject fileObject, String string) {
        assert (fileObject != null);
        return TransferFile.fromFile(FileUtil.toFile((FileObject)fileObject), string);
    }

    public static TransferFile fromFtpFile(FTPFile fTPFile, String string, String string2) {
        assert (fTPFile != null);
        assert (string.startsWith(SEPARATOR)) : "Base directory must start with '/' [" + string + "]";
        assert (string2.startsWith(SEPARATOR)) : "Parent directory must start with '/' [" + string2 + "]";
        assert (!string.endsWith(SEPARATOR) && !string2.endsWith(SEPARATOR)) : "Both base and parent directory cannot end with '/' [" + string + ", " + string2 + "]";
        assert (string2.startsWith(string)) : "Parent directory must be underneath base directory [" + string2 + " => " + string + "]";
        String string3 = fTPFile.getName();
        String string4 = string2 + SEPARATOR + string3;
        String string5 = TransferFile.getRelativePath(string4, string);
        String string6 = TransferFile.getParentRelativePath(string2, string);
        boolean bl = fTPFile.isDirectory();
        boolean bl2 = fTPFile.isFile();
        long l = bl ? 0L : fTPFile.getSize();
        return new TransferFile(string3, string5, string6, l, bl, bl2);
    }

    public static TransferFile fromPath(String string) {
        assert (string != null);
        return new TransferFile(string, string, string, 0L, false, false);
    }

    private static String getRelativePath(String string, String string2) {
        if (string.equals(string2)) {
            return CWD;
        }
        return string.substring(string2.length() + SEPARATOR.length());
    }

    private static String getParentRelativePath(String string, String string2) {
        if (string.length() < string2.length()) {
            return null;
        }
        if (string.equals(string2)) {
            return CWD;
        }
        return string.substring(string2.length() + SEPARATOR.length());
    }

    private static String getPlatformIndependentPath(String string) {
        if (string == null) {
            return null;
        }
        if (File.separator.equals(SEPARATOR)) {
            return string;
        }
        return string.replace(File.separator, SEPARATOR);
    }

    private static String getPlatformDependentPath(String string) {
        if (string == null) {
            return null;
        }
        if (File.separator.equals(SEPARATOR)) {
            return string;
        }
        return string.replace(SEPARATOR, File.separator);
    }

    public String getName() {
        return this.name;
    }

    public String getRelativePath() {
        return this.getRelativePath(false);
    }

    public String getRelativePath(boolean bl) {
        if (bl) {
            return TransferFile.getPlatformDependentPath(this.relativePath);
        }
        return this.relativePath;
    }

    public String getParentRelativePath() {
        return this.getParentRelativePath(false);
    }

    public String getParentRelativePath(boolean bl) {
        if (bl) {
            return TransferFile.getPlatformDependentPath(this.parentRelativePath);
        }
        return this.parentRelativePath;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isFile() {
        return this.file;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TransferFile transferFile = (TransferFile)object;
        return this.relativePath.equals(transferFile.relativePath);
    }

    public int hashCode() {
        return this.relativePath.hashCode();
    }

    public String toString() {
        return this.relativePath;
    }
}

