/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.RemoteConnectionsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteConnections {
    static final Logger LOGGER = Logger.getLogger(RemoteConnections.class.getName());
    private static final String PREFERENCES_PATH = "RemoteConnections";
    private static final ConnectionType DEFAULT_TYPE = ConnectionType.FTP;
    private static final int DEFAULT_PORT = 21;
    private static final String DEFAULT_INITIAL_DIRECTORY = "/";
    private static final String DEFAULT_PATH_SEPARATOR = "/";
    private static final int DEFAULT_TIMEOUT = 30;
    static final String TYPE = "type";
    static final String HOST = "host";
    static final String PORT = "port";
    static final String USER = "user";
    static final String PASSWORD = "password";
    static final String ANONYMOUS_LOGIN = "anonymousLogin";
    static final String INITIAL_DIRECTORY = "initialDirectory";
    static final String PATH_SEPARATOR = "pathSeparator";
    static final String TIMEOUT = "timeout";
    static final String PASSIVE_MODE = "passiveMode";
    static final String[] PROPERTIES = new String[]{"type", "host", "port", "user", "password", "anonymousLogin", "initialDirectory", "pathSeparator", "timeout", "passiveMode"};
    private final ConfigManager configManager;
    private final ConfigManager.ConfigProvider configProvider = new DefaultConfigProvider();
    private final ChangeListener defaultChangeListener = new DefaultChangeListener();
    RemoteConnectionsPanel panel = null;
    private DialogDescriptor descriptor = null;

    public static RemoteConnections get() {
        return new RemoteConnections();
    }

    private RemoteConnections() {
        this.configManager = new ConfigManager(this.configProvider);
    }

    private void initPanel() {
        if (this.panel != null) {
            return;
        }
        this.panel = new RemoteConnectionsPanel();
        this.panel.setConfigurations(this.getConfigurations());
        this.panel.addChangeListener(this.defaultChangeListener);
        this.panel.addAddButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteConnections.this.addConfig();
            }
        });
        this.panel.addRemoveButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteConnections.this.removeConfig();
            }
        });
        this.panel.addConfigListListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RemoteConnections.this.selectCurrentConfig();
            }
        });
    }

    public boolean openManager() {
        return this.openManager(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openManager(final RemoteConfiguration remoteConfiguration) {
        boolean bl;
        this.initPanel();
        String string = NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_ManageRemoteConnections");
        this.descriptor = new DialogDescriptor((Object)this.panel, string, true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (RemoteConnections.this.panel.getConfigurations().isEmpty()) {
                        RemoteConnections.this.addConfig();
                    } else if (remoteConfiguration != null) {
                        RemoteConnections.this.panel.selectConfiguration(remoteConfiguration.getName());
                    } else {
                        RemoteConnections.this.panel.selectConfiguration(0);
                    }
                }
            });
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        boolean bl2 = bl = this.descriptor.getValue() == NotifyDescriptor.OK_OPTION;
        if (bl) {
            this.saveRemoteConnections();
        }
        return bl;
    }

    public List<RemoteConfiguration> getRemoteConfigurations() {
        List<ConfigManager.Configuration> list = this.getConfigurations();
        ArrayList<RemoteConfiguration> arrayList = new ArrayList<RemoteConfiguration>(list.size());
        for (ConfigManager.Configuration configuration : list) {
            arrayList.add(new RemoteConfiguration(configuration));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public RemoteConfiguration remoteConfigurationForName(String string) {
        assert (string != null);
        for (RemoteConfiguration remoteConfiguration : this.getRemoteConfigurations()) {
            if (!remoteConfiguration.getName().equals(string)) continue;
            return remoteConfiguration;
        }
        return null;
    }

    private List<ConfigManager.Configuration> getConfigurations() {
        Collection<String> collection = this.configManager.configurationNames();
        ArrayList<ConfigManager.Configuration> arrayList = new ArrayList<ConfigManager.Configuration>(collection.size() - 1);
        for (String string : collection) {
            ConfigManager.Configuration configuration;
            if (string == null || (configuration = this.configManager.configurationFor(string)) == null) continue;
            arrayList.add(configuration);
        }
        Collections.sort(arrayList, ConfigManager.getConfigurationComparator());
        return arrayList;
    }

    void addConfig() {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage(RemoteConnections.class, (String)"LBL_ConnectionName"), NbBundle.getMessage(RemoteConnections.class, (String)"LBL_CreateNewConnection"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
            String string = inputLine.getInputText();
            String string2 = string.replaceAll("[^a-zA-Z0-9_.-]", "_");
            String string3 = null;
            if (string.trim().length() == 0) {
                string3 = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_EmptyConnectionExists");
            } else if (this.configManager.exists(string2)) {
                string3 = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_ConnectionExists", (Object)string2);
            }
            if (string3 != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 2));
                return;
            }
            ConfigManager.Configuration configuration = this.configManager.createNew(string2, string);
            configuration.putValue(PORT, String.valueOf(21));
            configuration.putValue(INITIAL_DIRECTORY, "/");
            configuration.putValue(PATH_SEPARATOR, "/");
            configuration.putValue(TIMEOUT, String.valueOf(30));
            this.panel.addConfiguration(configuration);
            this.configManager.markAsCurrentConfiguration(string2);
        }
    }

    void removeConfig() {
        assert (this.panel != null);
        ConfigManager.Configuration configuration = this.panel.getSelectedConfiguration();
        assert (configuration != null);
        this.configManager.configurationFor(configuration.getName()).delete();
        this.panel.removeConfiguration(configuration);
    }

    void selectCurrentConfig() {
        assert (this.panel != null);
        ConfigManager.Configuration configuration = this.panel.getSelectedConfiguration();
        this.panel.removeChangeListener(this.defaultChangeListener);
        this.panel.setEnabledFields(configuration != null);
        if (configuration != null) {
            this.configManager.markAsCurrentConfiguration(configuration.getName());
            this.panel.setConnectionName(configuration.getDisplayName());
            this.panel.setType(this.resolveType(configuration.getValue(TYPE)));
            this.panel.setHostName(configuration.getValue(HOST));
            this.panel.setPort(configuration.getValue(PORT));
            this.panel.setUserName(configuration.getValue(USER));
            this.panel.setPassword(configuration.getValue(PASSWORD, true));
            this.panel.setAnonymousLogin(this.resolveBoolean(configuration.getValue(ANONYMOUS_LOGIN)));
            this.panel.setInitialDirectory(configuration.getValue(INITIAL_DIRECTORY));
            this.panel.setTimeout(configuration.getValue(TIMEOUT));
            this.panel.setPassiveMode(this.resolveBoolean(configuration.getValue(PASSIVE_MODE)));
        } else {
            this.panel.resetFields();
        }
        this.panel.addChangeListener(this.defaultChangeListener);
        if (configuration != null) {
            this.validate();
        }
    }

    void validate() {
        assert (this.panel != null);
        if (this.validateRememberPassword()) {
            this.setWarning(null);
        }
        if (!this.validateHost()) {
            return;
        }
        if (!this.validatePort()) {
            return;
        }
        if (!this.validateUser()) {
            return;
        }
        if (!this.validateInitialDirectory()) {
            return;
        }
        if (!this.validateTimeout()) {
            return;
        }
        this.setError(null);
        this.checkAllTheConfigs();
    }

    private boolean validateHost() {
        if (this.panel.getHostName().trim().length() == 0) {
            this.setError(NbBundle.getMessage(RemoteConnections.class, (String)"MSG_NoHostName"));
            return false;
        }
        return true;
    }

    private boolean validatePort() {
        String string = null;
        try {
            int n = Integer.parseInt(this.panel.getPort());
            if (n < 1) {
                string = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_PortNotPositive");
            }
        }
        catch (NumberFormatException numberFormatException) {
            string = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_PortNotNumeric");
        }
        this.setError(string);
        return string == null;
    }

    private boolean validateUser() {
        if (this.panel.isAnonymousLogin()) {
            return true;
        }
        if (this.panel.getUserName().trim().length() == 0) {
            this.setError(NbBundle.getMessage(RemoteConnections.class, (String)"MSG_NoUserName"));
            return false;
        }
        return true;
    }

    private boolean validateInitialDirectory() {
        String string = RunAsValidator.validateUploadDirectory(this.panel.getInitialDirectory(), false);
        if (string != null) {
            this.setError(string);
            return false;
        }
        return true;
    }

    private boolean validateTimeout() {
        String string = null;
        try {
            int n = Integer.parseInt(this.panel.getTimeout());
            if (n < 0) {
                string = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_TimeoutNotPositive");
            }
        }
        catch (NumberFormatException numberFormatException) {
            string = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_TimeoutNotNumeric");
        }
        this.setError(string);
        return string == null;
    }

    private boolean validateRememberPassword() {
        if (this.panel.getPassword().length() > 0) {
            this.setWarning(NbBundle.getMessage(RemoteConnections.class, (String)"MSG_PasswordRememberDangerous"));
            return false;
        }
        return true;
    }

    private void checkAllTheConfigs() {
        for (ConfigManager.Configuration configuration : this.panel.getConfigurations()) {
            assert (configuration != null);
            if (configuration.isValid()) continue;
            this.panel.setError(NbBundle.getMessage(RemoteConnections.class, (String)"MSG_InvalidConfiguration", (Object)configuration.getDisplayName()));
            assert (this.descriptor != null);
            this.descriptor.setValid(false);
            return;
        }
    }

    private void setError(String string) {
        assert (this.panel != null);
        ConfigManager.Configuration configuration = this.panel.getSelectedConfiguration();
        configuration.setErrorMessage(string);
        this.panel.setError(string);
        assert (this.descriptor != null);
        this.descriptor.setValid(string == null);
    }

    private void setWarning(String string) {
        assert (this.panel != null);
        this.panel.setWarning(string);
    }

    private void updateActiveConfig() {
        assert (this.panel != null);
        ConfigManager.Configuration configuration = this.panel.getSelectedConfiguration();
        if (configuration == null) {
            return;
        }
        configuration.putValue(TYPE, this.panel.getType().name());
        configuration.putValue(HOST, this.panel.getHostName());
        configuration.putValue(PORT, this.panel.getPort());
        configuration.putValue(USER, this.panel.getUserName());
        configuration.putValue(PASSWORD, this.panel.getPassword(), true);
        configuration.putValue(ANONYMOUS_LOGIN, String.valueOf(this.panel.isAnonymousLogin()));
        configuration.putValue(INITIAL_DIRECTORY, this.panel.getInitialDirectory());
        configuration.putValue(PATH_SEPARATOR, "/");
        configuration.putValue(TIMEOUT, this.panel.getTimeout());
        configuration.putValue(PASSIVE_MODE, String.valueOf(this.panel.isPassiveMode()));
    }

    private void saveRemoteConnections() {
        Preferences preferences = NbPreferences.forModule(RemoteConnections.class).node(PREFERENCES_PATH);
        for (Map.Entry<String, Map<String, String>> entry : this.configProvider.getConfigs().entrySet()) {
            String string = entry.getKey();
            if (string == null) continue;
            Map<String, String> map = entry.getValue();
            if (map == null) {
                try {
                    preferences.node(string).removeNode();
                }
                catch (BackingStoreException backingStoreException) {
                    LOGGER.log(Level.INFO, "Error while removing unused remote connection: " + string, backingStoreException);
                }
                continue;
            }
            Preferences preferences2 = preferences.node(string);
            for (Map.Entry<String, String> entry2 : map.entrySet()) {
                preferences2.put(entry2.getKey(), entry2.getValue());
            }
        }
    }

    private ConnectionType resolveType(String string) {
        if (string == null) {
            return DEFAULT_TYPE;
        }
        ConnectionType connectionType = null;
        try {
            connectionType = ConnectionType.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            connectionType = DEFAULT_TYPE;
        }
        return connectionType;
    }

    private boolean resolveBoolean(String string) {
        return Boolean.valueOf(string);
    }

    private class DefaultChangeListener
    implements ChangeListener {
        private DefaultChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            RemoteConnections.this.updateActiveConfig();
            RemoteConnections.this.validate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultConfigProvider
    implements ConfigManager.ConfigProvider {
        final Map<String, Map<String, String>> configs = ConfigManager.createEmptyConfigs();

        public DefaultConfigProvider() {
            this.readConfigs();
        }

        @Override
        public String[] getConfigProperties() {
            return PROPERTIES;
        }

        @Override
        public Map<String, Map<String, String>> getConfigs() {
            return this.configs;
        }

        @Override
        public String getActiveConfig() {
            return null;
        }

        @Override
        public void setActiveConfig(String string) {
        }

        private void readConfigs() {
            Preferences preferences = NbPreferences.forModule(RemoteConnections.class).node(RemoteConnections.PREFERENCES_PATH);
            try {
                for (String string : preferences.childrenNames()) {
                    Preferences preferences2 = preferences.node(string);
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (String string2 : preferences2.keys()) {
                        treeMap.put(string2, preferences2.get(string2, null));
                    }
                    this.configs.put(string, treeMap);
                }
            }
            catch (BackingStoreException backingStoreException) {
                LOGGER.log(Level.INFO, "Error while reading existing remote connections", backingStoreException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        FTP("LBL_Ftp");

        private final String label;

        private ConnectionType(String string2) {
            this.label = NbBundle.getMessage(RemoteConnections.class, (String)string2);
        }

        public String getLabel() {
            return this.label;
        }
    }
}

