/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathFactory;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathProvider;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.php.project.PhpSources;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.php.project.classpath.CommonPhpSourcePath;
import org.netbeans.modules.php.project.classpath.PhpSourcePathImplementation;
import org.netbeans.modules.php.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassPathProviderImpl
implements ClassPathProvider,
PhpSourcePathImplementation,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final PhpSources sourceRoots;
    private final Map<String, List<FileObject>> dirCache = new HashMap<String, List<FileObject>>();
    private final Map<ClassPathCache, ClassPath> cache = new EnumMap<ClassPathCache, ClassPath>(ClassPathCache.class);

    public ClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, PhpSources phpSources) {
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = propertyEvaluator;
        this.sourceRoots = phpSources;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    private synchronized List<FileObject> getDirs(String string) {
        List<FileObject> list = this.dirCache.get(string);
        if (!this.checkDirs(list)) {
            String string2 = this.evaluator.getProperty(string);
            if (string2 == null) {
                return Collections.emptyList();
            }
            String[] stringArray = PropertyUtils.tokenizePath((String)string2);
            list = new ArrayList<FileObject>(stringArray.length);
            for (String string3 : stringArray) {
                FileObject fileObject = this.helper.resolveFileObject(string3);
                if (fileObject == null) continue;
                list.add(fileObject);
            }
            this.dirCache.put(string, list);
        }
        return list;
    }

    private boolean checkDirs(List<FileObject> list) {
        if (list == null) {
            return false;
        }
        for (FileObject fileObject : list) {
            if (fileObject.isValid()) continue;
            return false;
        }
        return true;
    }

    private List<FileObject> getPlatformPath() {
        return this.getDirs("include.path");
    }

    private FileObject getSrcPath() {
        List<FileObject> list = this.getDirs("src.dir");
        if (list.size() == 0) {
            return null;
        }
        assert (list.size() == 1);
        return list.get(0);
    }

    @Override
    public PhpSourcePath.FileType getFileType(FileObject fileObject) {
        Parameters.notNull((CharSequence)"file", (Object)fileObject);
        for (FileObject fileObject2 : CommonPhpSourcePath.getInternalPath()) {
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return PhpSourcePath.FileType.INTERNAL;
        }
        for (FileObject fileObject2 : this.getPlatformPath()) {
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return PhpSourcePath.FileType.INCLUDE;
        }
        FileObject fileObject3 = this.getSrcPath();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return PhpSourcePath.FileType.SOURCE;
        }
        return PhpSourcePath.FileType.UNKNOWN;
    }

    @Override
    public List<FileObject> getIncludePath() {
        return new ArrayList<FileObject>(this.getPlatformPath());
    }

    @Override
    public FileObject resolveFile(FileObject fileObject, String string) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            return fileObject2;
        }
        for (FileObject fileObject3 : this.getPlatformPath()) {
            fileObject2 = fileObject3.getFileObject(string);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return null;
    }

    private ClassPath getSourcePath(FileObject fileObject) {
        return this.getSourcePath(this.getFileType(fileObject));
    }

    private synchronized ClassPath getSourcePath(PhpSourcePath.FileType fileType) {
        ClassPath classPath = null;
        switch (fileType) {
            case SOURCE: {
                classPath = this.cache.get((Object)ClassPathCache.SOURCE);
                if (classPath != null) break;
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation(this.projectDirectory, this.evaluator, new String[]{"src.dir"}));
                this.cache.put(ClassPathCache.SOURCE, classPath);
                break;
            }
        }
        return classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getBootClassPath() {
        ClassPath classPath;
        PhpOptions.getInstance().getPhpGlobalIncludePath();
        ClassPathProviderImpl classPathProviderImpl = this;
        synchronized (classPathProviderImpl) {
            classPath = this.cache.get((Object)ClassPathCache.PLATFORM);
            if (classPath == null) {
                List<FileObject> list = CommonPhpSourcePath.getInternalPath();
                ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])list.toArray(new FileObject[list.size()]));
                ClassPath classPath3 = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation(this.projectDirectory, this.evaluator, new String[]{"include.path"}));
                classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath2, classPath3});
                this.cache.put(ClassPathCache.PLATFORM, classPath);
            }
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        if (string.equals("classpath/source")) {
            return this.getSourcePath(fileObject);
        }
        if (string.equals("classpath/compile")) {
            return this.getBootClassPath();
        }
        if (string.equals("js/library")) {
            return this.getSourcePath(PhpSourcePath.FileType.SOURCE);
        }
        assert (false) : "Unknown classpath type requested: " + string;
        return null;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/boot".equals(string)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/source".equals(string)) {
            return new ClassPath[]{this.getSourcePath(PhpSourcePath.FileType.SOURCE)};
        }
        assert (false) : "Unknown classpath type requested: " + string;
        return null;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.dirCache.remove(propertyChangeEvent.getPropertyName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ClassPathCache {
        PLATFORM,
        SOURCE;

    }
}

