/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.model.impl.BpelEntityImpl;
import org.netbeans.modules.bpel.model.impl.services.InnerEventDispatcherAdapter;
import org.netbeans.modules.bpel.model.impl.services.MarkBuilderElement;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xpath.ext.schema.ExNamespaceContext;
import org.netbeans.modules.xml.xpath.ext.schema.InvalidNamespaceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceOptimizer
extends InnerEventDispatcherAdapter {
    static final String XMLNS = "xmlns";
    private ThreadLocal<Set<ChangeEvent>> mySet = new ThreadLocal();

    @Override
    public boolean isApplicable(ChangeEvent changeEvent) {
        boolean bl;
        boolean bl2 = bl = changeEvent instanceof EntityInsertEvent || changeEvent instanceof EntityUpdateEvent || changeEvent instanceof ArrayUpdateEvent;
        if (!bl) {
            return false;
        }
        if (changeEvent.getParent().getBpelModel().inSync()) {
            return false;
        }
        return ((BpelEntityImpl)changeEvent.getParent()).isInTree();
    }

    @Override
    public void preDispatch(ChangeEvent changeEvent) {
        BpelEntity bpelEntity = this.getSingleEntity(changeEvent);
        BpelEntity[] bpelEntityArray = this.getEntityArray(changeEvent);
        if (bpelEntity != null) {
            if (!this.isMarked(bpelEntity)) {
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.removeExistedNamespaces(bpelEntity, changeEvent.getParent(), hashMap);
            this.addEvent(changeEvent);
        } else if (bpelEntityArray != null) {
            for (BpelEntity bpelEntity2 : bpelEntityArray) {
                if (!this.isMarked(bpelEntity)) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                this.removeExistedNamespaces(bpelEntity2, changeEvent.getParent(), hashMap);
            }
            this.addEvent(changeEvent);
        }
    }

    @Override
    public void postDispatch(ChangeEvent changeEvent) {
        if (this.mySet.get() == null || !this.mySet.get().remove(changeEvent)) {
            return;
        }
        BpelEntity bpelEntity = this.getSingleEntity(changeEvent);
        BpelEntity[] bpelEntityArray = this.getEntityArray(changeEvent);
        if (bpelEntity != null) {
            this.moveNSDeclarationToRoot(bpelEntity, new HashMap<String, String>());
        } else if (bpelEntityArray != null) {
            for (BpelEntity bpelEntity2 : bpelEntityArray) {
                this.moveNSDeclarationToRoot(bpelEntity2, new HashMap<String, String>());
            }
        }
    }

    @Override
    public void reset(ChangeEvent changeEvent) {
        Set<ChangeEvent> set = this.mySet.get();
        if (set != null) {
            set.remove(changeEvent);
        }
    }

    private void addEvent(ChangeEvent changeEvent) {
        Set<ChangeEvent> set = this.mySet.get();
        if (set == null) {
            set = new HashSet<ChangeEvent>();
            this.mySet.set(set);
        }
        set.add(changeEvent);
    }

    private BpelEntity getSingleEntity(ChangeEvent changeEvent) {
        BpelEntity bpelEntity = null;
        if (changeEvent instanceof EntityInsertEvent) {
            bpelEntity = (BpelEntity)((EntityInsertEvent)changeEvent).getValue();
        } else if (changeEvent instanceof EntityUpdateEvent) {
            bpelEntity = (BpelEntity)((EntityUpdateEvent)changeEvent).getNewValue();
        }
        return bpelEntity;
    }

    private BpelEntity[] getEntityArray(ChangeEvent changeEvent) {
        BpelEntity[] bpelEntityArray = null;
        if (changeEvent instanceof ArrayUpdateEvent) {
            bpelEntityArray = ((ArrayUpdateEvent)changeEvent).getNewArray();
        }
        return bpelEntityArray;
    }

    private void removeExistedNamespaces(BpelEntity bpelEntity, BpelEntity bpelEntity2, Map<String, String> map) {
        if (!(bpelEntity instanceof BpelEntityImpl)) {
            return;
        }
        if (bpelEntity2 == null) {
            return;
        }
        Element element = ((BpelEntityImpl)bpelEntity).getPeer();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Object object = namedNodeMap.item(i);
            assert (object instanceof Attr);
            Attr attr = (Attr)object;
            if (attr.getValue() == null) continue;
            this.handleNsAttribute(bpelEntity, bpelEntity2, map, attr);
        }
        this.updatePrefixes(bpelEntity, map);
        for (Object object : bpelEntity.getChildren()) {
            this.removeExistedNamespaces((BpelEntity)object, bpelEntity2, map);
        }
    }

    private void handleNsAttribute(BpelEntity bpelEntity, BpelEntity bpelEntity2, Map<String, String> map, Attr attr) {
        String string = attr.getValue();
        if (XMLNS.equals(attr.getName()) || XMLNS.equals(attr.getPrefix())) {
            if (string.equals(bpelEntity.getPeer().getNamespaceURI())) {
                return;
            }
            ExNamespaceContext exNamespaceContext = bpelEntity2.getNamespaceContext();
            Iterator iterator = exNamespaceContext.getPrefixes();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = exNamespaceContext.getNamespaceURI(string2);
                if (!string.equals(string3)) continue;
                String string4 = attr.getLocalName();
                if (!string4.equals(string2)) {
                    map.put(string4, string2);
                }
                ((BpelEntityImpl)bpelEntity).setAttribute(attr.getName(), (Attribute)new AbstractDocumentComponent.PrefixAttribute(attr.getName()), null);
            }
        }
    }

    private void updatePrefixes(BpelEntity bpelEntity, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Attribute[] attributeArray;
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (XMLNS.equals(string) && string2 == null) continue;
            for (Attribute attribute : attributeArray = ((BpelEntityImpl)bpelEntity).getDomainAttributes()) {
                this.updatePrefixInAttribute(bpelEntity, string, string2, attribute);
            }
        }
    }

    private void updatePrefixInAttribute(BpelEntity bpelEntity, String string, String string2, Attribute attribute) {
        if (bpelEntity.getAttribute(attribute) == null) {
            return;
        }
        if (!Utils.canUpdatePrefix(attribute)) {
            return;
        }
        Class clazz = attribute.getType();
        if (QName.class.isAssignableFrom(clazz) || Referenceable.class.isAssignableFrom(clazz)) {
            String string3 = this.getUpdatedReferenceAttribute(bpelEntity, bpelEntity.getAttribute(attribute), string, string2);
            if (string3 == null) {
                return;
            }
            ((BpelEntityImpl)bpelEntity).setAttribute(attribute.getName(), attribute, string3);
        } else if (List.class.isAssignableFrom(clazz) && Referenceable.class.isAssignableFrom(attribute.getMemberType())) {
            this.updateListAttribute(bpelEntity, string, string2, attribute);
        }
    }

    private void updateListAttribute(BpelEntity bpelEntity, String string, String string2, Attribute attribute) {
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(bpelEntity.getAttribute(attribute), " ");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            String string4 = this.getUpdatedReferenceAttribute(bpelEntity, string3, string, string2);
            if (string4 == null) {
                stringBuilder.append(string3);
                stringBuilder.append(" ");
                continue;
            }
            bl = true;
            stringBuilder.append(string4);
            stringBuilder.append(" ");
        }
        if (!bl) {
            return;
        }
        string3 = null;
        if (stringBuilder.length() > 0) {
            string3 = stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        if (string3 != null) {
            ((BpelEntityImpl)bpelEntity).setAttribute(attribute.getName(), attribute, string3);
        }
    }

    private String getUpdatedReferenceAttribute(BpelEntity bpelEntity, String string, String string2, String string3) {
        int n = string.indexOf(":");
        if (n == string.length() - 1) {
            return null;
        }
        if (n == -1 && XMLNS.equals(string2)) {
            return string3 + ":" + string;
        }
        if (XMLNS.equals(string2)) {
            return null;
        }
        if (string.startsWith(string2 + ":")) {
            return string3 + ":" + string.substring(n + 1);
        }
        return null;
    }

    private void moveNSDeclarationToRoot(BpelEntity bpelEntity, Map<String, String> map) {
        if (!(bpelEntity instanceof BpelEntityImpl)) {
            return;
        }
        Element element = ((BpelEntityImpl)bpelEntity).getPeer();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Object object = namedNodeMap.item(i);
            assert (object instanceof Attr);
            Attr attr = (Attr)object;
            if (attr.getValue() == null) continue;
            try {
                SingletonMap singletonMap;
                if (!XMLNS.equals(attr.getName()) && !XMLNS.equals(attr.getPrefix()) || (singletonMap = this.moveNsDeclaration(bpelEntity, attr)).keyEqualsValue()) continue;
                map.put(singletonMap.getKey(), singletonMap.getValue());
                continue;
            }
            catch (InvalidNamespaceException invalidNamespaceException) {
                // empty catch block
            }
        }
        this.updatePrefixes(bpelEntity, map);
        for (Object object : bpelEntity.getChildren()) {
            this.moveNSDeclarationToRoot((BpelEntity)object, map);
        }
    }

    private SingletonMap moveNsDeclaration(BpelEntity bpelEntity, Attr attr) throws InvalidNamespaceException {
        String string;
        String string2 = attr.getValue();
        ExNamespaceContext exNamespaceContext = bpelEntity.getNamespaceContext();
        exNamespaceContext.addNamespace(string2);
        ((BpelEntityImpl)bpelEntity).setAttribute(attr.getName(), (Attribute)new AbstractDocumentComponent.PrefixAttribute(attr.getName()), null);
        String string3 = attr.getLocalName();
        Iterator iterator = exNamespaceContext.getPrefixes();
        boolean bl = true;
        while (iterator.hasNext() && string3 != null) {
            string = (String)iterator.next();
            if (!string3.equals(string)) continue;
            bl = false;
        }
        string = null;
        if (XMLNS.equals(attr.getName()) || string3 == null || !bl) {
            string = exNamespaceContext.addNamespace(attr.getValue());
        } else {
            string = string3;
            exNamespaceContext.addNamespace(string3, attr.getValue());
        }
        return new SingletonMap(string3, string);
    }

    private boolean isMarked(BpelEntity bpelEntity) {
        Set<Object> set = ((BpelEntityImpl)bpelEntity).getCookies().keySet();
        for (Object object : set) {
            if (object == null || !object.getClass().getCanonicalName().equals(MarkBuilderElement.CLASS_MARK_NAME)) continue;
            return true;
        }
        return false;
    }

    private static final class SingletonMap {
        private String myKey;
        private String myValue;

        SingletonMap(String string, String string2) {
            this.myKey = string;
            this.myValue = string2;
        }

        String getKey() {
            return this.myKey;
        }

        String getValue() {
            return this.myValue;
        }

        boolean keyEqualsValue() {
            if (this.myKey == null) {
                return this.myValue == null;
            }
            return this.myKey.equals(this.myValue);
        }
    }
}

