/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.spi.EntityFactory;
import org.netbeans.modules.bpel.model.xam.BpelElements;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EntityFactoryRegistry {
    private static final EntityFactoryRegistry INSTANCE = new EntityFactoryRegistry();
    private Collection<EntityFactory> myFactories = new LinkedList<EntityFactory>();
    private Set<QName> myAllQNames = new HashSet<QName>(BpelElements.allQNames());
    private Set<QName> myExtensionsQNames = new HashSet<QName>();

    private EntityFactoryRegistry() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(EntityFactory.class));
        for (EntityFactory entityFactory : result.allInstances()) {
            this.myFactories.add(entityFactory);
            this.myAllQNames.addAll(entityFactory.getElementQNames());
            this.myExtensionsQNames.addAll(entityFactory.getElementQNames());
        }
    }

    public static EntityFactoryRegistry getInstance() {
        return INSTANCE;
    }

    public Collection<EntityFactory> getFactories() {
        return Collections.unmodifiableCollection(this.myFactories);
    }

    public Set<QName> getAllQNames() {
        return Collections.unmodifiableSet(this.myAllQNames);
    }

    public Set<QName> getExtensionsQNames() {
        return Collections.unmodifiableSet(this.myExtensionsQNames);
    }
}

