/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.markup;

import com.sun.faces.util.HtmlUtils;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.util.EncodingMap;
import org.apache.xml.serialize.OutputFormat;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.extension.openide.util.Trace;
import org.netbeans.modules.visualweb.insync.InSyncServiceProvider;
import org.netbeans.modules.visualweb.insync.ParserAnnotation;
import org.netbeans.modules.visualweb.insync.SourceUnit;
import org.netbeans.modules.visualweb.insync.UndoManager;
import org.netbeans.modules.visualweb.insync.Util;
import org.netbeans.modules.visualweb.insync.markup.JspxSerializer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MarkupUnit
extends SourceUnit
implements EventListener {
    public static final int ALLOW_XML = 1;
    public static final int ALLOW_HTML = 2;
    int flags;
    private Document sourceDocument;
    private Document renderedDocument;
    HashMap namespaces = new HashMap();
    Map<String, String> namespaceUriMap = new HashMap<String, String>();
    URI baseURI;
    URL base;
    private boolean supportCss;
    protected EventTarget registeredAsEventListenerOn;
    private ParserAnnotation error;
    static final String BLANK = "                                                                                                                        ";
    private final Object LOCK_RENDERED_DOCUMENT = new Object();
    private static final Map element2markupDesignBean = new WeakHashMap(200);
    public static final String DOM_SUBTREE_MODIFIED = "DOMSubtreeModified";
    public static final String DOM_NODE_INSERTED = "DOMNodeInserted";
    public static final String DOM_NODE_REMOVED = "DOMNodeRemoved";
    public static final String DOM_NODE_REMOVED_FROM_DOCUMENT = "DOMNodeRemovedFromDocument";
    public static final String DOM_NODE_INSERTED_INTO_DOCUMENT = "DOMNodeInsertedIntoDocument";
    public static final String DOM_ATTR_MODIFIED = "DOMAttrModified";
    public static final String DOM_CHARACTER_DATA_MODIFIED = "DOMCharacterDataModified";
    public static final String DOM_DOCUMENT_REPLACED = "DOMDocumentReplaced";
    private static final Map<Document, MarkupUnit> doc2markupUnit = new WeakHashMap<Document, MarkupUnit>();
    private static final Map<Document, URL> doc2url = new WeakHashMap<Document, URL>();

    public MarkupUnit(FileObject fileObject, int n, boolean bl, UndoManager undoManager) {
        super(fileObject, undoManager);
        this.flags = n;
        this.supportCss = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.namespaces.clear();
        this.namespaceUriMap.clear();
        this.base = null;
        this.baseURI = null;
        CssProvider.getEngineService().removeCssEngineForDocument(this.renderedDocument);
        Object object = this.LOCK_RENDERED_DOCUMENT;
        synchronized (object) {
            this.renderedDocument = null;
        }
        this.sourceDocument = null;
        this.unregisterDomListeners();
        super.destroy();
    }

    public static Element ensureRoot(Document document, String string) {
        Element element = document.getDocumentElement();
        if (element == null) {
            element = document.createElement(string);
            document.appendChild(element);
            Trace.trace((String)"insync.markup", (String)("MU ensure created root " + element));
        } else {
            Trace.trace((String)"insync.markup", (String)("MU ensure found root " + element));
        }
        return element;
    }

    public static Element ensureElement(Element element, String string, Element element2) {
        Element element3 = MarkupUnit.getFirstDescendantElement(element, string);
        if (element3 == null) {
            Element element4;
            Document document = element.getOwnerDocument();
            element3 = document.createElement(string);
            Element element5 = element4 = element2 != null ? MarkupUnit.getNextSiblingElement(element2) : MarkupUnit.getFirstChildElement(element);
            if (element4 != null) {
                element.insertBefore(element3, element4);
            } else {
                element.appendChild(element3);
            }
            Trace.trace((String)"insync.markup", (String)("MU scan created " + element3 + " under " + element + " before " + element4));
        } else {
            Trace.trace((String)"insync.markup", (String)("MU scan found " + element3 + " under " + element3.getParentNode()));
        }
        return element3;
    }

    public Element addElement(Element element, Node node, String string, String string2, String string3) {
        String string4 = string != null && string.length() > 0 ? this.getNamespacePrefix(string, string2) + ":" : "";
        Element element2 = this.sourceDocument.createElementNS(string, string4 + string3);
        if (element != null) {
            if (node != null) {
                element.insertBefore(element2, node);
            } else {
                element.appendChild(element2);
            }
        } else {
            this.sourceDocument.appendChild(element2);
        }
        return element2;
    }

    public void ensureAttributeExists(Element element, String string, String string2) {
        if (element.getAttributeNode(string) == null) {
            this.ensureAttributeValue(element, string, string2);
        }
    }

    public void ensureAttributeValue(Element element, String string, String string2) {
        if (!element.getAttribute(string).equals(string2)) {
            element.setAttribute(string, string2);
            if (element == this.sourceDocument.getDocumentElement() && string.startsWith("xmlns:")) {
                String string3 = string.substring(6);
                this.namespaces.put(string2, string3);
                this.namespaceUriMap.put(string3, string2);
            }
        }
    }

    public static Element getFirstDescendantElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() >= 1) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static Element getDescendantElementByAttr(Element element, String string, String string2, String string3) {
        NodeList nodeList = element.getElementsByTagName(string);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute(string2).equals(string3)) continue;
            return element2;
        }
        return null;
    }

    public static boolean isDescendent(Node node, Node node2) {
        while (node2 != null) {
            if (node2 == node) {
                return true;
            }
            node2 = node2.getParentNode();
        }
        return false;
    }

    public static Element getFirstChildElement(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!(node2 instanceof Element)) continue;
            return (Element)node2;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node) {
        for (Node node2 = node.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
            if (!(node2 instanceof Element)) continue;
            return (Element)node2;
        }
        return null;
    }

    public static String getElementText(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Text)) continue;
            stringBuffer.append(((Text)node).getData());
        }
        return stringBuffer.toString();
    }

    public static void setElementText(Element element, String string) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Text)) continue;
            element.removeChild(node);
        }
        if (string != null) {
            element.appendChild(element.getOwnerDocument().createTextNode(string));
        }
    }

    public String findTaglibUri(String string) {
        return this.namespaceUriMap.get(string);
    }

    private Document parseDom(InputSource inputSource) {
        try {
            Document document;
            DocumentBuilder documentBuilder = MarkupService.createRaveSourceDocumentBuilder((boolean)this.supportCss);
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException sAXParseException) {
                    MarkupUnit.this.addError(sAXParseException, true);
                }

                public void fatalError(SAXParseException sAXParseException) {
                    MarkupUnit.this.addError(sAXParseException, true);
                }

                public void warning(SAXParseException sAXParseException) {
                    MarkupUnit.this.addError(sAXParseException, false);
                }
            });
            documentBuilder.setEntityResolver(new XhtmlEntityResolver());
            Trace.trace((String)"insync.markup", (String)("DOM Parsing: " + this.getName()));
            Trace.flush();
            Document document2 = document = documentBuilder.parse(inputSource);
            MarkupUnit.setMarkupUnitForDocument(document2, this);
            String string = this.getEncoding();
            String string2 = document2.getXmlEncoding();
            if (string != null && string.length() > 0) {
                if (string2 == null || string2.length() == 0) {
                    MarkupService.setInputEncodingForDocument((Document)document2, (String)string);
                }
            } else if (string2 != null && string2.length() > 0) {
                string = string2;
            }
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Trace.trace((String)"insync.markup", (String)("DOM Parsing: " + this.getName()));
            Trace.trace((String)"insync.markup", (Throwable)parserConfigurationException);
            this.setBusted();
        }
        catch (SAXException sAXException) {
            Trace.trace((String)"insync.markup", (String)("DOM Parsing: " + this.getName()));
            Trace.trace((String)"insync.markup", (Throwable)sAXException);
            this.setBusted();
        }
        catch (IOException iOException) {
            Trace.trace((String)"insync.markup", (String)("DOM Parsing: " + this.getName()));
            Trace.trace((String)"insync.markup", (Throwable)iOException);
            this.setBusted();
        }
        return null;
    }

    private void resetErrors() {
        this.error = null;
    }

    private void addError(SAXParseException sAXParseException, boolean bl) {
        int n;
        String string = sAXParseException.getMessage();
        int n2 = sAXParseException.getLineNumber();
        if (n2 < 0) {
            n2 = 1;
        }
        if ((n = sAXParseException.getColumnNumber()) < 0) {
            n = 0;
        }
        this.error = new ParserAnnotation(string, this.fobj, n2, n);
        if (bl) {
            this.setBusted();
        }
    }

    public ParserAnnotation[] getErrors() {
        if (this.error != null) {
            return new ParserAnnotation[]{this.error};
        }
        return ParserAnnotation.EMPTY_ARRAY;
    }

    protected void read(char[] cArray, int n) {
        Trace.trace((String)"insync.markup", (String)"MU.read");
        Document document = this.sourceDocument;
        Document document2 = null;
        InSyncServiceProvider.get().getRaveErrorHandler().clearErrors(true);
        this.resetErrors();
        this.base = null;
        this.baseURI = null;
        InputSource inputSource = new InputSource(new CharArrayReader(cArray, 0, n));
        inputSource.setSystemId(this.getName());
        if ((this.flags & 1) != 0 && (document2 = this.parseDom(inputSource)) == null) {
            inputSource = new InputSource(new CharArrayReader(cArray, 0, n));
            inputSource.setSystemId(this.getName());
        }
        if (this.getState().isBusted()) {
            return;
        }
        this.sourceDocument = document2;
        if (this.sourceDocument.getDocumentElement() != null) {
            MarkupService.markJspxSource((Node)this.sourceDocument.getDocumentElement());
        }
        if (this.supportCss) {
            this.syncEngine();
        }
        if (this.getState().isBusted()) {
            this.sourceDocument = document;
            return;
        }
        this.unregisterDomListeners();
        this.sourceDocument = document2;
        MarkupUnit.setMarkupUnitForDocument(this.getRenderedDom(), this);
        if (this.sourceDocument != null) {
            this.registerDomListeners(this.sourceDocument);
            Element element = this.sourceDocument.getDocumentElement();
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!attr.getName().startsWith("xmlns:")) continue;
                String string = attr.getName().substring(6);
                this.namespaces.put(attr.getValue(), string);
                this.namespaceUriMap.put(string, attr.getValue());
            }
        }
        if (document != null) {
            this.fireDocumentReplaced(document);
        }
    }

    private void syncEngine() {
        Document document = this.sourceDocument;
        MarkupUnit.setUrlForDocument(document, this.getBase());
        CssProvider.getEngineService().createCssEngineForDocument(document, MarkupUnit.getUrlForDocument(document));
    }

    public static String getIanaEncoding(String string) {
        if (string != null) {
            String string2 = string.toUpperCase(Locale.ENGLISH);
            if (EncodingMap.getIANA2JavaMapping((String)string2) != null) {
                return string;
            }
            String string3 = EncodingMap.getJava2IANAMapping((String)string2);
            if (string3 != null) {
                return string3;
            }
        }
        return "UTF-8";
    }

    public String getEncoding() {
        Charset charset = FileEncodingQuery.getEncoding((FileObject)this.fobj);
        return charset == null ? null : charset.name();
    }

    public void indent(PrintWriter printWriter, int n) {
        printWriter.print(BLANK.substring(0, n * 4));
    }

    public void dump(Node node, PrintWriter printWriter, int n) {
        this.indent(printWriter, n);
        if (node instanceof Element) {
            printWriter.println("E lname:" + node.getLocalName());
        } else {
            printWriter.println(node.getClass().getName() + " lname:" + node.getLocalName());
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.dump(node2, printWriter, n + 1);
        }
    }

    public void dumpTo(PrintWriter printWriter) {
        if (this.sourceDocument != null) {
            this.dump(this.sourceDocument, printWriter, 0);
        }
    }

    public OutputFormat getOutputFormat() {
        String string = MarkupUnit.getIanaEncoding(this.getEncoding());
        OutputFormat outputFormat = new OutputFormat(this.sourceDocument, string, true);
        outputFormat.setLineWidth(160);
        outputFormat.setIndent(4);
        outputFormat.setAllowJavaNames(true);
        return outputFormat;
    }

    public void writeTo(Writer writer) throws IOException {
        OutputFormat outputFormat = this.getOutputFormat();
        JspxSerializer jspxSerializer = new JspxSerializer(writer, outputFormat);
        jspxSerializer.serialize(this.sourceDocument);
    }

    public Document getSourceDom() {
        return this.sourceDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getRenderedDom() {
        boolean bl = false;
        Object object = this.LOCK_RENDERED_DOCUMENT;
        synchronized (object) {
            if (this.renderedDocument == null) {
                this.renderedDocument = MarkupUnit.createEmptyRenderedDocument();
                bl = true;
            }
        }
        if (bl) {
            this.initRenderedDocument();
        }
        return this.renderedDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRenderedDocument() {
        Document document;
        Object object = this.LOCK_RENDERED_DOCUMENT;
        synchronized (object) {
            document = this.renderedDocument;
        }
        MarkupUnit.setUrlForDocument(document, this.getBase());
        CssProvider.getEngineService().createCssEngineForDocument(document, MarkupUnit.getUrlForDocument(document));
    }

    private static Document createEmptyRenderedDocument() {
        try {
            InputSource inputSource = new InputSource(new StringReader("<html></html>"));
            DocumentBuilder documentBuilder = MarkupService.createRaveRenderedDocumentBuilder((boolean)true);
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return null;
    }

    public String getNamespacePrefix(String string, String string2) {
        String string3 = (String)this.namespaces.get(string);
        if (string3 != null) {
            return string3;
        }
        Collection collection = this.namespaces.values();
        if (string2 != null && !collection.contains(string2)) {
            string3 = string2;
        } else {
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                int n2 = 1;
                while (n + 1 + n2 < string.length()) {
                    String string4 = string.substring(n + 1, n + 1 + n2);
                    if (!collection.contains(string4)) {
                        string3 = string4;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (string3 != null) {
            Element element = this.sourceDocument.getDocumentElement();
            this.ensureAttributeValue(element, "xmlns:" + string3, string);
        }
        return string3;
    }

    public URI getBaseURI() {
        if (this.baseURI == null) {
            if (this.base == null) {
                this.base = this.getBase();
            } else {
                try {
                    this.baseURI = new URI(this.base.toExternalForm());
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.baseURI = null;
                }
            }
        }
        return this.baseURI;
    }

    public URL getBase() {
        if (this.base == null) {
            String string;
            Element element;
            Element element2;
            Element element3 = this.sourceDocument.getDocumentElement();
            Element element4 = this.findHtmlTag(element3);
            if (element4 != null && (element2 = Util.findChild("head", element4, false)) != null && (element = Util.findChild("base", element2, false)) != null && (string = element.getAttribute("href")) != null && string.length() > 0) {
                try {
                    try {
                        this.baseURI = new URI(string);
                        this.base = this.baseURI.toURL();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        this.base = new URL(string);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
                }
                if (this.base != null) {
                    return this.base;
                }
            }
            if (this.fobj == null) {
                return null;
            }
            try {
                element2 = this.fobj.getParent();
                this.baseURI = FileUtil.toFile((FileObject)element2).toURI();
                this.base = this.baseURI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        }
        return this.base;
    }

    public static String toURL(String string) {
        string = string.replace('\\', '/');
        string = string.replaceAll(" ", "%20");
        StringWriter stringWriter = new StringWriter();
        try {
            HtmlUtils.writeURL((Writer)stringWriter, (String)string, null, null);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return string;
        }
        return stringWriter.toString();
    }

    public boolean isHtmlOnly() {
        if (this.sourceDocument == null) {
            return false;
        }
        Element element = this.sourceDocument.getDocumentElement();
        Element element2 = this.findHtmlTag(element);
        if (element2 == null) {
            Thread.dumpStack();
            return false;
        }
        Element element3 = Util.findChild("head", element2, true);
        if (element3 == null) {
            return false;
        }
        NodeList nodeList = element3.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element4;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"meta".equals((element4 = (Element)node).getTagName()) || !"creator.webform".equalsIgnoreCase(element4.getAttribute("name"))) continue;
            String string = element4.getAttribute("content");
            return string != null && string.equals("no");
        }
        return false;
    }

    public void markHtmlOnly() {
        assert (!this.isHtmlOnly());
        Element element = this.sourceDocument.getDocumentElement();
        Element element2 = this.findHtmlTag(element);
        if (element2 == null) {
            Thread.dumpStack();
            return;
        }
        Element element3 = MarkupUnit.ensureElement(element2, "head", null);
        Element element4 = MarkupUnit.ensureElement(element3, "meta", null);
        element4.setAttribute("content", "no");
        element4.setAttribute("name", "creator.webform");
    }

    public Element findHtmlTag(Node node) {
        Object object;
        if (node.getNodeType() == 1 && "html".equals((object = (Element)node).getTagName())) {
            return object;
        }
        object = node.getChildNodes();
        int n = object.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = object.item(i);
            Element element = this.findHtmlTag(node2);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document createDocument(Document document, final String string) {
        String string2 = "<!DOCTYPE html \nPUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"\"><fake-root>" + string + "</fake-root>";
        InputSource inputSource = new InputSource(new StringReader(string2));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
            DocumentBuilder documentBuilder = MarkupService.createRaveSourceDocumentBuilder((boolean)this.supportCss);
            documentBuilder.setEntityResolver(new XhtmlEntityResolver());
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException sAXParseException) {
                    MarkupUnit.this.fragmentError(sAXParseException, true, string);
                }

                public void fatalError(SAXParseException sAXParseException) {
                    MarkupUnit.this.fragmentError(sAXParseException, true, string);
                }

                public void warning(SAXParseException sAXParseException) {
                    MarkupUnit.this.fragmentError(sAXParseException, false, string);
                }
            });
            Document document2 = documentBuilder.parse(inputSource);
            MarkupUnit.setMarkupUnitForDocument(document2, this);
            CssProvider.getEngineService().reuseCssEngineForDocument(document2, document);
            Document document3 = document2;
            Thread.currentThread().setContextClassLoader(classLoader);
            return document3;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
        }
        return null;
    }

    private void fragmentError(SAXParseException sAXParseException, boolean bl, String string) {
        String string2 = sAXParseException.getMessage();
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        if (string.length() > 80) {
            string = string.substring(0, 80) + "...";
        }
        String string3 = n + ":" + n2 + ": " + string2 + ": " + string;
        InputOutput inputOutput = IOProvider.getDefault().getIO(NbBundle.getMessage(MarkupUnit.class, (String)"WindowTitle"), false);
        OutputWriter outputWriter = inputOutput.getOut();
        try {
            outputWriter.reset();
            outputWriter.println(string3, new OutputListener(){

                public void outputLineSelected(OutputEvent outputEvent) {
                }

                public void outputLineAction(OutputEvent outputEvent) {
                }

                public void outputLineCleared(OutputEvent outputEvent) {
                }
            });
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void appendParsedString(Node node, String string, MarkupDesignBean markupDesignBean) {
        Document document = node.getOwnerDocument();
        if (string.startsWith("<?") || string.startsWith("<!DOCTYPE")) {
            return;
        }
        Document document2 = this.createDocument(document, string);
        if (document2 == null) {
            Text text = document.createTextNode(string);
            node.appendChild(text);
        } else {
            NodeList nodeList = document2.getDocumentElement().getChildNodes();
            Element element = null;
            for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
                if (!(node2 instanceof Element)) continue;
                element = (Element)node2;
                break;
            }
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = document.importNode(nodeList.item(i), true);
                if (element != null && node3 instanceof Element) {
                    CssProvider.getEngineService().setStyleParentForElement((Element)node3, element);
                    CssProvider.getEngineService().setStyleParentForElement((Element)nodeList.item(i), element);
                }
                node.appendChild(node3);
                this.setBean(node3, markupDesignBean);
            }
        }
    }

    private void setBean(Node node, MarkupDesignBean markupDesignBean) {
        if (node instanceof Element) {
            MarkupUnit.setMarkupDesignBeanForElement((Element)node, markupDesignBean);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.setBean(nodeList.item(i), markupDesignBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMarkupDesignBeanForElement(Element element, MarkupDesignBean markupDesignBean) {
        Map map = element2markupDesignBean;
        synchronized (map) {
            element2markupDesignBean.put(element, new WeakReference<MarkupDesignBean>(markupDesignBean));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MarkupDesignBean getMarkupDesignBeanForElement(Element element) {
        Map map = element2markupDesignBean;
        synchronized (map) {
            WeakReference weakReference = (WeakReference)element2markupDesignBean.get(element);
            return weakReference == null ? null : (MarkupDesignBean)weakReference.get();
        }
    }

    private void registerDomListeners(Document document) {
        Trace.trace((String)"insync.markup", (String)("MU.registerDomListeners " + document));
        EventTarget eventTarget = (EventTarget)((Object)document);
        eventTarget.addEventListener(DOM_ATTR_MODIFIED, this, false);
        eventTarget.addEventListener(DOM_SUBTREE_MODIFIED, this, false);
        this.registeredAsEventListenerOn = eventTarget;
    }

    private void fireDocumentReplaced(Document document) {
        Trace.trace((String)"insync.markup", (String)("MU.fireDomListeners " + document));
        DocumentEvent documentEvent = (DocumentEvent)((Object)document);
        MutationEvent mutationEvent = (MutationEvent)documentEvent.createEvent("MutationEvents");
        mutationEvent.initMutationEvent(DOM_DOCUMENT_REPLACED, false, false, document, null, null, null, (short)3);
        EventTarget eventTarget = (EventTarget)((Object)document);
        eventTarget.dispatchEvent(mutationEvent);
    }

    protected void unregisterDomListeners() {
        if (this.registeredAsEventListenerOn == null) {
            return;
        }
        this.registeredAsEventListenerOn.removeEventListener(DOM_ATTR_MODIFIED, this, false);
        this.registeredAsEventListenerOn.removeEventListener(DOM_SUBTREE_MODIFIED, this, false);
        this.registeredAsEventListenerOn = null;
    }

    public void handleEvent(Event event) {
        this.setModelDirty();
    }

    public int computeLine(Element element) {
        int n;
        block4: {
            LineCountingWriter lineCountingWriter = new LineCountingWriter();
            OutputFormat outputFormat = this.getOutputFormat();
            TargetXMLSerializer targetXMLSerializer = new TargetXMLSerializer(lineCountingWriter, outputFormat, element);
            n = 0;
            try {
                targetXMLSerializer.serialize(this.sourceDocument);
            }
            catch (EOFException eOFException) {
                n = lineCountingWriter.pos;
                if (!targetXMLSerializer.isAdjusted()) {
                    ++n;
                }
            }
            catch (IOException iOException) {
                if ($assertionsDisabled || Trace.trace((String)"insync.java", (String)("Error scanning for node position: " + iOException))) break block4;
                throw new AssertionError();
            }
        }
        return n - 1;
    }

    public int getOffset(Element element) {
        int n;
        block3: {
            LineCountingWriter lineCountingWriter = new LineCountingWriter();
            OutputFormat outputFormat = this.getOutputFormat();
            TargetXMLSerializer targetXMLSerializer = new TargetXMLSerializer(lineCountingWriter, outputFormat, element);
            n = -1;
            try {
                targetXMLSerializer.serialize(this.sourceDocument);
            }
            catch (EOFException eOFException) {
                n = lineCountingWriter.offset;
            }
            catch (IOException iOException) {
                if ($assertionsDisabled || Trace.trace((String)"insync.java", (String)("Error scanning for node position: " + iOException))) break block3;
                throw new AssertionError();
            }
        }
        return n;
    }

    private static void setMarkupUnitForDocument(Document document, MarkupUnit markupUnit) {
        if (document == null) {
            return;
        }
        doc2markupUnit.put(document, markupUnit);
    }

    public static MarkupUnit getMarkupUnitForDocument(Document document) {
        if (document == null) {
            return null;
        }
        return doc2markupUnit.get(document);
    }

    public static void setUrlForDocument(Document document, URL uRL) {
        if (document == null) {
            return;
        }
        doc2url.put(document, uRL);
    }

    public static URL getUrlForDocument(Document document) {
        if (document == null) {
            return null;
        }
        return doc2url.get(document);
    }

    public class LineCountingWriter
    extends Writer {
        public int pos;
        public int offset;

        public void close() {
        }

        public void flush() {
        }

        public void write(char[] cArray) {
            this.offset += cArray.length;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != '\n') continue;
                ++this.pos;
            }
        }

        public void write(char[] cArray, int n, int n2) {
            this.offset += n2;
            for (int i = 0; i < n2; ++i) {
                if (cArray[n + i] != '\n') continue;
                ++this.pos;
            }
        }

        public void write(int n) {
            ++this.offset;
            if (n == 10) {
                ++this.pos;
            }
        }

        public void write(String string) {
            this.offset += string.length();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) != '\n') continue;
                ++this.pos;
            }
        }

        public void write(String string, int n, int n2) {
            this.offset += n2;
            for (int i = 0; i < n2; ++i) {
                if (string.charAt(n + i) != '\n') continue;
                ++this.pos;
            }
        }
    }

    private class TargetXMLSerializer
    extends JspxSerializer {
        private Element target;
        private boolean adjusted;

        private TargetXMLSerializer(Writer writer, OutputFormat outputFormat, Element element) {
            super(writer, outputFormat);
            this.adjusted = true;
            this.target = element;
        }

        boolean isAdjusted() {
            return this.adjusted;
        }

        public void serializeElement(Element element) throws IOException, EOFException {
            if (element == this.target) {
                if (this.getElementState().empty) {
                    this.adjusted = false;
                }
                this._printer.flush();
                throw new EOFException();
            }
            super.serializeElement(element);
        }
    }

    public static class XhtmlEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

