/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.java;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.HashMap;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;

public class Refactor {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ElementsRenamer
    extends TreePathScanner<Tree, Void> {
        private final WorkingCopy workingCopy;
        private final TreeMaker make;
        private HashMap<Element, String> elementAndNames = new HashMap();

        public ElementsRenamer(WorkingCopy workingCopy, HashMap<? extends ElementHandle, String> hashMap) {
            this.workingCopy = workingCopy;
            this.make = workingCopy.getTreeMaker();
            for (ElementHandle elementHandle : hashMap.keySet()) {
                Element element = elementHandle.resolve((CompilationInfo)workingCopy);
                this.elementAndNames.put(element, hashMap.get(elementHandle));
            }
        }

        @Override
        public Tree visitIdentifier(IdentifierTree identifierTree, Void void_) {
            this.renameIfMatch(this.getCurrentPath(), identifierTree);
            return (Tree)super.visitIdentifier(identifierTree, void_);
        }

        @Override
        public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Void void_) {
            this.renameIfMatch(this.getCurrentPath(), memberSelectTree);
            return (Tree)super.visitMemberSelect(memberSelectTree, void_);
        }

        @Override
        public Tree visitMethod(MethodTree methodTree, Void void_) {
            this.renameIfMatch(this.getCurrentPath(), methodTree);
            return (Tree)super.visitMethod(methodTree, void_);
        }

        @Override
        public Tree visitVariable(VariableTree variableTree, Void void_) {
            this.renameIfMatch(this.getCurrentPath(), variableTree);
            return (Tree)super.visitVariable(variableTree, void_);
        }

        private void renameIfMatch(TreePath treePath, Tree tree) {
            if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
                return;
            }
            Element element = this.workingCopy.getTrees().getElement(treePath);
            if (element != null && this.elementAndNames.containsKey(element)) {
                Tree tree2 = this.make.setLabel(tree, (CharSequence)this.elementAndNames.get(element));
                this.workingCopy.rewrite(tree, tree2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReturnStatementLiteralRenamer
    extends TreePathScanner<Tree, Void> {
        private WorkingCopy workingCopy;
        private String newName;
        private String oldName;

        public ReturnStatementLiteralRenamer(WorkingCopy workingCopy, String string, String string2) {
            this.oldName = string;
            this.newName = string2;
            this.workingCopy = workingCopy;
        }

        @Override
        public Tree visitReturn(ReturnTree returnTree, Void void_) {
            this.renameIfMatch(returnTree);
            return (Tree)super.visitReturn(returnTree, void_);
        }

        private void renameIfMatch(ReturnTree returnTree) {
            LiteralTree literalTree;
            ExpressionTree expressionTree = returnTree.getExpression();
            if (expressionTree.getKind() == Tree.Kind.STRING_LITERAL && this.oldName.equals((literalTree = (LiteralTree)expressionTree).getValue())) {
                LiteralTree literalTree2 = this.workingCopy.getTreeMaker().Literal((Object)this.newName);
                this.workingCopy.rewrite((Tree)literalTree, (Tree)literalTree2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LiteralRenamer
    extends TreePathScanner<Tree, Void> {
        private WorkingCopy workingCopy;
        private String newName;
        private String oldName;

        public LiteralRenamer(WorkingCopy workingCopy, String string, String string2) {
            this.oldName = string;
            this.newName = string2;
            this.workingCopy = workingCopy;
        }

        @Override
        public Tree visitLiteral(LiteralTree literalTree, Void void_) {
            this.renameIfMatch(literalTree);
            return (Tree)super.visitLiteral(literalTree, void_);
        }

        private void renameIfMatch(LiteralTree literalTree) {
            if (literalTree.getKind() == Tree.Kind.STRING_LITERAL && this.oldName.equals(literalTree.getValue())) {
                LiteralTree literalTree2 = this.workingCopy.getTreeMaker().Literal((Object)this.newName);
                this.workingCopy.rewrite((Tree)literalTree, (Tree)literalTree2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ElementRenamer
    extends TreePathScanner<Tree, Element> {
        private WorkingCopy workingCopy;
        private String newName;

        public ElementRenamer(WorkingCopy workingCopy, String string) {
            this.newName = string;
            this.workingCopy = workingCopy;
        }

        @Override
        public Tree visitIdentifier(IdentifierTree identifierTree, Element element) {
            this.renameIfMatch(this.getCurrentPath(), identifierTree, element);
            return (Tree)super.visitIdentifier(identifierTree, element);
        }

        @Override
        public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
            this.renameIfMatch(this.getCurrentPath(), memberSelectTree, element);
            return (Tree)super.visitMemberSelect(memberSelectTree, element);
        }

        @Override
        public Tree visitMethod(MethodTree methodTree, Element element) {
            this.renameIfMatch(this.getCurrentPath(), methodTree, element);
            return (Tree)super.visitMethod(methodTree, element);
        }

        @Override
        public Tree visitVariable(VariableTree variableTree, Element element) {
            this.renameIfMatch(this.getCurrentPath(), variableTree, element);
            return (Tree)super.visitVariable(variableTree, element);
        }

        private void renameIfMatch(TreePath treePath, Tree tree, Element element) {
            if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
                return;
            }
            Element element2 = this.workingCopy.getTrees().getElement(treePath);
            if (element2 != null && ((Object)element2).equals(element)) {
                Tree tree2 = this.workingCopy.getTreeMaker().setLabel(tree, (CharSequence)this.newName);
                this.workingCopy.rewrite(tree, tree2);
            }
        }
    }
}

