/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.faces.refactoring;

import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PostProcessRenamedFolderRefactoringElement
extends SimpleRefactoringElementImplementation {
    private final FileObject folder;
    private final FileObject folderParent;
    private final String oldName;
    private final String newName;

    public PostProcessRenamedFolderRefactoringElement(FileObject fileObject, String string) {
        this.folder = fileObject;
        this.folderParent = fileObject.getParent();
        this.oldName = fileObject.getNameExt();
        this.newName = string;
    }

    public String getDisplayText() {
        return this.getText();
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public FileObject getParentFile() {
        return this.folder;
    }

    public PositionBounds getPosition() {
        return null;
    }

    public String getText() {
        return NbBundle.getMessage(PostProcessRenamedFolderRefactoringElement.class, (String)"MSG_PostProcessFolder");
    }

    public void performChange() {
        FacesModelSet facesModelSet;
        FileObject fileObject = this.folderParent.getFileObject(this.newName);
        if (fileObject != null && (facesModelSet = FacesModelSet.getInstance(fileObject)) != null) {
            facesModelSet.processFileDataCreated(fileObject);
        }
    }

    public void undoChange() {
        FacesModelSet facesModelSet;
        FileObject fileObject = this.folderParent.getFileObject(this.oldName);
        if (fileObject != null && (facesModelSet = FacesModelSet.getInstance(fileObject)) != null) {
            facesModelSet.processFileDataCreated(fileObject);
        }
    }
}

