/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.LogReader;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeMakeLog
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new LinkedHashMap<String, ProviderProperty>();
    public static final String MAKE_LOG_KEY = "make-log-file";

    public AnalyzeMakeLog() {
        this.clean();
    }

    public void clean() {
        this.myProperties.clear();
        this.myProperties.put(MAKE_LOG_KEY, new ProviderProperty(){
            private String myPath;

            public String getName() {
                return AnalyzeMakeLog.i18n("Make_Log_File_Name");
            }

            public String getDescription() {
                return AnalyzeMakeLog.i18n("Make_Log_File_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.MakeLogFile;
            }
        });
        this.myProperties.put("restrict_source_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeMakeLog.i18n("RESTRICT_SOURCE_ROOT");
            }

            public String getDescription() {
                return AnalyzeMakeLog.i18n("RESTRICT_SOURCE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
        this.myProperties.put("restrict_compile_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeMakeLog.i18n("RESTRICT_COMPILE_ROOT");
            }

            public String getDescription() {
                return AnalyzeMakeLog.i18n("RESTRICT_COMPILE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
    }

    public String getID() {
        return "make-log";
    }

    public String getName() {
        return AnalyzeMakeLog.i18n("Make_Log_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeMakeLog.i18n("Make_Log_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String string) {
        return this.myProperties.get(string);
    }

    @Override
    public boolean isApplicable(ProjectProxy projectProxy) {
        Object object = this.getProperty("restrict_compile_root").getValue();
        if (object == null || "".equals(object.toString())) {
            this.getProperty("restrict_compile_root").setValue((Object)projectProxy.getSourceRoot());
            return true;
        }
        return false;
    }

    private String detectMakeLog(ProjectProxy projectProxy) {
        String string = projectProxy.getSourceRoot();
        int n = string.indexOf("/usr/src/");
        if (n < 0 && string.endsWith("/usr/src")) {
            n = string.indexOf("/usr/src");
        }
        if (n > 0) {
            String string2 = null;
            String string3 = string.substring(0, n) + "/log";
            File file = new File(string3);
            if (file.exists() && file.isDirectory()) {
                block0: for (File file2 : file.listFiles()) {
                    if (!file2.isDirectory()) continue;
                    for (File file3 : file2.listFiles()) {
                        String string4;
                        String string5 = file3.getAbsolutePath();
                        if (!string5.endsWith("/nightly.log")) continue;
                        if (string2 == null) {
                            string2 = string5;
                            continue block0;
                        }
                        String string6 = string2.substring(0, string2.lastIndexOf("/nightly.log"));
                        if (string6.compareTo(string4 = string5.substring(0, string5.lastIndexOf("/nightly.log"))) >= 0) continue block0;
                        string2 = string5;
                        continue block0;
                    }
                }
            }
            return string2;
        }
        return null;
    }

    public int canAnalyze(ProjectProxy projectProxy) {
        String string = (String)this.getProperty(MAKE_LOG_KEY).getValue();
        if (string == null || string.length() == 0) {
            string = this.detectMakeLog(projectProxy);
        }
        if (string == null || string.length() == 0) {
            return 0;
        }
        return 80;
    }

    @Override
    protected List<SourceFileProperties> getSourceFileProperties(String string, Map<String, SourceFileProperties> map) {
        ProviderProperty providerProperty = this.getProperty("restrict_compile_root");
        String string2 = "";
        if (providerProperty != null) {
            string2 = (String)providerProperty.getValue();
        }
        return AnalyzeMakeLog.runLogReader(string, string2);
    }

    static List<SourceFileProperties> runLogReader(String string, String string2) {
        LogReader logReader = new LogReader(string, string2);
        List<SourceFileProperties> list = logReader.getResults();
        return list;
    }

    public List<Configuration> analyze(final ProjectProxy projectProxy) {
        this.isStoped = false;
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        this.setCommpilerSettings(projectProxy);
        if (!this.isStoped) {
            Configuration configuration = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration());
                }

                public List<Configuration> getDependencies() {
                    return null;
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        String string = (String)AnalyzeMakeLog.this.getProperty(AnalyzeMakeLog.MAKE_LOG_KEY).getValue();
                        if (string == null || string.length() == 0) {
                            string = AnalyzeMakeLog.this.detectMakeLog(projectProxy);
                        }
                        if (string != null && string.length() > 0) {
                            this.myFileProperties = AnalyzeMakeLog.this.getSourceFileProperties(new String[]{string});
                        }
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> hashSet = new HashSet<String>();
                        for (SourceFileProperties object : this.getSourcesConfiguration()) {
                            if (AnalyzeMakeLog.this.isStoped) break;
                            if (!(object instanceof DwarfSource)) continue;
                            hashSet.addAll(((DwarfSource)object).getIncludedFiles());
                            hashSet.add(object.getItemPath());
                        }
                        HashSet hashSet2 = new HashSet();
                        for (String string : hashSet) {
                            if (AnalyzeMakeLog.this.isStoped) break;
                            File file = new File(string);
                            if (!file.exists()) continue;
                            hashSet2.add(FileUtil.normalizeFile((File)file).getAbsolutePath());
                        }
                        this.myIncludedFiles = new ArrayList<String>(hashSet2);
                    }
                    return this.myIncludedFiles;
                }
            };
            arrayList.add(configuration);
        }
        return arrayList;
    }

    private static String i18n(String string) {
        return NbBundle.getMessage(AnalyzeMakeLog.class, (String)string);
    }
}

