/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.selector.spi.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.GreedySelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.IconResource;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerClassesNode
extends ContainerNode {
    private final ClasspathInfo cpInfo;

    public InnerClassesNode(ClasspathInfo classpathInfo, ClassNode classNode) {
        super(NbBundle.getMessage(InnerClassesNode.class, (String)"InnerClasses_DisplayName"), IconResource.CLASS_ICON, classNode);
        this.cpInfo = classpathInfo;
    }

    public ElementHandle<TypeElement> getClassHandle() {
        return ((ClassNode)this.getParent()).getClassHandle();
    }

    @Override
    protected SelectorChildren getChildren() {
        return new Children();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Children
    extends GreedySelectorChildren<InnerClassesNode> {
        private Children() {
        }

        @Override
        protected List<? extends SelectorNode> prepareChildren(final InnerClassesNode innerClassesNode) {
            Object object;
            final HashSet hashSet = new HashSet();
            try {
                object = JavaSource.create((ClasspathInfo)innerClassesNode.cpInfo, (FileObject[])new FileObject[0]);
                object.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        if (compilationController.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                            return;
                        }
                        TypeElement typeElement = SourceUtils.resolveClassByName((String)innerClassesNode.getClassHandle().getBinaryName(), (CompilationController)compilationController);
                        List<TypeElement> list = ElementFilter.typesIn(typeElement.getEnclosedElements());
                        for (TypeElement typeElement2 : list) {
                            hashSet.add(new ClassNode(innerClassesNode.cpInfo, IconResource.CLASS_ICON, typeElement2, (ContainerNode)innerClassesNode));
                        }
                        Children.this.addAnonymousInnerClasses(compilationController, innerClassesNode, hashSet);
                    }
                }, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = new ArrayList(hashSet);
            Collections.sort(object, ClassNode.COMPARATOR);
            return object;
        }

        private static String getInterfaceNames(TypeElement typeElement, CompilationInfo compilationInfo) {
            String string = null;
            List<? extends TypeMirror> list = typeElement.getInterfaces();
            if (list != null) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = true;
                for (TypeMirror typeMirror : list) {
                    Element element = compilationInfo.getTypes().asElement(typeMirror);
                    if (element == null || element.getKind() != ElementKind.INTERFACE) continue;
                    if (!bl) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(ElementUtilities.getBinaryName((TypeElement)((TypeElement)element)));
                }
                string = stringBuilder.toString();
            }
            return string;
        }

        private static String getSuperTypeClassName(TypeElement typeElement, CompilationInfo compilationInfo) {
            String string;
            Element element;
            String string2 = null;
            TypeMirror typeMirror = typeElement.getSuperclass();
            if (typeMirror != null && (element = compilationInfo.getTypes().asElement(typeMirror)) != null && element.getKind() == ElementKind.CLASS && !(string = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element))).equals("java.lang.Object")) {
                string2 = string;
            }
            return string2;
        }

        private void addAnonymousInnerClasses(final CompilationController compilationController, final InnerClassesNode innerClassesNode, final Set<ClassNode> set) throws IOException {
            final Pattern pattern = Pattern.compile("\\$[0-9]*");
            final int n = innerClassesNode.getClassHandle().getBinaryName().length();
            FileObject fileObject = org.netbeans.api.java.source.SourceUtils.getFile(innerClassesNode.getClassHandle(), (ClasspathInfo)compilationController.getClasspathInfo());
            JavaSource.forFileObject((FileObject)fileObject).runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(final CompilationController compilationController2) throws Exception {
                    compilationController2.toPhase(JavaSource.Phase.RESOLVED);
                    TreePathScanner<Void, Void> treePathScanner = new TreePathScanner<Void, Void>(){

                        @Override
                        public Void visitClass(ClassTree classTree, Void void_) {
                            TypeElement typeElement;
                            String string;
                            Element element = compilationController.getTrees().getElement(this.getCurrentPath());
                            if (element != null && element.getKind() == ElementKind.CLASS && pattern.matcher(string = (string = ElementUtilities.getBinaryName((TypeElement)(typeElement = (TypeElement)element))).length() <= n ? "" : string.substring(n)).matches()) {
                                String string2 = Children.getSuperTypeClassName(typeElement, (CompilationInfo)compilationController2);
                                if (string2 == null) {
                                    string2 = Children.getInterfaceNames(typeElement, (CompilationInfo)compilationController2);
                                }
                                if (string2 != null) {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    stringBuilder.append(string).append("[").append(string2).append("]");
                                    string = stringBuilder.toString();
                                    set.add(new ClassNode(innerClassesNode.cpInfo, IconResource.CLASS_ICON, typeElement, string, (ContainerNode)innerClassesNode));
                                }
                            }
                            super.visitClass(classTree, void_);
                            return null;
                        }

                        @Override
                        public Void visitAssignment(AssignmentTree assignmentTree, Void void_) {
                            return (Void)super.visitAssignment(assignmentTree, void_);
                        }
                    };
                    treePathScanner.scan(compilationController2.getCompilationUnit(), null);
                }
            }, false);
        }
    }
}

