/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAObjectWatchImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAWatchImpl;
import org.netbeans.modules.debugger.jpda.models.LocalsTreeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class WatchesModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(119) >= 0;
    private JPDADebuggerImpl debugger;
    private Listener listener;
    private Vector<ModelListener> listeners = new Vector();
    private ContextProvider lookupProvider;
    private Map<Watch, JPDAWatchEvaluating> watchToValue = new WeakHashMap<Watch, JPDAWatchEvaluating>();
    private LocalsTreeModel localsTreeModel;

    public WatchesModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.lookupProvider = contextProvider;
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            n2 = Math.min(watchArray.length, n2);
            n = Math.min(watchArray.length, n);
            Watch[] watchArray2 = new Watch[n2 - n];
            System.arraycopy(watchArray, n, watchArray2, 0, n2 - n);
            int n3 = watchArray2.length;
            Object[] objectArray = new JPDAWatch[n3];
            for (int i = 0; i < n3; ++i) {
                JPDAWatchEvaluating jPDAWatchEvaluating = this.watchToValue.get(watchArray2[i]);
                if (jPDAWatchEvaluating == null) {
                    jPDAWatchEvaluating = new JPDAWatchEvaluating(this, watchArray2[i], this.debugger);
                    this.watchToValue.put(watchArray2[i], jPDAWatchEvaluating);
                }
                objectArray[i] = jPDAWatchEvaluating;
            }
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return objectArray;
        }
        if (object instanceof JPDAWatchImpl) {
            return this.getLocalsTreeModel().getChildren(object, n, n2);
        }
        return this.getLocalsTreeModel().getChildren(object, n, n2);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return Integer.MAX_VALUE;
        }
        if (object instanceof JPDAWatchImpl) {
            return this.getLocalsTreeModel().getChildrenCount(object);
        }
        return this.getLocalsTreeModel().getChildrenCount(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        JPDAWatchEvaluating jPDAWatchEvaluating;
        JPDAWatch jPDAWatch;
        if (object == "Root") {
            return false;
        }
        if (object instanceof JPDAWatchEvaluating && (jPDAWatch = (jPDAWatchEvaluating = (JPDAWatchEvaluating)object).getEvaluatedWatch()) instanceof JPDAWatchImpl) {
            return ((JPDAWatchImpl)jPDAWatch).isPrimitive();
        }
        return this.getLocalsTreeModel().isLeaf(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeChanged() {
        Object object = this.watchToValue;
        synchronized (object) {
            Iterator<JPDAWatchEvaluating> iterator = this.watchToValue.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().setEvaluated(null);
            }
        }
        object = (Vector)this.listeners.clone();
        int n = ((Vector)object).size();
        ModelEvent.TreeChanged treeChanged = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < n; ++i) {
            ((ModelListener)((Vector)object).get(i)).modelChanged((ModelEvent)treeChanged);
        }
    }

    private void fireWatchesChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        ModelEvent.NodeChanged nodeChanged = new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8);
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)nodeChanged);
        }
    }

    void fireTableValueChangedChanged(Object object, String string) {
        ((JPDAWatchEvaluating)object).setEvaluated(null);
        this.fireTableValueChangedComputed(object, string);
    }

    void fireTableValueChangedComputed(Object object, String string) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    LocalsTreeModel getLocalsTreeModel() {
        if (this.localsTreeModel == null) {
            this.localsTreeModel = (LocalsTreeModel)this.lookupProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.localsTreeModel;
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference<WatchesModel> model;
        private WeakReference<JPDADebuggerImpl> debugger;
        private RequestProcessor.Task task;

        private Listener(WatchesModel watchesModel, JPDADebuggerImpl jPDADebuggerImpl) {
            this.model = new WeakReference<WatchesModel>(watchesModel);
            this.debugger = new WeakReference<JPDADebuggerImpl>(jPDADebuggerImpl);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            jPDADebuggerImpl.addPropertyChangeListener(this);
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            int n = watchArray.length;
            for (int i = 0; i < n; ++i) {
                watchArray[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesModel getModel() {
            WatchesModel watchesModel = (WatchesModel)this.model.get();
            if (watchesModel == null) {
                this.destroy();
            }
            return watchesModel;
        }

        public void watchAdded(Watch watch) {
            WatchesModel watchesModel = this.getModel();
            if (watchesModel == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            watchesModel.fireWatchesChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesModel watchesModel = this.getModel();
            if (watchesModel == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            watchesModel.fireWatchesChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("watches".equals(string)) {
                return;
            }
            final WatchesModel watchesModel = this.getModel();
            if (watchesModel == null) {
                return;
            }
            if (watchesModel.debugger.getState() == 4) {
                this.destroy();
                return;
            }
            if (watchesModel.debugger.getState() == 2) {
                return;
            }
            if (propertyChangeEvent.getSource() instanceof Watch) {
                Object v;
                Map map = watchesModel.watchToValue;
                synchronized (map) {
                    v = watchesModel.watchToValue.get(propertyChangeEvent.getSource());
                }
                if (v != null) {
                    watchesModel.fireTableValueChangedChanged(v, null);
                    return;
                }
            }
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create(new Runnable(){

                    public void run() {
                        if (verbose) {
                            System.out.println("WM do task " + Listener.this.task);
                        }
                        watchesModel.fireTreeChanged();
                    }
                });
                if (verbose) {
                    System.out.println("WM  create task " + this.task);
                }
            }
            this.task.schedule(100);
        }

        private void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
            JPDADebugger jPDADebugger = (JPDADebugger)this.debugger.get();
            if (jPDADebugger != null) {
                jPDADebugger.removePropertyChangeListener((PropertyChangeListener)this);
            }
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            int n = watchArray.length;
            for (int i = 0; i < n; ++i) {
                watchArray[i].removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("WM cancel old task " + this.task);
                }
                this.task = null;
            }
        }
    }

    private static class JPDAWatchEvaluating
    extends AbstractObjectVariable
    implements JPDAWatch,
    Variable,
    Refreshable,
    PropertyChangeListener {
        private WatchesModel model;
        private Watch w;
        private JPDADebuggerImpl debugger;
        private JPDAWatch evaluatedWatch;
        private Expression expression;
        private ParseException parseException;
        private boolean[] evaluating = new boolean[]{false};
        private int cloneNumber = 1;

        public JPDAWatchEvaluating(WatchesModel watchesModel, Watch watch, JPDADebuggerImpl jPDADebuggerImpl) {
            this(watchesModel, watch, jPDADebuggerImpl, 0);
        }

        private JPDAWatchEvaluating(WatchesModel watchesModel, Watch watch, JPDADebuggerImpl jPDADebuggerImpl, int n) {
            super(jPDADebuggerImpl, null, n > 0 ? watch + "_clone" + n : "" + watch);
            this.model = watchesModel;
            this.w = watch;
            this.debugger = jPDADebuggerImpl;
            this.parseExpression(watch.getExpression());
            jPDADebuggerImpl.varChangeSupport.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jPDADebuggerImpl.varChangeSupport));
        }

        private void parseExpression(String string) {
            try {
                this.expression = Expression.parse(string, "1.5.0");
                this.parseException = null;
            }
            catch (ParseException parseException) {
                this.setEvaluated(new JPDAWatchImpl(this.debugger, this.w, parseException, (Object)this));
                this.parseException = parseException;
            }
        }

        Expression getParsedExpression() throws ParseException {
            if (this.parseException != null) {
                throw this.parseException;
            }
            return this.expression;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEvaluated(JPDAWatch jPDAWatch) {
            JPDAWatchEvaluating jPDAWatchEvaluating = this;
            synchronized (jPDAWatchEvaluating) {
                this.evaluatedWatch = jPDAWatch;
            }
            if (jPDAWatch != null) {
                if (jPDAWatch instanceof JPDAWatchImpl) {
                    this.setInnerValue(((JPDAWatchImpl)jPDAWatch).getInnerValue());
                } else if (jPDAWatch instanceof JPDAObjectWatchImpl) {
                    this.setInnerValue(((JPDAObjectWatchImpl)jPDAWatch).getInnerValue());
                }
            } else {
                this.setInnerValue(null);
            }
        }

        synchronized JPDAWatch getEvaluatedWatch() {
            return this.evaluatedWatch;
        }

        public void expressionChanged() {
            this.setEvaluated(null);
            this.parseExpression(this.w.getExpression());
        }

        public synchronized String getExceptionDescription() {
            if (this.evaluatedWatch != null) {
                return this.evaluatedWatch.getExceptionDescription();
            }
            return null;
        }

        public synchronized String getExpression() {
            if (this.evaluatedWatch != null) {
                return this.evaluatedWatch.getExpression();
            }
            return this.w.getExpression();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getToStringValue() throws InvalidExpressionException {
            JPDAWatch jPDAWatch;
            JPDAWatch[] jPDAWatchArray = this;
            synchronized (jPDAWatchArray) {
                jPDAWatch = this.evaluatedWatch;
            }
            if (jPDAWatch == null) {
                jPDAWatchArray = new JPDAWatch[]{null};
                this.getValue(jPDAWatchArray);
                jPDAWatch = jPDAWatchArray[0];
            }
            if ((jPDAWatchArray = jPDAWatch.getExceptionDescription()) != null) {
                return ">" + (String)jPDAWatchArray + "<";
            }
            return jPDAWatch.getToStringValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getType() {
            JPDAWatch[] jPDAWatchArray = this;
            synchronized (this) {
                JPDAWatch jPDAWatch = this.evaluatedWatch;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                if (jPDAWatch == null) {
                    jPDAWatchArray = new JPDAWatch[]{null};
                    super.getValue(jPDAWatchArray);
                    jPDAWatch = jPDAWatchArray[0];
                }
                return jPDAWatch.getType();
            }
        }

        public String getValue() {
            return this.getValue(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getValue(JPDAWatch[] jPDAWatchArray) {
            Object object = this.evaluating;
            synchronized (this.evaluating) {
                block25: {
                    if (this.evaluating[0]) {
                        try {
                            this.evaluating.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // ** MonitorExit[object /* !! */ ] (shouldn't be in output)
                            return null;
                        }
                    }
                    Object object2 = this;
                    synchronized (object2) {
                        if (this.evaluatedWatch != null) {
                            if (jPDAWatchArray == null) return this.evaluatedWatch.getValue();
                            jPDAWatchArray[0] = this.evaluatedWatch;
                            // MONITOREXIT @DISABLED, blocks:[22, 6, 7] lbl15 : MonitorExitStatement: MONITOREXIT : object2
                            // ** MonitorExit[object /* !! */ ] (shouldn't be in output)
                            return this.evaluatedWatch.getValue();
                        }
                    }
                    this.evaluating[0] = true;
                    // ** MonitorExit[object /* !! */ ] (shouldn't be in output)
                    object = null;
                    try {
                        try {
                            object2 = this.getParsedExpression();
                            Value value = this.debugger.evaluateIn((Expression)object2);
                            if (value instanceof PrimitiveValue) {
                                JPDAWatchImpl jPDAWatchImpl = new JPDAWatchImpl(this.debugger, this.w, (PrimitiveValue)value, (Object)this);
                                jPDAWatchImpl.addPropertyChangeListener(this);
                                object = jPDAWatchImpl;
                            } else {
                                JPDAObjectWatchImpl jPDAObjectWatchImpl = new JPDAObjectWatchImpl(this.debugger, this.w, value);
                                jPDAObjectWatchImpl.addPropertyChangeListener(this);
                                object = jPDAObjectWatchImpl;
                            }
                        }
                        catch (InvalidExpressionException invalidExpressionException) {
                            JPDAWatchImpl value = new JPDAWatchImpl(this.debugger, this.w, (Exception)((Object)invalidExpressionException), (Object)this);
                            value.addPropertyChangeListener(this);
                            object = value;
                            Object var7_13 = null;
                            this.setEvaluated((JPDAWatch)object);
                            if (jPDAWatchArray != null) {
                                jPDAWatchArray[0] = (JPDAWatch)object;
                            }
                            boolean[] blArray = this.evaluating;
                            synchronized (this.evaluating) {
                                this.evaluating[0] = false;
                                this.evaluating.notifyAll();
                                // ** MonitorExit[var8_17] (shouldn't be in output)
                                return object.getValue();
                            }
                        }
                        catch (ParseException parseException) {
                            JPDAWatchImpl jPDAWatchImpl = new JPDAWatchImpl(this.debugger, this.w, parseException, (Object)this);
                            jPDAWatchImpl.addPropertyChangeListener(this);
                            object = jPDAWatchImpl;
                            Object var7_14 = null;
                            this.setEvaluated((JPDAWatch)object);
                            if (jPDAWatchArray != null) {
                                jPDAWatchArray[0] = (JPDAWatch)object;
                            }
                            boolean[] blArray = this.evaluating;
                            synchronized (this.evaluating) {
                                this.evaluating[0] = false;
                                this.evaluating.notifyAll();
                                // ** MonitorExit[blArray] (shouldn't be in output)
                                return object.getValue();
                            }
                        }
                        Object var7_12 = null;
                        this.setEvaluated((JPDAWatch)object);
                        if (jPDAWatchArray == null) break block25;
                    }
                    catch (Throwable throwable) {
                        Object var7_15 = null;
                        this.setEvaluated((JPDAWatch)object);
                        if (jPDAWatchArray != null) {
                            jPDAWatchArray[0] = (JPDAWatch)object;
                        }
                        boolean[] blArray2 = this.evaluating;
                        synchronized (this.evaluating) {
                            this.evaluating[0] = false;
                            this.evaluating.notifyAll();
                            // ** MonitorExit[blArray2] (shouldn't be in output)
                            throw throwable;
                        }
                    }
                    jPDAWatchArray[0] = (JPDAWatch)object;
                }
                boolean[] blArray = this.evaluating;
                synchronized (this.evaluating) {
                    this.evaluating[0] = false;
                    this.evaluating.notifyAll();
                    // ** MonitorExit[var8_16] (shouldn't be in output)
                    return object.getValue();
                }
            }
        }

        public synchronized void remove() {
            if (this.evaluatedWatch != null) {
                this.evaluatedWatch.remove();
            } else {
                this.w.remove();
            }
        }

        public void setExpression(String string) {
            this.w.setExpression(string);
            this.expressionChanged();
        }

        public synchronized void setValue(String string) throws InvalidExpressionException {
            if (this.evaluatedWatch == null) {
                throw new InvalidExpressionException("Can not set value while evaluating.");
            }
            this.evaluatedWatch.setValue(string);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof JPDAWatchEvaluating) {
                return;
            }
            this.model.fireTableValueChangedChanged(this, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() throws RefreshFailedException {
            boolean[] blArray = this.evaluating;
            synchronized (this.evaluating) {
                if (this.evaluating[0]) {
                    try {
                        this.evaluating.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RefreshFailedException(interruptedException.getLocalizedMessage());
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public synchronized boolean isCurrent() {
            return this.evaluatedWatch != null;
        }

        public JPDAWatchEvaluating clone() {
            return new JPDAWatchEvaluating(this.model, this.w, this.debugger, this.cloneNumber++);
        }
    }
}

