/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.NbBundle;

public class FieldBreakpointImpl
extends ClassBasedBreakpoint {
    private FieldBreakpoint breakpoint;

    public FieldBreakpointImpl(FieldBreakpoint fieldBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)fieldBreakpoint, jPDADebuggerImpl, session);
        this.breakpoint = fieldBreakpoint;
        this.set();
    }

    protected void setRequests() {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = (this.breakpoint.getBreakpointType() & 1) != 0;
        if (bl2 && !this.getVirtualMachine().canWatchFieldAccess()) {
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoFieldAccess"));
            return;
        }
        boolean bl4 = bl = (this.breakpoint.getBreakpointType() & 2) != 0;
        if (bl && !this.getVirtualMachine().canWatchFieldModification()) {
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoFieldModification"));
            return;
        }
        this.setClassRequests(new String[]{this.breakpoint.getClassName()}, new String[0], 1);
        this.checkLoadedClasses(this.breakpoint.getClassName(), null);
    }

    protected void classLoaded(ReferenceType referenceType) {
        Field field = referenceType.fieldByName(this.breakpoint.getFieldName());
        if (field == null) {
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(FieldBreakpointImpl.class, (String)"MSG_NoField", (Object)referenceType.name(), (Object)this.breakpoint.getFieldName()));
            return;
        }
        try {
            WatchpointRequest watchpointRequest;
            if ((this.breakpoint.getBreakpointType() & 1) != 0) {
                watchpointRequest = this.getEventRequestManager().createAccessWatchpointRequest(field);
                this.setFilters(watchpointRequest);
                this.addEventRequest(watchpointRequest);
            }
            if ((this.breakpoint.getBreakpointType() & 2) != 0) {
                watchpointRequest = this.getEventRequestManager().createModificationWatchpointRequest(field);
                this.setFilters(watchpointRequest);
                this.addEventRequest(watchpointRequest);
            }
            this.setValidity(Breakpoint.VALIDITY.VALID, null);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    protected EventRequest createEventRequest(EventRequest eventRequest) {
        if (eventRequest instanceof AccessWatchpointRequest) {
            Field field = ((AccessWatchpointRequest)eventRequest).field();
            AccessWatchpointRequest accessWatchpointRequest = this.getEventRequestManager().createAccessWatchpointRequest(field);
            this.setFilters(accessWatchpointRequest);
            return accessWatchpointRequest;
        }
        if (eventRequest instanceof ModificationWatchpointRequest) {
            Field field = ((ModificationWatchpointRequest)eventRequest).field();
            ModificationWatchpointRequest modificationWatchpointRequest = this.getEventRequestManager().createModificationWatchpointRequest(field);
            this.setFilters(modificationWatchpointRequest);
            return modificationWatchpointRequest;
        }
        return null;
    }

    private void setFilters(WatchpointRequest watchpointRequest) {
        JPDAThread[] jPDAThreadArray;
        JPDAThread[] jPDAThreadArray2 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
        if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
            jPDAThreadArray = jPDAThreadArray2;
            int n = jPDAThreadArray.length;
            for (int i = 0; i < n; ++i) {
                JPDAThread jPDAThread = jPDAThreadArray[i];
                watchpointRequest.addThreadFilter(((JPDAThreadImpl)jPDAThread).getThreadReference());
            }
        }
        if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
            for (JPDAThread jPDAThread : jPDAThreadArray) {
                watchpointRequest.addInstanceFilter((ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
            }
        }
    }

    public boolean exec(Event event) {
        if (event instanceof ModificationWatchpointEvent) {
            return this.perform(event, this.breakpoint.getCondition(), ((WatchpointEvent)event).thread(), ((LocatableEvent)event).location().declaringType(), ((ModificationWatchpointEvent)event).valueToBe());
        }
        if (event instanceof AccessWatchpointEvent) {
            return this.perform(event, this.breakpoint.getCondition(), ((WatchpointEvent)event).thread(), ((LocatableEvent)event).location().declaringType(), ((AccessWatchpointEvent)event).valueCurrent());
        }
        return super.exec(event);
    }
}

