/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoHandle
extends JGoRectangle {
    private static int myDefaultHandleWidth = 5;
    private static int myDefaultHandleHeight = 5;
    private int myCursorType = 0;
    private int myHandleType = 0;
    private JGoObject myHandleFor = null;

    public JGoHandle() {
        this.init(0, 0);
    }

    public JGoHandle(Rectangle rect, int cursorType) {
        super(rect);
        this.init(cursorType, 0);
    }

    public JGoHandle(Rectangle rect, int cursorType, int handleType) {
        super(rect);
        this.init(cursorType, handleType);
    }

    private final void init(int cursorType, int handleType) {
        this.setInternalFlags(this.getInternalFlags() & 0xFFFFFFEB);
        this.myCursorType = cursorType;
        this.myHandleType = handleType;
        this.setBrush(JGoBrush.black);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        return null;
    }

    public boolean doUncapturedMouseMove(int flags, Point dc, Point vc, JGoView view) {
        JGoObject obj = this.getHandleFor();
        if (obj != null && obj.getLayer() != null && !obj.getLayer().isModifiable()) {
            return false;
        }
        if (this.getCursorType() != 0) {
            view.setCursorType(this.getCursorType());
            return true;
        }
        return false;
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(this.getCursorType());
    }

    protected void gainedSelection(JGoSelection selection) {
    }

    protected void lostSelection(JGoSelection selection) {
    }

    public JGoObject redirectSelection() {
        return null;
    }

    public JGoObject getPartner() {
        return this.myHandleFor;
    }

    public void setPartner(JGoObject obj) {
        this.myHandleFor = obj;
    }

    public final void setHandleFor(JGoObject obj) {
        this.setPartner(obj);
    }

    public final JGoObject getHandleFor() {
        return this.getPartner();
    }

    public void setHandleType(int type) {
        int oldCursorType;
        this.myHandleType = type;
        int newCursorType = oldCursorType = this.getCursorType();
        switch (this.myHandleType) {
            case 1: {
                newCursorType = 6;
                break;
            }
            case 2: {
                newCursorType = 8;
                break;
            }
            case 3: {
                newCursorType = 7;
                break;
            }
            case 8: {
                newCursorType = 10;
                break;
            }
            case 4: {
                newCursorType = 11;
                break;
            }
            case 7: {
                newCursorType = 4;
                break;
            }
            case 6: {
                newCursorType = 9;
                break;
            }
            case 5: {
                newCursorType = 5;
                break;
            }
            case 91: {
                newCursorType = 12;
                break;
            }
            case 92: {
                newCursorType = 12;
                break;
            }
        }
        if (newCursorType != oldCursorType) {
            this.setCursorType(newCursorType);
        }
    }

    public int getHandleType() {
        return this.myHandleType;
    }

    public void setCursorType(int cursorType) {
        this.myCursorType = cursorType;
    }

    public int getCursorType() {
        return this.myCursorType;
    }

    public static int getDefaultHandleWidth() {
        return myDefaultHandleWidth;
    }

    public static void setDefaultHandleWidth(int w) {
        myDefaultHandleWidth = w;
    }

    public static int getDefaultHandleHeight() {
        return myDefaultHandleHeight;
    }

    public static void setDefaultHandleHeight(int h) {
        myDefaultHandleHeight = h;
    }
}

