/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.design.util.WSDLUtils;
import org.netbeans.modules.websvc.design.view.actions.FaultsPanel;
import org.netbeans.modules.websvc.design.view.actions.ParamModel;
import org.netbeans.modules.websvc.design.view.actions.ParametersPanel;
import org.netbeans.modules.websvc.design.view.actions.Utils;
import org.netbeans.modules.websvc.design.view.panels.ImportedSchemasPanel;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOperationFromSchemaPanel
extends JPanel {
    private File wsdlFile;
    private List<Schema> importedSchemas;
    private Set<Schema> newSchemas;
    private WSDLModel wsdlModel;
    private FaultsPanel faultsPanel;
    private static final String DOCUMENT_LITERAL = "Document/Literal";
    private static final String RPC_LITERAL = "RPC/Literal";
    private JLabel bindingStyleLabel;
    private ButtonGroup buttonGroup1;
    private JButton importSchemaBtn;
    private JLabel jLabel6;
    private JTabbedPane jTabbedPane1;
    private JLabel nameLabel;
    private JTextField opNameTxt;
    private ParametersPanel parametersPanel;
    private JComboBox returnCombo;
    private JLabel returnLabel;
    private JTextField schemaTypesTextField;
    private JLabel wsdlLabel;

    public AddOperationFromSchemaPanel(File file) {
        this.wsdlFile = file;
        this.initComponents();
        this.faultsPanel = new FaultsPanel(this.getWSDLModel());
        this.jTabbedPane1.addTab(NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"TTL_faultsPanel"), this.faultsPanel);
        this.opNameTxt.setText(NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"TXT_DefaultOperationName"));
        this.schemaTypesTextField.setText(NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"TXT_DefaultSchmas", (Object)file.getName()));
        this.bindingStyleLabel.setText(this.getBindingStyle());
        this.importSchemaBtn.setEnabled(true);
        this.importedSchemas = Utils.getImportedSchemas(this.getWSDLModel());
        try {
            this.populate();
        }
        catch (CatalogModelException catalogModelException) {
            ErrorManager.getDefault().notify((Throwable)catalogModelException);
        }
        this.newSchemas = new HashSet<Schema>();
        SchemaPanelListCellRenderer schemaPanelListCellRenderer = new SchemaPanelListCellRenderer();
        this.returnCombo.setRenderer(schemaPanelListCellRenderer);
    }

    public AddOperationFromSchemaPanel() {
        this.initComponents();
        this.opNameTxt.setText(NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"TXT_DefaultOperationName"));
    }

    public File getWsdlFile() {
        return this.wsdlFile;
    }

    public String getOperationName() {
        return this.opNameTxt.getText();
    }

    public List<Schema> getImportedSchemas() {
        return this.importedSchemas;
    }

    public List<ParamModel> getParameterTypes() {
        return this.parametersPanel.getParameters();
    }

    public ReferenceableSchemaComponent getReturnType() {
        Object object = this.returnCombo.getSelectedItem();
        if (object instanceof ReferenceableSchemaComponent) {
            return (ReferenceableSchemaComponent)object;
        }
        return null;
    }

    public List<ParamModel> getFaultTypes() {
        return this.faultsPanel.getFaults();
    }

    public Set<Schema> getNewSchemas() {
        return this.newSchemas;
    }

    private void populate() throws CatalogModelException {
        this.populateWithTypes(this.getWSDLModel());
    }

    WSDLModel getWSDLModel() {
        if (this.wsdlModel == null) {
            this.wsdlModel = WSDLUtils.getWSDLModel(FileUtil.toFileObject((File)this.wsdlFile), true);
        }
        return this.wsdlModel;
    }

    private String getBindingStyle() {
        if (WSDLUtils.isDocumentOriented(this.getWSDLModel())) {
            return DOCUMENT_LITERAL;
        }
        return RPC_LITERAL;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.nameLabel = new JLabel();
        this.wsdlLabel = new JLabel();
        this.returnLabel = new JLabel();
        this.opNameTxt = new JTextField();
        this.importSchemaBtn = new JButton();
        this.returnCombo = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.parametersPanel = new ParametersPanel(this.getWSDLModel());
        this.schemaTypesTextField = new JTextField();
        this.bindingStyleLabel = new JLabel();
        this.nameLabel.setLabelFor(this.opNameTxt);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"LBL_OperationName"));
        Mnemonics.setLocalizedText((JLabel)this.wsdlLabel, (String)NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"LBL_SchemaTypes"));
        this.returnLabel.setLabelFor(this.returnCombo);
        Mnemonics.setLocalizedText((JLabel)this.returnLabel, (String)NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"LBL_ReturnType"));
        Mnemonics.setLocalizedText((AbstractButton)this.importSchemaBtn, (String)NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"LBL_AddSchema"));
        this.importSchemaBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddOperationFromSchemaPanel.this.importSchemaBtnActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"LBL_BindingStyle"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"AddOperationFromSchemaPanel.parametersPanel.TabConstraints.tabTitle"), this.parametersPanel);
        this.schemaTypesTextField.setEditable(false);
        this.schemaTypesTextField.setText(NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"AddOperationFromSchemaPanel.wsdlTextField.text"));
        this.bindingStyleLabel.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.bindingStyleLabel, (String)DOCUMENT_LITERAL);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.jTabbedPane1, -1, 459, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.nameLabel).add((Component)this.wsdlLabel).add((Component)this.jLabel6).add((Component)this.returnLabel)).add(14, 14, 14).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.bindingStyleLabel, -2, 202, -2).add((Component)this.returnCombo, 0, 363, Short.MAX_VALUE).add(2, (Component)this.importSchemaBtn).add(2, (Component)this.opNameTxt, -1, 363, Short.MAX_VALUE).add((Component)this.schemaTypesTextField, -1, 363, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.opNameTxt, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.wsdlLabel).add((Component)this.schemaTypesTextField, -2, -1, -2)).add(6, 6, 6).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.importSchemaBtn).add(32, 32, 32)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.bindingStyleLabel, -2, 19, -2)).add(10, 10, 10))).add(13, 13, 13).add((Component)this.jTabbedPane1, -2, 257, -2).add(19, 19, 19).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.returnCombo, -2, -1, -2).add((Component)this.returnLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void importSchemaBtnActionPerformed(ActionEvent actionEvent) {
        Project project = this.getProject();
        ImportedSchemasPanel importedSchemasPanel = new ImportedSchemasPanel(project, this.getImportedSchemas().toArray(new Schema[this.getImportedSchemas().size()]));
        String string = NbBundle.getMessage(AddOperationFromSchemaPanel.class, (String)"TTL_AddImportedSchemasPanel");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)importedSchemasPanel, string);
        dialogDescriptor.setButtonListener((ActionListener)new ImportSchemaListener(importedSchemasPanel));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private Project getProject() {
        FileObject fileObject = FileUtil.toFileObject((File)this.getWsdlFile());
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    private void populateWithTypes(WSDLModel wSDLModel) {
        this.returnCombo.removeAllItems();
        this.returnCombo.addItem("void");
        try {
            List<ReferenceableSchemaComponent> list = Utils.getSchemaTypes(wSDLModel);
            for (ReferenceableSchemaComponent referenceableSchemaComponent : list) {
                this.returnCombo.addItem(referenceableSchemaComponent);
            }
        }
        catch (CatalogModelException catalogModelException) {
            ErrorManager.getDefault().notify((Throwable)catalogModelException);
        }
    }

    class ImportSchemaListener
    implements ActionListener {
        ImportedSchemasPanel panel;

        public ImportSchemaListener(ImportedSchemasPanel importedSchemasPanel) {
            this.panel = importedSchemasPanel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            AddOperationFromSchemaPanel.this.newSchemas.clear();
            if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                Set<Schema> set = this.panel.getSchemas();
                for (Schema schema : set) {
                    boolean bl = false;
                    for (Schema schema2 : AddOperationFromSchemaPanel.this.importedSchemas) {
                        if (!schema2.fromSameModel((SchemaComponent)schema)) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    AddOperationFromSchemaPanel.this.newSchemas.add(schema);
                }
                if (AddOperationFromSchemaPanel.this.newSchemas.size() > 0) {
                    try {
                        Schema schema;
                        AddOperationFromSchemaPanel.this.wsdlModel.startTransaction();
                        WSDLComponentFactory wSDLComponentFactory = AddOperationFromSchemaPanel.this.wsdlModel.getFactory();
                        schema = AddOperationFromSchemaPanel.this.wsdlModel.getDefinitions();
                        Types types = schema.getTypes();
                        for (Schema schema2 : AddOperationFromSchemaPanel.this.newSchemas) {
                            WSDLSchema wSDLSchema = wSDLComponentFactory.createWSDLSchema();
                            types.addExtensibilityElement((ExtensibilityElement)wSDLSchema);
                            SchemaModel schemaModel = wSDLSchema.getSchemaModel();
                            Schema schema3 = schemaModel.getSchema();
                            schema3.setTargetNamespace(schema.getTargetNamespace());
                            Import import_ = schemaModel.getFactory().createImport();
                            import_.setNamespace(schema2.getTargetNamespace());
                            ModelSource modelSource = schema2.getModel().getModelSource();
                            FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
                            import_.setSchemaLocation(fileObject.getURL().toString());
                            schema3.addExternalReference((SchemaModelReference)import_);
                        }
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                    }
                    finally {
                        AddOperationFromSchemaPanel.this.wsdlModel.endTransaction();
                    }
                    AddOperationFromSchemaPanel.this.parametersPanel.refreshSchemaTypes();
                    AddOperationFromSchemaPanel.this.populateWithTypes(AddOperationFromSchemaPanel.this.wsdlModel);
                }
            }
        }
    }

    class SchemaPanelListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        SchemaPanelListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ReferenceableSchemaComponent) {
                this.setText(Utils.getDisplayName((ReferenceableSchemaComponent)object));
            } else if (object instanceof String) {
                this.setText((String)object);
            }
            return this;
        }
    }
}

