/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.wadl;

import com.sun.jersey.api.MediaTypes;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.impl.model.MediaTypeHelper;
import com.sun.jersey.impl.model.method.ResourceHttpOptionsMethod;
import com.sun.jersey.impl.model.method.ResourceMethod;
import com.sun.jersey.impl.wadl.WadlGenerator;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Resource;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

final class WadlMethodFactory {
    WadlMethodFactory() {
    }

    private static Application genatateApplication(UriInfo info, AbstractResource resource, String path) {
        Application a = path == null ? WadlGenerator.generate(resource) : WadlGenerator.generate(resource, path);
        a.getResources().setBase(info.getBaseUri().toString());
        Resource r = a.getResources().getResource().get(0);
        r.setPath(info.getBaseUri().relativize(info.getAbsolutePath()).toString());
        r.getParam().clear();
        return a;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WadlOptionsMethodDispatcher
    extends ResourceHttpOptionsMethod.OptionsRequestDispatcher {
        private final AbstractResource resource;
        private final String path;

        WadlOptionsMethodDispatcher(Map<String, List<ResourceMethod>> methods, AbstractResource resource, String path) {
            super(methods);
            this.resource = resource;
            this.path = path;
        }

        @Override
        public void dispatch(Object o, HttpContext context) {
            Application a = WadlMethodFactory.genatateApplication(context.getUriInfo(), this.resource, this.path);
            context.getResponse().setResponse(Response.ok((Object)a, (MediaType)MediaTypes.WADL).header("Allow", (Object)this.allow).build());
        }

        private Application generate() {
            return this.path == null ? WadlGenerator.generate(this.resource) : WadlGenerator.generate(this.resource, this.path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WadlOptionsMethod
    extends ResourceMethod {
        public WadlOptionsMethod(Map<String, List<ResourceMethod>> methods, AbstractResource resource, String path) {
            super("OPTIONS", UriTemplate.EMPTY, MediaTypeHelper.GENERAL_MEDIA_TYPE_LIST, MediaTypeHelper.GENERAL_MEDIA_TYPE_LIST, new WadlOptionsMethodDispatcher(methods, resource, path));
        }

        public String toString() {
            return "WADL OPTIONS method";
        }
    }
}

