/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.uri.rules;

import com.sun.jersey.api.Responses;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.impl.model.HttpHelper;
import com.sun.jersey.impl.model.method.ResourceMethod;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpMethodRule
implements UriRule {
    private static final Logger LOGGER = Logger.getLogger(HttpMethodRule.class.getName());
    private final Map<String, List<ResourceMethod>> map;
    private final String allow;
    private final boolean isSubResource;

    public HttpMethodRule(Map<String, List<ResourceMethod>> methods) {
        this(methods, false);
    }

    public HttpMethodRule(Map<String, List<ResourceMethod>> methods, boolean isSubResource) {
        this.map = methods;
        this.isSubResource = isSubResource;
        this.allow = this.getAllow(methods);
    }

    private String getAllow(Map<String, List<ResourceMethod>> methods) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (String method : methods.keySet()) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(method);
        }
        return s.toString();
    }

    @Override
    public boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        LinkedList<ResourceMethod> matches;
        if (path.length() > 0) {
            return false;
        }
        HttpRequestContext request = context.getRequest();
        HttpResponseContext response = context.getResponse();
        String httpMethod = request.getHttpMethod();
        MediaType contentType = HttpHelper.getContentType(request);
        List<ResourceMethod> methods = this.map.get(httpMethod);
        if (methods == null) {
            response.setResponse(Responses.methodNotAllowed().header("Allow", (Object)this.allow).build());
            return false;
        }
        List accept = request.getAcceptableMediaTypes();
        MatchStatus s = this.match(methods, contentType, accept, matches = new LinkedList<ResourceMethod>());
        if (s == MatchStatus.MATCH) {
            ResourceMethod method = matches.get(0);
            if (this.isSubResource) {
                context.pushResource(resource, method.getTemplate());
                context.setTemplateValues(method.getTemplate().getTemplateVariables());
            }
            method.getDispatcher().dispatch(resource, context);
            if (!httpMethod.equals("HEAD")) {
                this.verifyResponse(method, accept, response);
            }
            return true;
        }
        if (s == MatchStatus.NO_MATCH_FOR_CONSUME) {
            throw new WebApplicationException(Responses.unsupportedMediaType().build());
        }
        if (s == MatchStatus.NO_MATCH_FOR_PRODUCE) {
            throw new WebApplicationException(Responses.notAcceptable().build());
        }
        return true;
    }

    private boolean hasMessageBody(MultivaluedMap<String, String> headers) {
        return headers.getFirst((Object)"Content-Length") != null || headers.getFirst((Object)"Transfer-Encoding") != null;
    }

    private MatchStatus match(List<ResourceMethod> methods, MediaType contentType, List<MediaType> accept, LinkedList<ResourceMethod> matches) {
        if (contentType != null) {
            for (ResourceMethod method : methods) {
                if (!method.consumes(contentType)) continue;
                matches.add(method);
            }
            if (matches.isEmpty()) {
                return MatchStatus.NO_MATCH_FOR_CONSUME;
            }
        } else {
            matches.addAll(methods);
        }
        ListIterator i = matches.listIterator();
        int currentQuality = 0;
        int currentIndex = 0;
        while (i.hasNext()) {
            int index = i.nextIndex();
            int quality = ((ResourceMethod)i.next()).produces(accept);
            if (quality == -1) {
                i.remove();
                continue;
            }
            if (quality < currentQuality) {
                i.remove();
                continue;
            }
            if (quality <= currentQuality) continue;
            currentIndex = index;
            currentQuality = quality;
        }
        if (matches.isEmpty()) {
            return MatchStatus.NO_MATCH_FOR_PRODUCE;
        }
        while (currentIndex > 0) {
            matches.removeFirst();
            --currentIndex;
        }
        return MatchStatus.MATCH;
    }

    private void verifyResponse(ResourceMethod method, List<MediaType> accept, HttpResponseContext responseContext) {
        Object entity = responseContext.getEntity();
        MediaType contentType = HttpHelper.getContentType(responseContext.getHttpHeaders().getFirst((Object)"Content-Type"));
        if (!responseContext.isCommitted() && contentType != null && entity == null) {
            String ct = contentType.toString();
            String error = "The \"Content-Type\" header is set to " + ct + ", but the response has no entity";
            LOGGER.severe(error);
            throw new WebApplicationException(Response.serverError().entity((Object)error).type("text/plain").build());
        }
        if (contentType != null && !method.produces(contentType)) {
            if (!HttpHelper.produces(contentType, accept)) {
                String error = ImplMessages.RESOURCE_NOT_ACCEPTABLE(method, contentType);
                LOGGER.severe(error);
                throw new WebApplicationException(Response.serverError().entity((Object)error).type("text/plain").build());
            }
            String error = ImplMessages.RESOURCE_MIMETYPE_NOT_IN_PRODUCE_MIME(method, contentType, method.getProduceMime());
            LOGGER.warning(error);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MatchStatus {
        MATCH,
        NO_MATCH_FOR_CONSUME,
        NO_MATCH_FOR_PRODUCE;

    }
}

