/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.json;

import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.impl.json.JSONTransformer;
import com.sun.jersey.impl.json.writer.JsonXmlStreamWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamWriter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONMarshaller
implements Marshaller {
    private final JAXBContext jaxbContext;
    private final Marshaller jaxbMarshaller;
    private JSONJAXBContext.JSONNotation jsonNotation;
    private boolean jsonEnabled;
    private boolean jsonRootUnwrapping;
    private Collection<String> arrays;
    private Collection<String> nonStrings;
    private Map<String, String> xml2jsonNamespace;

    public JSONMarshaller(JAXBContext jaxbContext, Map<String, Object> properties) throws JAXBException {
        try {
            this.jaxbContext = jaxbContext;
            this.jaxbMarshaller = jaxbContext.createMarshaller();
            this.setProperties(properties);
        }
        catch (PropertyException ex) {
            Logger.getLogger(JSONMarshaller.class.getName()).log(Level.SEVERE, null, ex);
            throw new JAXBException((Throwable)ex);
        }
    }

    public void marshal(Object jaxbObject, Result result) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, result);
    }

    public void marshal(Object jaxbObject, OutputStream os) throws JAXBException {
        if (this.jsonEnabled) {
            this.jaxbMarshaller.marshal(jaxbObject, this.createXmlStreamWriter(new OutputStreamWriter(os, this.getCharset())));
        } else {
            this.jaxbMarshaller.marshal(jaxbObject, os);
        }
    }

    public void marshal(Object jaxbObject, File file) throws JAXBException {
        if (this.jsonEnabled) {
            try {
                this.jaxbMarshaller.marshal(jaxbObject, this.createXmlStreamWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getCharset())));
            }
            catch (IOException ex) {
                Logger.getLogger(JSONMarshaller.class.getName()).log(Level.SEVERE, "IOException caught when marshalling into a file.", ex);
                throw new JAXBException(ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.jaxbMarshaller.marshal(jaxbObject, file);
        }
    }

    public void marshal(Object jaxbObject, Writer writer) throws JAXBException {
        if (this.jsonEnabled) {
            this.jaxbMarshaller.marshal(jaxbObject, this.createXmlStreamWriter(writer));
        } else {
            this.jaxbMarshaller.marshal(jaxbObject, writer);
        }
    }

    public void marshal(Object jaxbObject, ContentHandler handler) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, handler);
    }

    public void marshal(Object jaxbObject, Node node) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, node);
    }

    public void marshal(Object jaxbObject, XMLStreamWriter writer) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, writer);
    }

    public void marshal(Object jaxbObject, XMLEventWriter writer) throws JAXBException {
        this.jaxbMarshaller.marshal(jaxbObject, writer);
    }

    public Node getNode(Object jaxbObject) throws JAXBException {
        return this.jaxbMarshaller.getNode(jaxbObject);
    }

    public void setProperty(String key, Object value) throws PropertyException {
        if ("com.sun.ws.rest.impl.json.enabled".equals(key)) {
            this.jsonEnabled = (Boolean)value;
        } else if ("com.sun.ws.rest.impl.json.notation".equals(key)) {
            this.jsonNotation = JSONJAXBContext.JSONNotation.valueOf((String)value);
        } else if ("com.sun.ws.rest.impl.json.root.unwrapping".equals(key)) {
            this.jsonRootUnwrapping = (Boolean)value;
        } else if ("com.sun.ws.rest.impl.json.arrays".equals(key)) {
            try {
                this.arrays = JSONTransformer.asCollection((String)value);
            }
            catch (JSONException e) {
                throw new PropertyException("JSON exception when trying to set com.sun.ws.rest.impl.json.arrays property.", (Throwable)e);
            }
        } else if ("com.sun.ws.rest.impl.json.non.strings".equals(key)) {
            try {
                this.nonStrings = JSONTransformer.asCollection((String)value);
            }
            catch (JSONException e) {
                throw new PropertyException("JSON exception when trying to set com.sun.ws.rest.impl.json.non.strings property.", (Throwable)e);
            }
        } else if ("com.sun.ws.rest.impl.json.xml.to.json.ns".equals(key)) {
            try {
                this.xml2jsonNamespace = JSONTransformer.asMap((String)value);
            }
            catch (JSONException e) {
                throw new PropertyException("JSON exception when trying to set com.sun.ws.rest.impl.json.xml.to.json.ns property.", (Throwable)e);
            }
        } else if (!key.startsWith("com.sun.ws.rest.impl.json.")) {
            this.jaxbMarshaller.setProperty(key, value);
        }
    }

    public Object getProperty(String key) throws PropertyException {
        if ("com.sun.ws.rest.impl.json.enabled".equals(key)) {
            return this.jsonEnabled;
        }
        if ("com.sun.ws.rest.impl.json.notation".equals(key)) {
            return this.jsonNotation.name();
        }
        if ("com.sun.ws.rest.impl.json.root.unwrapping".equals(key)) {
            return this.jsonRootUnwrapping;
        }
        if ("com.sun.ws.rest.impl.json.arrays".equals(key)) {
            return JSONTransformer.asJsonArray(this.arrays);
        }
        if ("com.sun.ws.rest.impl.json.non.strings".equals(key)) {
            return JSONTransformer.asJsonArray(this.nonStrings);
        }
        if ("com.sun.ws.rest.impl.json.xml.to.json.ns".equals(key)) {
            return JSONTransformer.asJsonObject(this.xml2jsonNamespace);
        }
        if (key.startsWith("com.sun.ws.rest.impl.json.")) {
            return null;
        }
        return this.jaxbMarshaller.getProperty(key);
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.jaxbMarshaller.setEventHandler(handler);
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.jaxbMarshaller.getEventHandler();
    }

    public void setAdapter(XmlAdapter adapter) {
        this.jaxbMarshaller.setAdapter(adapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        this.jaxbMarshaller.setAdapter(type, adapter);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.jaxbMarshaller.getAdapter(type);
    }

    public void setAttachmentMarshaller(AttachmentMarshaller marshaller) {
        this.jaxbMarshaller.setAttachmentMarshaller(marshaller);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        return this.jaxbMarshaller.getAttachmentMarshaller();
    }

    public void setSchema(Schema schema) {
        this.jaxbMarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.jaxbMarshaller.getSchema();
    }

    public void setListener(Marshaller.Listener listener) {
        this.jaxbMarshaller.setListener(listener);
    }

    public Marshaller.Listener getListener() {
        return this.jaxbMarshaller.getListener();
    }

    private void setProperties(Map<String, Object> properties) throws PropertyException {
        if (null != properties) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    private XMLStreamWriter createXmlStreamWriter(Writer writer) {
        Object xmlStreamWriter;
        if (JSONJAXBContext.JSONNotation.MAPPED == this.jsonNotation) {
            xmlStreamWriter = new JsonXmlStreamWriter(writer, this.jsonRootUnwrapping, this.arrays, this.nonStrings);
        } else if (JSONJAXBContext.JSONNotation.MAPPED_JETTISON == this.jsonNotation) {
            Configuration jmConfig = null == this.xml2jsonNamespace ? new Configuration() : new Configuration(this.xml2jsonNamespace);
            xmlStreamWriter = new MappedXMLStreamWriter(new MappedNamespaceConvention(jmConfig), writer);
        } else {
            xmlStreamWriter = new BadgerFishXMLStreamWriter(writer);
        }
        return xmlStreamWriter;
    }

    private Charset getCharset() throws JAXBException {
        String charset = (String)this.jaxbMarshaller.getProperty("jaxb.encoding");
        return charset == null ? Charset.forName("UTF-8") : Charset.forName(charset);
    }
}

