/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.application;

import com.sun.jersey.impl.application.ComponentProviderCache;
import com.sun.jersey.impl.application.InjectableProviderFactory;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.ContextResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextResolverFactory {
    private static final Logger LOGGER = Logger.getLogger(ContextResolverFactory.class.getName());
    private final List<ContextResolverInjectableProvider> injectables = new ArrayList<ContextResolverInjectableProvider>();

    public ContextResolverFactory(ComponentProviderCache componentProviderCache, InjectableProviderFactory ipf) {
        Set<ContextResolver> providers = componentProviderCache.getProviders(ContextResolver.class);
        HashMap typeMap = new HashMap();
        for (ContextResolver provider : providers) {
            Set<ParameterizedType> types = this.getTypes(provider.getClass());
            this.addTypes(typeMap, types, provider);
        }
        this.reduceToInjectables(typeMap);
        for (ContextResolverInjectableProvider i : this.injectables) {
            ipf.add(i);
        }
    }

    private Set<ParameterizedType> getTypes(Class providerClass) {
        HashSet<ParameterizedType> types = new HashSet<ParameterizedType>();
        block0: while (providerClass != null) {
            for (Type type : providerClass.getGenericInterfaces()) {
                ParameterizedType pType;
                if (!(type instanceof ParameterizedType) || (pType = (ParameterizedType)type).getRawType() != ContextResolver.class) continue;
                types.add(pType);
                break block0;
            }
            providerClass = providerClass.getSuperclass();
        }
        return types;
    }

    private void addTypes(Map<ParameterizedType, List<ContextResolver<?>>> typeMap, Set<ParameterizedType> types, ContextResolver<?> provider) {
        for (ParameterizedType type : types) {
            List<ContextResolver<?>> l = typeMap.get(type);
            if (l == null) {
                l = new ArrayList();
                typeMap.put(type, l);
            }
            l.add(provider);
        }
    }

    private void reduceToInjectables(Map<ParameterizedType, List<ContextResolver<?>>> typeMap) {
        for (Map.Entry<ParameterizedType, List<ContextResolver<?>>> e : typeMap.entrySet()) {
            this.injectables.add(new ContextResolverInjectableProvider((Type)e.getKey(), this.reduce(e.getValue())));
        }
    }

    private ContextResolver reduce(List<ContextResolver<?>> crs) {
        if (crs.size() == 1) {
            return crs.get(0);
        }
        return new ContextResolverAdapter(crs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContextResolverAdapter
    implements ContextResolver {
        private final List<ContextResolver<?>> crs;

        ContextResolverAdapter(List<ContextResolver<?>> crs) {
            this.crs = crs;
        }

        public Object getContext(Class objectType) {
            for (ContextResolver<?> cr : this.crs) {
                Object c = cr.getContext(objectType);
                if (c == null) continue;
                return c;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContextResolverInjectableProvider
    extends SingletonTypeInjectableProvider<Context, ContextResolver> {
        ContextResolverInjectableProvider(Type t, ContextResolver instance) {
            super(t, instance);
        }
    }
}

