/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.samples;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.compapp.projects.jbi.ui.actions.AddProjectAction;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Util {
    private static final String[] JAVAEE_ARTIFACT_TYPES = new String[]{"j2ee_archive", "war", "CAPS.asa"};
    public static final String RESERVATION_PARTNER_SERVICES = "ReservationPartnerServices";
    public static final String BPEL_PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/j2ee-bpelpro/1";
    public static final String COMPAPP_PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/j2ee-jbi/1";

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFile(InputStream inputStream, FileObject fileObject) throws IOException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static void setProjectName(FileObject fileObject, String string, String string2, String string3) {
        Util.renameInXml(fileObject, string, string2);
        Util.renameInProperties(fileObject, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameInProperties(FileObject fileObject, String string, String string2) {
        FileObject fileObject2 = fileObject.getFileObject("nbproject/project.properties");
        try {
            String string3 = Util.readContent(fileObject2);
            string3 = Util.replace(string3, string2, string);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(), "UTF-8"));
            try {
                bufferedWriter.write(string3);
            }
            finally {
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readContent(FileObject fileObject) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), "UTF-8"));
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuffer.append(string2);
                stringBuffer.append(string);
                string2 = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
        return stringBuffer.toString();
    }

    private static void renameInXml(FileObject fileObject, String string, String string2) {
        try {
            File file = FileUtil.toFile((FileObject)fileObject.getFileObject("nbproject/project.xml"));
            Document document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, null, null);
            NodeList nodeList = document.getElementsByTagNameNS(string, "name");
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    Util.replaceText(element, string2);
                }
                Util.saveXml(document, fileObject, "nbproject/project.xml");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public static void addJbiModule(FileObject fileObject, FileObject fileObject2) throws IOException {
        Project project = ProjectManager.getDefault().findProject(fileObject);
        Project project2 = ProjectManager.getDefault().findProject(fileObject2);
        AddProjectAction addProjectAction = new AddProjectAction();
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project2.getLookup().lookup(AntArtifactProvider.class);
        AntArtifact[] antArtifactArray = null;
        if (antArtifactProvider != null) {
            antArtifactArray = Util.getFilteredAntArtifacts(antArtifactProvider.getBuildArtifacts());
        }
        if (antArtifactArray != null) {
            for (AntArtifact antArtifact : antArtifactArray) {
                addProjectAction.addProject(project, antArtifact);
            }
        }
    }

    private static AntArtifact[] getFilteredAntArtifacts(AntArtifact[] antArtifactArray) {
        if (antArtifactArray == null) {
            return null;
        }
        ArrayList<AntArtifact> arrayList = new ArrayList<AntArtifact>();
        for (AntArtifact antArtifact : antArtifactArray) {
            for (String string : JAVAEE_ARTIFACT_TYPES) {
                if (!antArtifact.getType().startsWith(string)) continue;
                arrayList.add(antArtifact);
            }
        }
        return arrayList.toArray(new AntArtifact[arrayList.size()]);
    }

    private static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf(string2, n);
        while (n2 >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        if (n > 0) {
            stringBuffer.append(string.substring(n));
            return stringBuffer.toString();
        }
        return string;
    }

    private static void replaceText(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            text.setNodeValue(string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document document, FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }
}

