/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.samples;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bpel.samples.SampleWizardPanel;
import org.netbeans.modules.bpel.samples.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SampleWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    public static final String PROJECT_DIR = "projdir";
    public static final String NAME = "name";
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private FileObject dir;

    protected WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new SampleWizardPanel()};
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(SampleWizardIterator.class, (String)"MSG_SampleProject")};
    }

    protected FileObject getProjectDir() {
        return this.dir;
    }

    public Set<FileObject> instantiate() throws IOException {
        final LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                File file = FileUtil.normalizeFile((File)((File)SampleWizardIterator.this.wiz.getProperty(SampleWizardIterator.PROJECT_DIR)));
                file.mkdirs();
                SampleWizardIterator.this.dir = FileUtil.toFileObject((File)file);
                FileObject fileObject = Templates.getTemplate((WizardDescriptor)SampleWizardIterator.this.wiz);
                String string = (String)SampleWizardIterator.this.wiz.getProperty(SampleWizardIterator.NAME);
                SampleWizardIterator.this.dir = SampleWizardIterator.this.dir.createFolder(string);
                file = FileUtil.toFile((FileObject)SampleWizardIterator.this.dir);
                Util.unZipFile(fileObject.getInputStream(), SampleWizardIterator.this.dir);
                Util.setProjectName(SampleWizardIterator.this.dir, "http://www.netbeans.org/ns/j2ee-bpelpro/1", string, fileObject.getName());
                linkedHashSet.add(SampleWizardIterator.this.dir);
                FileObject fileObject2 = SampleWizardIterator.this.dir.getParent();
                linkedHashSet.addAll(SampleWizardIterator.this.createCompositeApplicationProject(fileObject2, string + "Application"));
            }
        });
        return linkedHashSet;
    }

    protected abstract Set<FileObject> createCompositeApplicationProject(FileObject var1, String var2) throws IOException;

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz.putProperty(PROJECT_DIR, null);
        this.wiz.putProperty(NAME, null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }
}

