/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaMethod;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaParameter;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.spi.MethodNodeActionsProvider;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNode;
import org.netbeans.modules.websvc.saas.util.SaasTransferable;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.netbeans.modules.websvc.saas.util.TypeUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class WsdlMethodNode
extends AbstractNode {
    WsdlSaasMethod method;
    private Transferable transferable;

    public WsdlMethodNode(WsdlSaasMethod wsdlSaasMethod) {
        this(wsdlSaasMethod, new InstanceContent());
    }

    protected WsdlMethodNode(WsdlSaasMethod wsdlSaasMethod, InstanceContent instanceContent) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.method = wsdlSaasMethod;
        instanceContent.add((Object)wsdlSaasMethod);
        this.transferable = ExTransferable.create((Transferable)new SaasTransferable((Object)wsdlSaasMethod, SaasTransferable.WSDL_METHOD_FLAVORS));
    }

    public String getDisplayName() {
        return this.method.getName();
    }

    public String getShortDescription() {
        JavaMethod javaMethod = this.method.getJavaMethod();
        String string = javaMethod.getReturnType().getFormalName() + " " + javaMethod.getName() + "(";
        Iterator iterator = javaMethod.getParametersList().iterator();
        JavaParameter javaParameter = null;
        while (iterator.hasNext()) {
            javaParameter = (JavaParameter)iterator.next();
            String string2 = TypeUtil.getParameterType((JavaParameter)javaParameter);
            string = string + string2 + " " + javaParameter.getName();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        string = string + ")";
        return string;
    }

    public Action[] getActions(boolean bl) {
        List<Action> list = SaasNode.getActions(this.getLookup());
        for (MethodNodeActionsProvider methodNodeActionsProvider : SaasUtil.getMethodNodeActionsProviders()) {
            for (Action action : methodNodeActionsProvider.getMethodActions(this.getLookup())) {
                list.add(action);
            }
        }
        return list.toArray(new Action[list.size()]);
    }

    public Action getPreferredAction() {
        Action[] actionArray = this.getActions(true);
        return actionArray.length > 0 ? actionArray[0] : null;
    }

    public Image getIcon(int n) {
        return this.getMethodIcon();
    }

    public Image getOpenedIcon(int n) {
        return this.getMethodIcon();
    }

    private Image getMethodIcon() {
        JavaMethod javaMethod = this.method.getJavaMethod();
        if (javaMethod != null && !"void".equals(javaMethod.getReturnType().getRealName())) {
            Image image = Utilities.loadImage((String)"org/netbeans/modules/websvc/manager/resources/methodicon.png");
            Image image2 = Utilities.loadImage((String)"org/netbeans/modules/websvc/manager/resources/table_dp_badge.png");
            int n = image.getWidth(null) - image2.getWidth(null);
            int n2 = image.getHeight(null) - image2.getHeight(null);
            return Utilities.mergeImages((Image)image, (Image)image2, (int)n, (int)n2);
        }
        return Utilities.loadImage((String)"org/netbeans/modules/websvc/manager/resources/methodicon.png");
    }

    protected Sheet createSheet() {
        JavaMethod javaMethod = this.method.getJavaMethod();
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("data");
        if (set == null) {
            set = new Sheet.Set();
            set.setName("data");
            set.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_INFO"));
            set.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_INFO"));
            sheet.put(set);
        }
        if (javaMethod == null) {
            return sheet;
        }
        try {
            Sheet.Set set2;
            Iterator iterator;
            String string;
            PropertySupport.Reflection reflection = new PropertySupport.Reflection((Object)javaMethod, String.class, "getName", null);
            reflection.setName("name");
            reflection.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_NAME"));
            reflection.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_NAME"));
            set.put((Node.Property)reflection);
            String string2 = javaMethod.getReturnType().getRealName() + " " + javaMethod.getName() + "(";
            Iterator iterator2 = javaMethod.getParametersList().iterator();
            JavaParameter javaParameter = null;
            while (iterator2.hasNext()) {
                javaParameter = (JavaParameter)iterator2.next();
                string2 = string2 + javaParameter.getType().getRealName() + " " + javaParameter.getName();
                if (!iterator2.hasNext()) continue;
                string2 = string2 + ", ";
            }
            string2 = string2 + ")";
            Iterator iterator3 = javaMethod.getExceptions();
            if (iterator3.hasNext()) {
                string2 = string2 + " throws";
                while (iterator3.hasNext()) {
                    string = (String)iterator3.next();
                    string2 = string2 + " " + string;
                    if (!iterator3.hasNext()) continue;
                    string2 = string2 + ",";
                }
            }
            reflection = new PropertySupport.Reflection((Object)string2, String.class, "toString", null);
            reflection.setName("signature");
            reflection.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_SIGNATURE"));
            reflection.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_SIGNATURE"));
            set.put((Node.Property)reflection);
            reflection = new PropertySupport.Reflection((Object)javaMethod.getReturnType(), String.class, "getRealName", null);
            reflection.setName("returntype");
            reflection.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_RETURNTYPE"));
            reflection.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_RETURNTYPE"));
            set.put((Node.Property)reflection);
            string = sheet.get("parameters");
            if (string == null) {
                string = new Sheet.Set();
                string.setName("parameters");
                string.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_PARAMDIVIDER"));
                string.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_PARAMDIVIDER"));
                sheet.put((Sheet.Set)string);
            }
            if ((iterator = javaMethod.getParametersList().iterator()).hasNext()) {
                reflection = new PropertySupport.Reflection((Object)NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_PARAMTYPE"), String.class, "toString", null);
                reflection.setName("paramdivider2");
                set2 = null;
                int n = 0;
                while (iterator.hasNext()) {
                    set2 = (JavaParameter)iterator.next();
                    reflection = set2.getType().isHolder() ? new PropertySupport.Reflection((Object)TypeUtil.getParameterType((JavaParameter)set2), String.class, "toString", null) : new PropertySupport.Reflection((Object)set2.getType(), String.class, "getRealName", null);
                    reflection.setName("paramname" + n);
                    reflection.setDisplayName(set2.getName());
                    reflection.setShortDescription(set2.getName() + "-" + set2.getType().getRealName());
                    string.put((Node.Property)reflection);
                    ++n;
                }
            }
            if ((set2 = sheet.get("exceptions")) == null) {
                set2 = new Sheet.Set();
                set2.setName("exceptions");
                set2.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_EXCEPTIONDIVIDER"));
                set2.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_EXCEPTIONDIVIDER"));
                sheet.put(set2);
            }
            Iterator iterator4 = javaMethod.getExceptions();
            String string3 = null;
            int n = 0;
            while (iterator4.hasNext()) {
                string3 = (String)iterator4.next();
                reflection = new PropertySupport.Reflection((Object)string3, String.class, "toString", null);
                reflection.setName("exception" + n);
                reflection.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_PARAMTYPE"));
                reflection.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_PARAMTYPE"));
                set2.put((Node.Property)reflection);
                ++n;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, noSuchMethodException.getLocalizedMessage(), noSuchMethodException);
        }
        return sheet;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public Transferable clipboardCopy() throws IOException {
        if (this.method.getSaas().getState() == Saas.State.READY) {
            return SaasTransferable.addFlavors((Transferable)this.transferable);
        }
        this.method.getSaas().toStateReady(false);
        return super.clipboardCopy();
    }
}

