/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.tree.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.ui.tree.DataObjectHolder;
import org.netbeans.modules.soa.ui.tree.ExtTreeModel;
import org.netbeans.modules.soa.ui.tree.TreeItem;
import org.netbeans.modules.soa.ui.tree.TreeItemFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeFinderProcessor {
    private ExtTreeModel mTreeModel;

    public TreeFinderProcessor(ExtTreeModel extTreeModel) {
        this.mTreeModel = extTreeModel;
    }

    public TreePath findFirstNode(List<TreeItemFinder> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object object = this.mTreeModel.getRoot();
        Stack<Object> stack = new Stack<Object>();
        stack.push(object);
        for (TreeItemFinder treeItemFinder : list) {
            boolean bl = this.findFirstChild(stack, treeItemFinder, -1);
            if (bl) continue;
            return null;
        }
        TreePath treePath = new TreePath(stack.toArray());
        return treePath;
    }

    public boolean findFirstChild(Stack<Object> stack, TreeItemFinder treeItemFinder, int n) {
        Object object = stack.peek();
        List<Object> list = this.mTreeModel.getChildren(object);
        if (list != null && list.size() != 0) {
            --n;
            for (Object object2 : list) {
                stack.push(object2);
                if (this.checkNode(stack, treeItemFinder, n)) {
                    return true;
                }
                stack.pop();
            }
        }
        return false;
    }

    public List<Object> findAllDataObjects(List<TreeItemFinder> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        Object object = this.mTreeModel.getRoot();
        Stack<Object> stack = new Stack<Object>();
        stack.push(object);
        for (TreeItemFinder object2 : list) {
            this.fillNodesList(arrayList, stack, object2, -1, false);
        }
        ArrayList arrayList2 = new ArrayList();
        for (List list2 : arrayList) {
            Object e = list2.get(list2.size() - 1);
            assert (e instanceof DataObjectHolder);
            Object DataObject2 = ((DataObjectHolder)e).getDataObject();
            arrayList2.add(DataObject2);
        }
        return arrayList2;
    }

    public boolean checkNode(Stack<Object> stack, TreeItemFinder treeItemFinder, int n) {
        Object object = stack.peek();
        Object object2 = this.getDataObject(object);
        TreeItemFinder.FindResult findResult = treeItemFinder.process(object2, null);
        if (findResult.isFit()) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        if (findResult.drillDeeper()) {
            return this.findFirstChild(stack, treeItemFinder, n);
        }
        return false;
    }

    protected Object getDataObject(Object object) {
        if (object instanceof DataObjectHolder) {
            return ((DataObjectHolder)object).getDataObject();
        }
        return object;
    }

    public void fillNodesList(List<List<Object>> list, Stack<Object> stack, TreeItemFinder treeItemFinder, int n, boolean bl) {
        List<Object> list2;
        Object object = stack.peek();
        Object object2 = this.getDataObject(object);
        TreeItemFinder.FindResult findResult = treeItemFinder.process(object2, null);
        if (findResult.isFit()) {
            list2 = new ArrayList<Object>(stack);
            list.add(list2);
            if (!bl) {
                return;
            }
        }
        if (n == 0) {
            return;
        }
        if (findResult.drillDeeper()) {
            list2 = this.mTreeModel.getChildren(object);
            --n;
            for (Object object3 : list2) {
                stack.push(object3);
                this.fillNodesList(list, stack, treeItemFinder, n, bl);
                stack.pop();
            }
        }
    }

    public TreePath findChild(TreePath treePath, TreeItemFinder treeItemFinder) {
        if (treeItemFinder == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        assert (object instanceof TreeItem);
        List<Object> list = this.mTreeModel.getChildren(object);
        for (Object object2 : list) {
            Object object3 = this.getDataObject(object2);
            assert (object3 != null);
            TreeItemFinder.FindResult findResult = treeItemFinder.process(object3, null);
            if (!findResult.isFit()) continue;
            return treePath.pathByAddingChild(object2);
        }
        return null;
    }

    public List<TreePath> findChildren(TreePath treePath, TreeItemFinder treeItemFinder) {
        if (treeItemFinder == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        assert (object instanceof TreeItem);
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        List<Object> list = this.mTreeModel.getChildren(object);
        for (Object object2 : list) {
            Object object3 = this.getDataObject(object2);
            assert (object3 != null);
            TreeItemFinder.FindResult findResult = treeItemFinder.process(object3, null);
            if (!findResult.isFit()) continue;
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            arrayList.add(treePath2);
        }
        return arrayList;
    }

    public TreePath findChildByDataObj(TreePath treePath, Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = treePath.getLastPathComponent();
        assert (object2 instanceof TreeItem);
        List<Object> list = this.mTreeModel.getChildren(object2);
        for (Object object3 : list) {
            Object object4 = this.getDataObject(object3);
            assert (object4 != null);
            if (!object4.equals(object)) continue;
            TreePath treePath2 = treePath.pathByAddingChild(object3);
            return treePath2;
        }
        return null;
    }

    public TreePath findChildByIndex(TreePath treePath, int n) {
        if (n < 0) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        assert (object instanceof TreeItem);
        List<Object> list = this.mTreeModel.getChildren(object);
        if (n >= list.size()) {
            return null;
        }
        Object object2 = list.get(n);
        TreePath treePath2 = treePath.pathByAddingChild(object2);
        return treePath2;
    }
}

