/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.tree.impl;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.ui.tree.DataObjectHolder;
import org.netbeans.modules.soa.ui.tree.SoaTreeModel;
import org.netbeans.modules.soa.ui.tree.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SoaTreeNodeImpl
implements DataObjectHolder<Object> {
    private Object mDataObject;
    private String mDisplayName;
    private Icon mIcon;
    private SoaTreeNodeImpl mParent;
    private List<SoaTreeNodeImpl> mChildren;
    private Boolean mIsLeaf;
    private AtomicReference<TreeItem> mTreeItem = new AtomicReference();

    public SoaTreeNodeImpl(SoaTreeNodeImpl soaTreeNodeImpl, Object object) {
        assert (object != null);
        this.mParent = soaTreeNodeImpl;
        this.mDataObject = object;
    }

    @Override
    public Object getDataObject() {
        return this.mDataObject;
    }

    public void discardCachedData() {
        this.mDisplayName = null;
        this.mIcon = null;
        this.mIsLeaf = null;
    }

    public SoaTreeNodeImpl getParent() {
        return this.mParent;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public void setDisplayName(String string) {
        this.mDisplayName = string;
    }

    public List<SoaTreeNodeImpl> getChildren() {
        return this.mChildren;
    }

    public boolean removeChild(Object object) {
        if (this.mChildren != null) {
            return this.mChildren.remove(object);
        }
        return false;
    }

    public void setChildren(List<SoaTreeNodeImpl> list) {
        this.mChildren = list;
    }

    public Icon getIcon() {
        return this.mIcon;
    }

    public void setIcon(Icon icon) {
        this.mIcon = icon;
    }

    public Boolean isLeaf() {
        return this.mIsLeaf;
    }

    public void setIsLeaf(Boolean bl) {
        this.mIsLeaf = bl;
    }

    public String toString() {
        Object object = this.getDataObject();
        if (object != null) {
            return "TreeNode[" + object.toString() + "]";
        }
        return super.toString();
    }

    public TreePath getTreePath() {
        TreePath treePath = null;
        SoaTreeNodeImpl soaTreeNodeImpl = this.getParent();
        if (soaTreeNodeImpl == null) {
            treePath = new TreePath(this);
        } else {
            TreePath treePath2 = soaTreeNodeImpl.getTreePath();
            assert (treePath2 != null);
            treePath = treePath2.pathByAddingChild(this);
        }
        return treePath;
    }

    public TreeItem getTreeItem() {
        if (this.mTreeItem.get() == null) {
            MyTreeItem myTreeItem = new MyTreeItem(this);
            this.mTreeItem.compareAndSet(null, myTreeItem);
        }
        return this.mTreeItem.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MyTreeItem
    implements TreeItem {
        private SoaTreeNodeImpl mTreeNode;

        public MyTreeItem(SoaTreeNodeImpl soaTreeNodeImpl) {
            this.mTreeNode = soaTreeNodeImpl;
        }

        @Override
        public TreeItem getParent() {
            SoaTreeNodeImpl soaTreeNodeImpl = this.mTreeNode.getParent();
            if (soaTreeNodeImpl != null) {
                return new MyTreeItem(soaTreeNodeImpl);
            }
            return null;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator(){
                private SoaTreeNodeImpl mNextNode;
                {
                    this.mNextNode = MyTreeItem.this.mTreeNode;
                }

                public boolean hasNext() {
                    return this.mNextNode != null;
                }

                public Object next() {
                    assert (this.mNextNode != null);
                    Object object = this.mNextNode.getDataObject();
                    this.mNextNode = this.mNextNode.getParent();
                    return object;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object getDataObject() {
            return this.mTreeNode.getDataObject();
        }

        public String toString() {
            return SoaTreeModel.MyUtils.toString(this);
        }
    }
}

